/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/cssfilter/lib/css.js":
/*!*******************************************!*\
  !*** ./node_modules/cssfilter/lib/css.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * cssfilter
 *
 * @author 老雷<leizongmin@gmail.com>
 */

var DEFAULT = __webpack_require__(/*! ./default */ "./node_modules/cssfilter/lib/default.js");
var parseStyle = __webpack_require__(/*! ./parser */ "./node_modules/cssfilter/lib/parser.js");
var _ = __webpack_require__(/*! ./util */ "./node_modules/cssfilter/lib/util.js");


/**
 * 返回值是否为空
 *
 * @param {Object} obj
 * @return {Boolean}
 */
function isNull (obj) {
  return (obj === undefined || obj === null);
}

/**
 * 浅拷贝对象
 *
 * @param {Object} obj
 * @return {Object}
 */
function shallowCopyObject (obj) {
  var ret = {};
  for (var i in obj) {
    ret[i] = obj[i];
  }
  return ret;
}

/**
 * 创建CSS过滤器
 *
 * @param {Object} options
 *   - {Object} whiteList
 *   - {Function} onAttr
 *   - {Function} onIgnoreAttr
 *   - {Function} safeAttrValue
 */
function FilterCSS (options) {
  options = shallowCopyObject(options || {});
  options.whiteList = options.whiteList || DEFAULT.whiteList;
  options.onAttr = options.onAttr || DEFAULT.onAttr;
  options.onIgnoreAttr = options.onIgnoreAttr || DEFAULT.onIgnoreAttr;
  options.safeAttrValue = options.safeAttrValue || DEFAULT.safeAttrValue;
  this.options = options;
}

FilterCSS.prototype.process = function (css) {
  // 兼容各种奇葩输入
  css = css || '';
  css = css.toString();
  if (!css) return '';

  var me = this;
  var options = me.options;
  var whiteList = options.whiteList;
  var onAttr = options.onAttr;
  var onIgnoreAttr = options.onIgnoreAttr;
  var safeAttrValue = options.safeAttrValue;

  var retCSS = parseStyle(css, function (sourcePosition, position, name, value, source) {

    var check = whiteList[name];
    var isWhite = false;
    if (check === true) isWhite = check;
    else if (typeof check === 'function') isWhite = check(value);
    else if (check instanceof RegExp) isWhite = check.test(value);
    if (isWhite !== true) isWhite = false;

    // 如果过滤后 value 为空则直接忽略
    value = safeAttrValue(name, value);
    if (!value) return;

    var opts = {
      position: position,
      sourcePosition: sourcePosition,
      source: source,
      isWhite: isWhite
    };

    if (isWhite) {

      var ret = onAttr(name, value, opts);
      if (isNull(ret)) {
        return name + ':' + value;
      } else {
        return ret;
      }

    } else {

      var ret = onIgnoreAttr(name, value, opts);
      if (!isNull(ret)) {
        return ret;
      }

    }
  });

  return retCSS;
};


module.exports = FilterCSS;


/***/ }),

/***/ "./node_modules/cssfilter/lib/default.js":
/*!***********************************************!*\
  !*** ./node_modules/cssfilter/lib/default.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, exports) => {

/**
 * cssfilter
 *
 * @author 老雷<leizongmin@gmail.com>
 */

function getDefaultWhiteList () {
  // 白名单值说明：
  // true: 允许该属性
  // Function: function (val) { } 返回true表示允许该属性，其他值均表示不允许
  // RegExp: regexp.test(val) 返回true表示允许该属性，其他值均表示不允许
  // 除上面列出的值外均表示不允许
  var whiteList = {};

  whiteList['align-content'] = false; // default: auto
  whiteList['align-items'] = false; // default: auto
  whiteList['align-self'] = false; // default: auto
  whiteList['alignment-adjust'] = false; // default: auto
  whiteList['alignment-baseline'] = false; // default: baseline
  whiteList['all'] = false; // default: depending on individual properties
  whiteList['anchor-point'] = false; // default: none
  whiteList['animation'] = false; // default: depending on individual properties
  whiteList['animation-delay'] = false; // default: 0
  whiteList['animation-direction'] = false; // default: normal
  whiteList['animation-duration'] = false; // default: 0
  whiteList['animation-fill-mode'] = false; // default: none
  whiteList['animation-iteration-count'] = false; // default: 1
  whiteList['animation-name'] = false; // default: none
  whiteList['animation-play-state'] = false; // default: running
  whiteList['animation-timing-function'] = false; // default: ease
  whiteList['azimuth'] = false; // default: center
  whiteList['backface-visibility'] = false; // default: visible
  whiteList['background'] = true; // default: depending on individual properties
  whiteList['background-attachment'] = true; // default: scroll
  whiteList['background-clip'] = true; // default: border-box
  whiteList['background-color'] = true; // default: transparent
  whiteList['background-image'] = true; // default: none
  whiteList['background-origin'] = true; // default: padding-box
  whiteList['background-position'] = true; // default: 0% 0%
  whiteList['background-repeat'] = true; // default: repeat
  whiteList['background-size'] = true; // default: auto
  whiteList['baseline-shift'] = false; // default: baseline
  whiteList['binding'] = false; // default: none
  whiteList['bleed'] = false; // default: 6pt
  whiteList['bookmark-label'] = false; // default: content()
  whiteList['bookmark-level'] = false; // default: none
  whiteList['bookmark-state'] = false; // default: open
  whiteList['border'] = true; // default: depending on individual properties
  whiteList['border-bottom'] = true; // default: depending on individual properties
  whiteList['border-bottom-color'] = true; // default: current color
  whiteList['border-bottom-left-radius'] = true; // default: 0
  whiteList['border-bottom-right-radius'] = true; // default: 0
  whiteList['border-bottom-style'] = true; // default: none
  whiteList['border-bottom-width'] = true; // default: medium
  whiteList['border-collapse'] = true; // default: separate
  whiteList['border-color'] = true; // default: depending on individual properties
  whiteList['border-image'] = true; // default: none
  whiteList['border-image-outset'] = true; // default: 0
  whiteList['border-image-repeat'] = true; // default: stretch
  whiteList['border-image-slice'] = true; // default: 100%
  whiteList['border-image-source'] = true; // default: none
  whiteList['border-image-width'] = true; // default: 1
  whiteList['border-left'] = true; // default: depending on individual properties
  whiteList['border-left-color'] = true; // default: current color
  whiteList['border-left-style'] = true; // default: none
  whiteList['border-left-width'] = true; // default: medium
  whiteList['border-radius'] = true; // default: 0
  whiteList['border-right'] = true; // default: depending on individual properties
  whiteList['border-right-color'] = true; // default: current color
  whiteList['border-right-style'] = true; // default: none
  whiteList['border-right-width'] = true; // default: medium
  whiteList['border-spacing'] = true; // default: 0
  whiteList['border-style'] = true; // default: depending on individual properties
  whiteList['border-top'] = true; // default: depending on individual properties
  whiteList['border-top-color'] = true; // default: current color
  whiteList['border-top-left-radius'] = true; // default: 0
  whiteList['border-top-right-radius'] = true; // default: 0
  whiteList['border-top-style'] = true; // default: none
  whiteList['border-top-width'] = true; // default: medium
  whiteList['border-width'] = true; // default: depending on individual properties
  whiteList['bottom'] = false; // default: auto
  whiteList['box-decoration-break'] = true; // default: slice
  whiteList['box-shadow'] = true; // default: none
  whiteList['box-sizing'] = true; // default: content-box
  whiteList['box-snap'] = true; // default: none
  whiteList['box-suppress'] = true; // default: show
  whiteList['break-after'] = true; // default: auto
  whiteList['break-before'] = true; // default: auto
  whiteList['break-inside'] = true; // default: auto
  whiteList['caption-side'] = false; // default: top
  whiteList['chains'] = false; // default: none
  whiteList['clear'] = true; // default: none
  whiteList['clip'] = false; // default: auto
  whiteList['clip-path'] = false; // default: none
  whiteList['clip-rule'] = false; // default: nonzero
  whiteList['color'] = true; // default: implementation dependent
  whiteList['color-interpolation-filters'] = true; // default: auto
  whiteList['column-count'] = false; // default: auto
  whiteList['column-fill'] = false; // default: balance
  whiteList['column-gap'] = false; // default: normal
  whiteList['column-rule'] = false; // default: depending on individual properties
  whiteList['column-rule-color'] = false; // default: current color
  whiteList['column-rule-style'] = false; // default: medium
  whiteList['column-rule-width'] = false; // default: medium
  whiteList['column-span'] = false; // default: none
  whiteList['column-width'] = false; // default: auto
  whiteList['columns'] = false; // default: depending on individual properties
  whiteList['contain'] = false; // default: none
  whiteList['content'] = false; // default: normal
  whiteList['counter-increment'] = false; // default: none
  whiteList['counter-reset'] = false; // default: none
  whiteList['counter-set'] = false; // default: none
  whiteList['crop'] = false; // default: auto
  whiteList['cue'] = false; // default: depending on individual properties
  whiteList['cue-after'] = false; // default: none
  whiteList['cue-before'] = false; // default: none
  whiteList['cursor'] = false; // default: auto
  whiteList['direction'] = false; // default: ltr
  whiteList['display'] = true; // default: depending on individual properties
  whiteList['display-inside'] = true; // default: auto
  whiteList['display-list'] = true; // default: none
  whiteList['display-outside'] = true; // default: inline-level
  whiteList['dominant-baseline'] = false; // default: auto
  whiteList['elevation'] = false; // default: level
  whiteList['empty-cells'] = false; // default: show
  whiteList['filter'] = false; // default: none
  whiteList['flex'] = false; // default: depending on individual properties
  whiteList['flex-basis'] = false; // default: auto
  whiteList['flex-direction'] = false; // default: row
  whiteList['flex-flow'] = false; // default: depending on individual properties
  whiteList['flex-grow'] = false; // default: 0
  whiteList['flex-shrink'] = false; // default: 1
  whiteList['flex-wrap'] = false; // default: nowrap
  whiteList['float'] = false; // default: none
  whiteList['float-offset'] = false; // default: 0 0
  whiteList['flood-color'] = false; // default: black
  whiteList['flood-opacity'] = false; // default: 1
  whiteList['flow-from'] = false; // default: none
  whiteList['flow-into'] = false; // default: none
  whiteList['font'] = true; // default: depending on individual properties
  whiteList['font-family'] = true; // default: implementation dependent
  whiteList['font-feature-settings'] = true; // default: normal
  whiteList['font-kerning'] = true; // default: auto
  whiteList['font-language-override'] = true; // default: normal
  whiteList['font-size'] = true; // default: medium
  whiteList['font-size-adjust'] = true; // default: none
  whiteList['font-stretch'] = true; // default: normal
  whiteList['font-style'] = true; // default: normal
  whiteList['font-synthesis'] = true; // default: weight style
  whiteList['font-variant'] = true; // default: normal
  whiteList['font-variant-alternates'] = true; // default: normal
  whiteList['font-variant-caps'] = true; // default: normal
  whiteList['font-variant-east-asian'] = true; // default: normal
  whiteList['font-variant-ligatures'] = true; // default: normal
  whiteList['font-variant-numeric'] = true; // default: normal
  whiteList['font-variant-position'] = true; // default: normal
  whiteList['font-weight'] = true; // default: normal
  whiteList['grid'] = false; // default: depending on individual properties
  whiteList['grid-area'] = false; // default: depending on individual properties
  whiteList['grid-auto-columns'] = false; // default: auto
  whiteList['grid-auto-flow'] = false; // default: none
  whiteList['grid-auto-rows'] = false; // default: auto
  whiteList['grid-column'] = false; // default: depending on individual properties
  whiteList['grid-column-end'] = false; // default: auto
  whiteList['grid-column-start'] = false; // default: auto
  whiteList['grid-row'] = false; // default: depending on individual properties
  whiteList['grid-row-end'] = false; // default: auto
  whiteList['grid-row-start'] = false; // default: auto
  whiteList['grid-template'] = false; // default: depending on individual properties
  whiteList['grid-template-areas'] = false; // default: none
  whiteList['grid-template-columns'] = false; // default: none
  whiteList['grid-template-rows'] = false; // default: none
  whiteList['hanging-punctuation'] = false; // default: none
  whiteList['height'] = true; // default: auto
  whiteList['hyphens'] = false; // default: manual
  whiteList['icon'] = false; // default: auto
  whiteList['image-orientation'] = false; // default: auto
  whiteList['image-resolution'] = false; // default: normal
  whiteList['ime-mode'] = false; // default: auto
  whiteList['initial-letters'] = false; // default: normal
  whiteList['inline-box-align'] = false; // default: last
  whiteList['justify-content'] = false; // default: auto
  whiteList['justify-items'] = false; // default: auto
  whiteList['justify-self'] = false; // default: auto
  whiteList['left'] = false; // default: auto
  whiteList['letter-spacing'] = true; // default: normal
  whiteList['lighting-color'] = true; // default: white
  whiteList['line-box-contain'] = false; // default: block inline replaced
  whiteList['line-break'] = false; // default: auto
  whiteList['line-grid'] = false; // default: match-parent
  whiteList['line-height'] = false; // default: normal
  whiteList['line-snap'] = false; // default: none
  whiteList['line-stacking'] = false; // default: depending on individual properties
  whiteList['line-stacking-ruby'] = false; // default: exclude-ruby
  whiteList['line-stacking-shift'] = false; // default: consider-shifts
  whiteList['line-stacking-strategy'] = false; // default: inline-line-height
  whiteList['list-style'] = true; // default: depending on individual properties
  whiteList['list-style-image'] = true; // default: none
  whiteList['list-style-position'] = true; // default: outside
  whiteList['list-style-type'] = true; // default: disc
  whiteList['margin'] = true; // default: depending on individual properties
  whiteList['margin-bottom'] = true; // default: 0
  whiteList['margin-left'] = true; // default: 0
  whiteList['margin-right'] = true; // default: 0
  whiteList['margin-top'] = true; // default: 0
  whiteList['marker-offset'] = false; // default: auto
  whiteList['marker-side'] = false; // default: list-item
  whiteList['marks'] = false; // default: none
  whiteList['mask'] = false; // default: border-box
  whiteList['mask-box'] = false; // default: see individual properties
  whiteList['mask-box-outset'] = false; // default: 0
  whiteList['mask-box-repeat'] = false; // default: stretch
  whiteList['mask-box-slice'] = false; // default: 0 fill
  whiteList['mask-box-source'] = false; // default: none
  whiteList['mask-box-width'] = false; // default: auto
  whiteList['mask-clip'] = false; // default: border-box
  whiteList['mask-image'] = false; // default: none
  whiteList['mask-origin'] = false; // default: border-box
  whiteList['mask-position'] = false; // default: center
  whiteList['mask-repeat'] = false; // default: no-repeat
  whiteList['mask-size'] = false; // default: border-box
  whiteList['mask-source-type'] = false; // default: auto
  whiteList['mask-type'] = false; // default: luminance
  whiteList['max-height'] = true; // default: none
  whiteList['max-lines'] = false; // default: none
  whiteList['max-width'] = true; // default: none
  whiteList['min-height'] = true; // default: 0
  whiteList['min-width'] = true; // default: 0
  whiteList['move-to'] = false; // default: normal
  whiteList['nav-down'] = false; // default: auto
  whiteList['nav-index'] = false; // default: auto
  whiteList['nav-left'] = false; // default: auto
  whiteList['nav-right'] = false; // default: auto
  whiteList['nav-up'] = false; // default: auto
  whiteList['object-fit'] = false; // default: fill
  whiteList['object-position'] = false; // default: 50% 50%
  whiteList['opacity'] = false; // default: 1
  whiteList['order'] = false; // default: 0
  whiteList['orphans'] = false; // default: 2
  whiteList['outline'] = false; // default: depending on individual properties
  whiteList['outline-color'] = false; // default: invert
  whiteList['outline-offset'] = false; // default: 0
  whiteList['outline-style'] = false; // default: none
  whiteList['outline-width'] = false; // default: medium
  whiteList['overflow'] = false; // default: depending on individual properties
  whiteList['overflow-wrap'] = false; // default: normal
  whiteList['overflow-x'] = false; // default: visible
  whiteList['overflow-y'] = false; // default: visible
  whiteList['padding'] = true; // default: depending on individual properties
  whiteList['padding-bottom'] = true; // default: 0
  whiteList['padding-left'] = true; // default: 0
  whiteList['padding-right'] = true; // default: 0
  whiteList['padding-top'] = true; // default: 0
  whiteList['page'] = false; // default: auto
  whiteList['page-break-after'] = false; // default: auto
  whiteList['page-break-before'] = false; // default: auto
  whiteList['page-break-inside'] = false; // default: auto
  whiteList['page-policy'] = false; // default: start
  whiteList['pause'] = false; // default: implementation dependent
  whiteList['pause-after'] = false; // default: implementation dependent
  whiteList['pause-before'] = false; // default: implementation dependent
  whiteList['perspective'] = false; // default: none
  whiteList['perspective-origin'] = false; // default: 50% 50%
  whiteList['pitch'] = false; // default: medium
  whiteList['pitch-range'] = false; // default: 50
  whiteList['play-during'] = false; // default: auto
  whiteList['position'] = false; // default: static
  whiteList['presentation-level'] = false; // default: 0
  whiteList['quotes'] = false; // default: text
  whiteList['region-fragment'] = false; // default: auto
  whiteList['resize'] = false; // default: none
  whiteList['rest'] = false; // default: depending on individual properties
  whiteList['rest-after'] = false; // default: none
  whiteList['rest-before'] = false; // default: none
  whiteList['richness'] = false; // default: 50
  whiteList['right'] = false; // default: auto
  whiteList['rotation'] = false; // default: 0
  whiteList['rotation-point'] = false; // default: 50% 50%
  whiteList['ruby-align'] = false; // default: auto
  whiteList['ruby-merge'] = false; // default: separate
  whiteList['ruby-position'] = false; // default: before
  whiteList['shape-image-threshold'] = false; // default: 0.0
  whiteList['shape-outside'] = false; // default: none
  whiteList['shape-margin'] = false; // default: 0
  whiteList['size'] = false; // default: auto
  whiteList['speak'] = false; // default: auto
  whiteList['speak-as'] = false; // default: normal
  whiteList['speak-header'] = false; // default: once
  whiteList['speak-numeral'] = false; // default: continuous
  whiteList['speak-punctuation'] = false; // default: none
  whiteList['speech-rate'] = false; // default: medium
  whiteList['stress'] = false; // default: 50
  whiteList['string-set'] = false; // default: none
  whiteList['tab-size'] = false; // default: 8
  whiteList['table-layout'] = false; // default: auto
  whiteList['text-align'] = true; // default: start
  whiteList['text-align-last'] = true; // default: auto
  whiteList['text-combine-upright'] = true; // default: none
  whiteList['text-decoration'] = true; // default: none
  whiteList['text-decoration-color'] = true; // default: currentColor
  whiteList['text-decoration-line'] = true; // default: none
  whiteList['text-decoration-skip'] = true; // default: objects
  whiteList['text-decoration-style'] = true; // default: solid
  whiteList['text-emphasis'] = true; // default: depending on individual properties
  whiteList['text-emphasis-color'] = true; // default: currentColor
  whiteList['text-emphasis-position'] = true; // default: over right
  whiteList['text-emphasis-style'] = true; // default: none
  whiteList['text-height'] = true; // default: auto
  whiteList['text-indent'] = true; // default: 0
  whiteList['text-justify'] = true; // default: auto
  whiteList['text-orientation'] = true; // default: mixed
  whiteList['text-overflow'] = true; // default: clip
  whiteList['text-shadow'] = true; // default: none
  whiteList['text-space-collapse'] = true; // default: collapse
  whiteList['text-transform'] = true; // default: none
  whiteList['text-underline-position'] = true; // default: auto
  whiteList['text-wrap'] = true; // default: normal
  whiteList['top'] = false; // default: auto
  whiteList['transform'] = false; // default: none
  whiteList['transform-origin'] = false; // default: 50% 50% 0
  whiteList['transform-style'] = false; // default: flat
  whiteList['transition'] = false; // default: depending on individual properties
  whiteList['transition-delay'] = false; // default: 0s
  whiteList['transition-duration'] = false; // default: 0s
  whiteList['transition-property'] = false; // default: all
  whiteList['transition-timing-function'] = false; // default: ease
  whiteList['unicode-bidi'] = false; // default: normal
  whiteList['vertical-align'] = false; // default: baseline
  whiteList['visibility'] = false; // default: visible
  whiteList['voice-balance'] = false; // default: center
  whiteList['voice-duration'] = false; // default: auto
  whiteList['voice-family'] = false; // default: implementation dependent
  whiteList['voice-pitch'] = false; // default: medium
  whiteList['voice-range'] = false; // default: medium
  whiteList['voice-rate'] = false; // default: normal
  whiteList['voice-stress'] = false; // default: normal
  whiteList['voice-volume'] = false; // default: medium
  whiteList['volume'] = false; // default: medium
  whiteList['white-space'] = false; // default: normal
  whiteList['widows'] = false; // default: 2
  whiteList['width'] = true; // default: auto
  whiteList['will-change'] = false; // default: auto
  whiteList['word-break'] = true; // default: normal
  whiteList['word-spacing'] = true; // default: normal
  whiteList['word-wrap'] = true; // default: normal
  whiteList['wrap-flow'] = false; // default: auto
  whiteList['wrap-through'] = false; // default: wrap
  whiteList['writing-mode'] = false; // default: horizontal-tb
  whiteList['z-index'] = false; // default: auto

  return whiteList;
}


/**
 * 匹配到白名单上的一个属性时
 *
 * @param {String} name
 * @param {String} value
 * @param {Object} options
 * @return {String}
 */
function onAttr (name, value, options) {
  // do nothing
}

/**
 * 匹配到不在白名单上的一个属性时
 *
 * @param {String} name
 * @param {String} value
 * @param {Object} options
 * @return {String}
 */
function onIgnoreAttr (name, value, options) {
  // do nothing
}

var REGEXP_URL_JAVASCRIPT = /javascript\s*\:/img;

/**
 * 过滤属性值
 *
 * @param {String} name
 * @param {String} value
 * @return {String}
 */
function safeAttrValue(name, value) {
  if (REGEXP_URL_JAVASCRIPT.test(value)) return '';
  return value;
}


exports.whiteList = getDefaultWhiteList();
exports.getDefaultWhiteList = getDefaultWhiteList;
exports.onAttr = onAttr;
exports.onIgnoreAttr = onIgnoreAttr;
exports.safeAttrValue = safeAttrValue;


/***/ }),

/***/ "./node_modules/cssfilter/lib/index.js":
/*!*********************************************!*\
  !*** ./node_modules/cssfilter/lib/index.js ***!
  \*********************************************/
/***/ ((module, exports, __webpack_require__) => {

/**
 * cssfilter
 *
 * @author 老雷<leizongmin@gmail.com>
 */

var DEFAULT = __webpack_require__(/*! ./default */ "./node_modules/cssfilter/lib/default.js");
var FilterCSS = __webpack_require__(/*! ./css */ "./node_modules/cssfilter/lib/css.js");


/**
 * XSS过滤
 *
 * @param {String} css 要过滤的CSS代码
 * @param {Object} options 选项：whiteList, onAttr, onIgnoreAttr
 * @return {String}
 */
function filterCSS (html, options) {
  var xss = new FilterCSS(options);
  return xss.process(html);
}


// 输出
exports = module.exports = filterCSS;
exports.FilterCSS = FilterCSS;
for (var i in DEFAULT) exports[i] = DEFAULT[i];

// 在浏览器端使用
if (typeof window !== 'undefined') {
  window.filterCSS = module.exports;
}


/***/ }),

/***/ "./node_modules/cssfilter/lib/parser.js":
/*!**********************************************!*\
  !*** ./node_modules/cssfilter/lib/parser.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * cssfilter
 *
 * @author 老雷<leizongmin@gmail.com>
 */

var _ = __webpack_require__(/*! ./util */ "./node_modules/cssfilter/lib/util.js");


/**
 * 解析style
 *
 * @param {String} css
 * @param {Function} onAttr 处理属性的函数
 *   参数格式： function (sourcePosition, position, name, value, source)
 * @return {String}
 */
function parseStyle (css, onAttr) {
  css = _.trimRight(css);
  if (css[css.length - 1] !== ';') css += ';';
  var cssLength = css.length;
  var isParenthesisOpen = false;
  var lastPos = 0;
  var i = 0;
  var retCSS = '';

  function addNewAttr () {
    // 如果没有正常的闭合圆括号，则直接忽略当前属性
    if (!isParenthesisOpen) {
      var source = _.trim(css.slice(lastPos, i));
      var j = source.indexOf(':');
      if (j !== -1) {
        var name = _.trim(source.slice(0, j));
        var value = _.trim(source.slice(j + 1));
        // 必须有属性名称
        if (name) {
          var ret = onAttr(lastPos, retCSS.length, name, value, source);
          if (ret) retCSS += ret + '; ';
        }
      }
    }
    lastPos = i + 1;
  }

  for (; i < cssLength; i++) {
    var c = css[i];
    if (c === '/' && css[i + 1] === '*') {
      // 备注开始
      var j = css.indexOf('*/', i + 2);
      // 如果没有正常的备注结束，则后面的部分全部跳过
      if (j === -1) break;
      // 直接将当前位置调到备注结尾，并且初始化状态
      i = j + 1;
      lastPos = i + 1;
      isParenthesisOpen = false;
    } else if (c === '(') {
      isParenthesisOpen = true;
    } else if (c === ')') {
      isParenthesisOpen = false;
    } else if (c === ';') {
      if (isParenthesisOpen) {
        // 在圆括号里面，忽略
      } else {
        addNewAttr();
      }
    } else if (c === '\n') {
      addNewAttr();
    }
  }

  return _.trim(retCSS);
}

module.exports = parseStyle;


/***/ }),

/***/ "./node_modules/cssfilter/lib/util.js":
/*!********************************************!*\
  !*** ./node_modules/cssfilter/lib/util.js ***!
  \********************************************/
/***/ ((module) => {

module.exports = {
  indexOf: function (arr, item) {
    var i, j;
    if (Array.prototype.indexOf) {
      return arr.indexOf(item);
    }
    for (i = 0, j = arr.length; i < j; i++) {
      if (arr[i] === item) {
        return i;
      }
    }
    return -1;
  },
  forEach: function (arr, fn, scope) {
    var i, j;
    if (Array.prototype.forEach) {
      return arr.forEach(fn, scope);
    }
    for (i = 0, j = arr.length; i < j; i++) {
      fn.call(scope, arr[i], i, arr);
    }
  },
  trim: function (str) {
    if (String.prototype.trim) {
      return str.trim();
    }
    return str.replace(/(^\s*)|(\s*$)/g, '');
  },
  trimRight: function (str) {
    if (String.prototype.trimRight) {
      return str.trimRight();
    }
    return str.replace(/(\s*$)/g, '');
  }
};


/***/ }),

/***/ "./node_modules/xss/lib/default.js":
/*!*****************************************!*\
  !*** ./node_modules/xss/lib/default.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/**
 * default settings
 *
 * @author Zongmin Lei<leizongmin@gmail.com>
 */

var FilterCSS = (__webpack_require__(/*! cssfilter */ "./node_modules/cssfilter/lib/index.js").FilterCSS);
var getDefaultCSSWhiteList = (__webpack_require__(/*! cssfilter */ "./node_modules/cssfilter/lib/index.js").getDefaultWhiteList);
var _ = __webpack_require__(/*! ./util */ "./node_modules/xss/lib/util.js");

function getDefaultWhiteList() {
  return {
    a: ["target", "href", "title"],
    abbr: ["title"],
    address: [],
    area: ["shape", "coords", "href", "alt"],
    article: [],
    aside: [],
    audio: [
      "autoplay",
      "controls",
      "crossorigin",
      "loop",
      "muted",
      "preload",
      "src",
    ],
    b: [],
    bdi: ["dir"],
    bdo: ["dir"],
    big: [],
    blockquote: ["cite"],
    br: [],
    caption: [],
    center: [],
    cite: [],
    code: [],
    col: ["align", "valign", "span", "width"],
    colgroup: ["align", "valign", "span", "width"],
    dd: [],
    del: ["datetime"],
    details: ["open"],
    div: [],
    dl: [],
    dt: [],
    em: [],
    figcaption: [],
    figure: [],
    font: ["color", "size", "face"],
    footer: [],
    h1: [],
    h2: [],
    h3: [],
    h4: [],
    h5: [],
    h6: [],
    header: [],
    hr: [],
    i: [],
    img: ["src", "alt", "title", "width", "height", "loading"],
    ins: ["datetime"],
    kbd: [],
    li: [],
    mark: [],
    nav: [],
    ol: [],
    p: [],
    pre: [],
    s: [],
    section: [],
    small: [],
    span: [],
    sub: [],
    summary: [],
    sup: [],
    strong: [],
    strike: [],
    table: ["width", "border", "align", "valign"],
    tbody: ["align", "valign"],
    td: ["width", "rowspan", "colspan", "align", "valign"],
    tfoot: ["align", "valign"],
    th: ["width", "rowspan", "colspan", "align", "valign"],
    thead: ["align", "valign"],
    tr: ["rowspan", "align", "valign"],
    tt: [],
    u: [],
    ul: [],
    video: [
      "autoplay",
      "controls",
      "crossorigin",
      "loop",
      "muted",
      "playsinline",
      "poster",
      "preload",
      "src",
      "height",
      "width",
    ],
  };
}

var defaultCSSFilter = new FilterCSS();

/**
 * default onTag function
 *
 * @param {String} tag
 * @param {String} html
 * @param {Object} options
 * @return {String}
 */
function onTag(tag, html, options) {
  // do nothing
}

/**
 * default onIgnoreTag function
 *
 * @param {String} tag
 * @param {String} html
 * @param {Object} options
 * @return {String}
 */
function onIgnoreTag(tag, html, options) {
  // do nothing
}

/**
 * default onTagAttr function
 *
 * @param {String} tag
 * @param {String} name
 * @param {String} value
 * @return {String}
 */
function onTagAttr(tag, name, value) {
  // do nothing
}

/**
 * default onIgnoreTagAttr function
 *
 * @param {String} tag
 * @param {String} name
 * @param {String} value
 * @return {String}
 */
function onIgnoreTagAttr(tag, name, value) {
  // do nothing
}

/**
 * default escapeHtml function
 *
 * @param {String} html
 */
function escapeHtml(html) {
  return html.replace(REGEXP_LT, "&lt;").replace(REGEXP_GT, "&gt;");
}

/**
 * default safeAttrValue function
 *
 * @param {String} tag
 * @param {String} name
 * @param {String} value
 * @param {Object} cssFilter
 * @return {String}
 */
function safeAttrValue(tag, name, value, cssFilter) {
  // unescape attribute value firstly
  value = friendlyAttrValue(value);

  if (name === "href" || name === "src") {
    // filter `href` and `src` attribute
    // only allow the value that starts with `http://` | `https://` | `mailto:` | `/` | `#`
    value = _.trim(value);
    if (value === "#") return "#";
    if (
      !(
        value.substr(0, 7) === "http://" ||
        value.substr(0, 8) === "https://" ||
        value.substr(0, 7) === "mailto:" ||
        value.substr(0, 4) === "tel:" ||
        value.substr(0, 11) === "data:image/" ||
        value.substr(0, 6) === "ftp://" ||
        value.substr(0, 2) === "./" ||
        value.substr(0, 3) === "../" ||
        value[0] === "#" ||
        value[0] === "/"
      )
    ) {
      return "";
    }
  } else if (name === "background") {
    // filter `background` attribute (maybe no use)
    // `javascript:`
    REGEXP_DEFAULT_ON_TAG_ATTR_4.lastIndex = 0;
    if (REGEXP_DEFAULT_ON_TAG_ATTR_4.test(value)) {
      return "";
    }
  } else if (name === "style") {
    // `expression()`
    REGEXP_DEFAULT_ON_TAG_ATTR_7.lastIndex = 0;
    if (REGEXP_DEFAULT_ON_TAG_ATTR_7.test(value)) {
      return "";
    }
    // `url()`
    REGEXP_DEFAULT_ON_TAG_ATTR_8.lastIndex = 0;
    if (REGEXP_DEFAULT_ON_TAG_ATTR_8.test(value)) {
      REGEXP_DEFAULT_ON_TAG_ATTR_4.lastIndex = 0;
      if (REGEXP_DEFAULT_ON_TAG_ATTR_4.test(value)) {
        return "";
      }
    }
    if (cssFilter !== false) {
      cssFilter = cssFilter || defaultCSSFilter;
      value = cssFilter.process(value);
    }
  }

  // escape `<>"` before returns
  value = escapeAttrValue(value);
  return value;
}

// RegExp list
var REGEXP_LT = /</g;
var REGEXP_GT = />/g;
var REGEXP_QUOTE = /"/g;
var REGEXP_QUOTE_2 = /&quot;/g;
var REGEXP_ATTR_VALUE_1 = /&#([a-zA-Z0-9]*);?/gim;
var REGEXP_ATTR_VALUE_COLON = /&colon;?/gim;
var REGEXP_ATTR_VALUE_NEWLINE = /&newline;?/gim;
// var REGEXP_DEFAULT_ON_TAG_ATTR_3 = /\/\*|\*\//gm;
var REGEXP_DEFAULT_ON_TAG_ATTR_4 =
  /((j\s*a\s*v\s*a|v\s*b|l\s*i\s*v\s*e)\s*s\s*c\s*r\s*i\s*p\s*t\s*|m\s*o\s*c\s*h\s*a):/gi;
// var REGEXP_DEFAULT_ON_TAG_ATTR_5 = /^[\s"'`]*(d\s*a\s*t\s*a\s*)\:/gi;
// var REGEXP_DEFAULT_ON_TAG_ATTR_6 = /^[\s"'`]*(d\s*a\s*t\s*a\s*)\:\s*image\//gi;
var REGEXP_DEFAULT_ON_TAG_ATTR_7 =
  /e\s*x\s*p\s*r\s*e\s*s\s*s\s*i\s*o\s*n\s*\(.*/gi;
var REGEXP_DEFAULT_ON_TAG_ATTR_8 = /u\s*r\s*l\s*\(.*/gi;

/**
 * escape double quote
 *
 * @param {String} str
 * @return {String} str
 */
function escapeQuote(str) {
  return str.replace(REGEXP_QUOTE, "&quot;");
}

/**
 * unescape double quote
 *
 * @param {String} str
 * @return {String} str
 */
function unescapeQuote(str) {
  return str.replace(REGEXP_QUOTE_2, '"');
}

/**
 * escape html entities
 *
 * @param {String} str
 * @return {String}
 */
function escapeHtmlEntities(str) {
  return str.replace(REGEXP_ATTR_VALUE_1, function replaceUnicode(str, code) {
    return code[0] === "x" || code[0] === "X"
      ? String.fromCharCode(parseInt(code.substr(1), 16))
      : String.fromCharCode(parseInt(code, 10));
  });
}

/**
 * escape html5 new danger entities
 *
 * @param {String} str
 * @return {String}
 */
function escapeDangerHtml5Entities(str) {
  return str
    .replace(REGEXP_ATTR_VALUE_COLON, ":")
    .replace(REGEXP_ATTR_VALUE_NEWLINE, " ");
}

/**
 * clear nonprintable characters
 *
 * @param {String} str
 * @return {String}
 */
function clearNonPrintableCharacter(str) {
  var str2 = "";
  for (var i = 0, len = str.length; i < len; i++) {
    str2 += str.charCodeAt(i) < 32 ? " " : str.charAt(i);
  }
  return _.trim(str2);
}

/**
 * get friendly attribute value
 *
 * @param {String} str
 * @return {String}
 */
function friendlyAttrValue(str) {
  str = unescapeQuote(str);
  str = escapeHtmlEntities(str);
  str = escapeDangerHtml5Entities(str);
  str = clearNonPrintableCharacter(str);
  return str;
}

/**
 * unescape attribute value
 *
 * @param {String} str
 * @return {String}
 */
function escapeAttrValue(str) {
  str = escapeQuote(str);
  str = escapeHtml(str);
  return str;
}

/**
 * `onIgnoreTag` function for removing all the tags that are not in whitelist
 */
function onIgnoreTagStripAll() {
  return "";
}

/**
 * remove tag body
 * specify a `tags` list, if the tag is not in the `tags` list then process by the specify function (optional)
 *
 * @param {array} tags
 * @param {function} next
 */
function StripTagBody(tags, next) {
  if (typeof next !== "function") {
    next = function () {};
  }

  var isRemoveAllTag = !Array.isArray(tags);
  function isRemoveTag(tag) {
    if (isRemoveAllTag) return true;
    return _.indexOf(tags, tag) !== -1;
  }

  var removeList = [];
  var posStart = false;

  return {
    onIgnoreTag: function (tag, html, options) {
      if (isRemoveTag(tag)) {
        if (options.isClosing) {
          var ret = "[/removed]";
          var end = options.position + ret.length;
          removeList.push([
            posStart !== false ? posStart : options.position,
            end,
          ]);
          posStart = false;
          return ret;
        } else {
          if (!posStart) {
            posStart = options.position;
          }
          return "[removed]";
        }
      } else {
        return next(tag, html, options);
      }
    },
    remove: function (html) {
      var rethtml = "";
      var lastPos = 0;
      _.forEach(removeList, function (pos) {
        rethtml += html.slice(lastPos, pos[0]);
        lastPos = pos[1];
      });
      rethtml += html.slice(lastPos);
      return rethtml;
    },
  };
}

/**
 * remove html comments
 *
 * @param {String} html
 * @return {String}
 */
function stripCommentTag(html) {
  var retHtml = "";
  var lastPos = 0;
  while (lastPos < html.length) {
    var i = html.indexOf("<!--", lastPos);
    if (i === -1) {
      retHtml += html.slice(lastPos);
      break;
    }
    retHtml += html.slice(lastPos, i);
    var j = html.indexOf("-->", i);
    if (j === -1) {
      break;
    }
    lastPos = j + 3;
  }
  return retHtml;
}

/**
 * remove invisible characters
 *
 * @param {String} html
 * @return {String}
 */
function stripBlankChar(html) {
  var chars = html.split("");
  chars = chars.filter(function (char) {
    var c = char.charCodeAt(0);
    if (c === 127) return false;
    if (c <= 31) {
      if (c === 10 || c === 13) return true;
      return false;
    }
    return true;
  });
  return chars.join("");
}

exports.whiteList = getDefaultWhiteList();
exports.getDefaultWhiteList = getDefaultWhiteList;
exports.onTag = onTag;
exports.onIgnoreTag = onIgnoreTag;
exports.onTagAttr = onTagAttr;
exports.onIgnoreTagAttr = onIgnoreTagAttr;
exports.safeAttrValue = safeAttrValue;
exports.escapeHtml = escapeHtml;
exports.escapeQuote = escapeQuote;
exports.unescapeQuote = unescapeQuote;
exports.escapeHtmlEntities = escapeHtmlEntities;
exports.escapeDangerHtml5Entities = escapeDangerHtml5Entities;
exports.clearNonPrintableCharacter = clearNonPrintableCharacter;
exports.friendlyAttrValue = friendlyAttrValue;
exports.escapeAttrValue = escapeAttrValue;
exports.onIgnoreTagStripAll = onIgnoreTagStripAll;
exports.StripTagBody = StripTagBody;
exports.stripCommentTag = stripCommentTag;
exports.stripBlankChar = stripBlankChar;
exports.attributeWrapSign = '"';
exports.cssFilter = defaultCSSFilter;
exports.getDefaultCSSWhiteList = getDefaultCSSWhiteList;


/***/ }),

/***/ "./node_modules/xss/lib/index.js":
/*!***************************************!*\
  !*** ./node_modules/xss/lib/index.js ***!
  \***************************************/
/***/ ((module, exports, __webpack_require__) => {

/**
 * xss
 *
 * @author Zongmin Lei<leizongmin@gmail.com>
 */

var DEFAULT = __webpack_require__(/*! ./default */ "./node_modules/xss/lib/default.js");
var parser = __webpack_require__(/*! ./parser */ "./node_modules/xss/lib/parser.js");
var FilterXSS = __webpack_require__(/*! ./xss */ "./node_modules/xss/lib/xss.js");

/**
 * filter xss function
 *
 * @param {String} html
 * @param {Object} options { whiteList, onTag, onTagAttr, onIgnoreTag, onIgnoreTagAttr, safeAttrValue, escapeHtml }
 * @return {String}
 */
function filterXSS(html, options) {
  var xss = new FilterXSS(options);
  return xss.process(html);
}

exports = module.exports = filterXSS;
exports.filterXSS = filterXSS;
exports.FilterXSS = FilterXSS;

(function () {
  for (var i in DEFAULT) {
    exports[i] = DEFAULT[i];
  }
  for (var j in parser) {
    exports[j] = parser[j];
  }
})();

// using `xss` on the browser, output `filterXSS` to the globals
if (typeof window !== "undefined") {
  window.filterXSS = module.exports;
}

// using `xss` on the WebWorker, output `filterXSS` to the globals
function isWorkerEnv() {
  return (
    typeof self !== "undefined" &&
    typeof DedicatedWorkerGlobalScope !== "undefined" &&
    self instanceof DedicatedWorkerGlobalScope
  );
}
if (isWorkerEnv()) {
  self.filterXSS = module.exports;
}


/***/ }),

/***/ "./node_modules/xss/lib/parser.js":
/*!****************************************!*\
  !*** ./node_modules/xss/lib/parser.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/**
 * Simple HTML Parser
 *
 * @author Zongmin Lei<leizongmin@gmail.com>
 */

var _ = __webpack_require__(/*! ./util */ "./node_modules/xss/lib/util.js");

/**
 * get tag name
 *
 * @param {String} html e.g. '<a hef="#">'
 * @return {String}
 */
function getTagName(html) {
  var i = _.spaceIndex(html);
  var tagName;
  if (i === -1) {
    tagName = html.slice(1, -1);
  } else {
    tagName = html.slice(1, i + 1);
  }
  tagName = _.trim(tagName).toLowerCase();
  if (tagName.slice(0, 1) === "/") tagName = tagName.slice(1);
  if (tagName.slice(-1) === "/") tagName = tagName.slice(0, -1);
  return tagName;
}

/**
 * is close tag?
 *
 * @param {String} html 如：'<a hef="#">'
 * @return {Boolean}
 */
function isClosing(html) {
  return html.slice(0, 2) === "</";
}

/**
 * parse input html and returns processed html
 *
 * @param {String} html
 * @param {Function} onTag e.g. function (sourcePosition, position, tag, html, isClosing)
 * @param {Function} escapeHtml
 * @return {String}
 */
function parseTag(html, onTag, escapeHtml) {
  "use strict";

  var rethtml = "";
  var lastPos = 0;
  var tagStart = false;
  var quoteStart = false;
  var currentPos = 0;
  var len = html.length;
  var currentTagName = "";
  var currentHtml = "";

  chariterator: for (currentPos = 0; currentPos < len; currentPos++) {
    var c = html.charAt(currentPos);
    if (tagStart === false) {
      if (c === "<") {
        tagStart = currentPos;
        continue;
      }
    } else {
      if (quoteStart === false) {
        if (c === "<") {
          rethtml += escapeHtml(html.slice(lastPos, currentPos));
          tagStart = currentPos;
          lastPos = currentPos;
          continue;
        }
        if (c === ">" || currentPos === len - 1) {
          rethtml += escapeHtml(html.slice(lastPos, tagStart));
          currentHtml = html.slice(tagStart, currentPos + 1);
          currentTagName = getTagName(currentHtml);
          rethtml += onTag(
            tagStart,
            rethtml.length,
            currentTagName,
            currentHtml,
            isClosing(currentHtml)
          );
          lastPos = currentPos + 1;
          tagStart = false;
          continue;
        }
        if (c === '"' || c === "'") {
          var i = 1;
          var ic = html.charAt(currentPos - i);

          while (ic.trim() === "" || ic === "=") {
            if (ic === "=") {
              quoteStart = c;
              continue chariterator;
            }
            ic = html.charAt(currentPos - ++i);
          }
        }
      } else {
        if (c === quoteStart) {
          quoteStart = false;
          continue;
        }
      }
    }
  }
  if (lastPos < len) {
    rethtml += escapeHtml(html.substr(lastPos));
  }

  return rethtml;
}

var REGEXP_ILLEGAL_ATTR_NAME = /[^a-zA-Z0-9\\_:.-]/gim;

/**
 * parse input attributes and returns processed attributes
 *
 * @param {String} html e.g. `href="#" target="_blank"`
 * @param {Function} onAttr e.g. `function (name, value)`
 * @return {String}
 */
function parseAttr(html, onAttr) {
  "use strict";

  var lastPos = 0;
  var lastMarkPos = 0;
  var retAttrs = [];
  var tmpName = false;
  var len = html.length;

  function addAttr(name, value) {
    name = _.trim(name);
    name = name.replace(REGEXP_ILLEGAL_ATTR_NAME, "").toLowerCase();
    if (name.length < 1) return;
    var ret = onAttr(name, value || "");
    if (ret) retAttrs.push(ret);
  }

  // 逐个分析字符
  for (var i = 0; i < len; i++) {
    var c = html.charAt(i);
    var v, j;
    if (tmpName === false && c === "=") {
      tmpName = html.slice(lastPos, i);
      lastPos = i + 1;
      lastMarkPos = html.charAt(lastPos) === '"' || html.charAt(lastPos) === "'" ? lastPos : findNextQuotationMark(html, i + 1);
      continue;
    }
    if (tmpName !== false) {
      if (
        i === lastMarkPos
      ) {
        j = html.indexOf(c, i + 1);
        if (j === -1) {
          break;
        } else {
          v = _.trim(html.slice(lastMarkPos + 1, j));
          addAttr(tmpName, v);
          tmpName = false;
          i = j;
          lastPos = i + 1;
          continue;
        }
      }
    }
    if (/\s|\n|\t/.test(c)) {
      html = html.replace(/\s|\n|\t/g, " ");
      if (tmpName === false) {
        j = findNextEqual(html, i);
        if (j === -1) {
          v = _.trim(html.slice(lastPos, i));
          addAttr(v);
          tmpName = false;
          lastPos = i + 1;
          continue;
        } else {
          i = j - 1;
          continue;
        }
      } else {
        j = findBeforeEqual(html, i - 1);
        if (j === -1) {
          v = _.trim(html.slice(lastPos, i));
          v = stripQuoteWrap(v);
          addAttr(tmpName, v);
          tmpName = false;
          lastPos = i + 1;
          continue;
        } else {
          continue;
        }
      }
    }
  }

  if (lastPos < html.length) {
    if (tmpName === false) {
      addAttr(html.slice(lastPos));
    } else {
      addAttr(tmpName, stripQuoteWrap(_.trim(html.slice(lastPos))));
    }
  }

  return _.trim(retAttrs.join(" "));
}

function findNextEqual(str, i) {
  for (; i < str.length; i++) {
    var c = str[i];
    if (c === " ") continue;
    if (c === "=") return i;
    return -1;
  }
}

function findNextQuotationMark(str, i) {
  for (; i < str.length; i++) {
    var c = str[i];
    if (c === " ") continue;
    if (c === "'" || c === '"') return i;
    return -1;
  }
}

function findBeforeEqual(str, i) {
  for (; i > 0; i--) {
    var c = str[i];
    if (c === " ") continue;
    if (c === "=") return i;
    return -1;
  }
}

function isQuoteWrapString(text) {
  if (
    (text[0] === '"' && text[text.length - 1] === '"') ||
    (text[0] === "'" && text[text.length - 1] === "'")
  ) {
    return true;
  } else {
    return false;
  }
}

function stripQuoteWrap(text) {
  if (isQuoteWrapString(text)) {
    return text.substr(1, text.length - 2);
  } else {
    return text;
  }
}

exports.parseTag = parseTag;
exports.parseAttr = parseAttr;


/***/ }),

/***/ "./node_modules/xss/lib/util.js":
/*!**************************************!*\
  !*** ./node_modules/xss/lib/util.js ***!
  \**************************************/
/***/ ((module) => {

module.exports = {
  indexOf: function (arr, item) {
    var i, j;
    if (Array.prototype.indexOf) {
      return arr.indexOf(item);
    }
    for (i = 0, j = arr.length; i < j; i++) {
      if (arr[i] === item) {
        return i;
      }
    }
    return -1;
  },
  forEach: function (arr, fn, scope) {
    var i, j;
    if (Array.prototype.forEach) {
      return arr.forEach(fn, scope);
    }
    for (i = 0, j = arr.length; i < j; i++) {
      fn.call(scope, arr[i], i, arr);
    }
  },
  trim: function (str) {
    if (String.prototype.trim) {
      return str.trim();
    }
    return str.replace(/(^\s*)|(\s*$)/g, "");
  },
  spaceIndex: function (str) {
    var reg = /\s|\n|\t/;
    var match = reg.exec(str);
    return match ? match.index : -1;
  },
};


/***/ }),

/***/ "./node_modules/xss/lib/xss.js":
/*!*************************************!*\
  !*** ./node_modules/xss/lib/xss.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * filter xss
 *
 * @author Zongmin Lei<leizongmin@gmail.com>
 */

var FilterCSS = (__webpack_require__(/*! cssfilter */ "./node_modules/cssfilter/lib/index.js").FilterCSS);
var DEFAULT = __webpack_require__(/*! ./default */ "./node_modules/xss/lib/default.js");
var parser = __webpack_require__(/*! ./parser */ "./node_modules/xss/lib/parser.js");
var parseTag = parser.parseTag;
var parseAttr = parser.parseAttr;
var _ = __webpack_require__(/*! ./util */ "./node_modules/xss/lib/util.js");

/**
 * returns `true` if the input value is `undefined` or `null`
 *
 * @param {Object} obj
 * @return {Boolean}
 */
function isNull(obj) {
  return obj === undefined || obj === null;
}

/**
 * get attributes for a tag
 *
 * @param {String} html
 * @return {Object}
 *   - {String} html
 *   - {Boolean} closing
 */
function getAttrs(html) {
  var i = _.spaceIndex(html);
  if (i === -1) {
    return {
      html: "",
      closing: html[html.length - 2] === "/",
    };
  }
  html = _.trim(html.slice(i + 1, -1));
  var isClosing = html[html.length - 1] === "/";
  if (isClosing) html = _.trim(html.slice(0, -1));
  return {
    html: html,
    closing: isClosing,
  };
}

/**
 * shallow copy
 *
 * @param {Object} obj
 * @return {Object}
 */
function shallowCopyObject(obj) {
  var ret = {};
  for (var i in obj) {
    ret[i] = obj[i];
  }
  return ret;
}

function keysToLowerCase(obj) {
  var ret = {};
  for (var i in obj) {
    if (Array.isArray(obj[i])) {
      ret[i.toLowerCase()] = obj[i].map(function (item) {
        return item.toLowerCase();
      });
    } else {
      ret[i.toLowerCase()] = obj[i];
    }
  }
  return ret;
}

/**
 * FilterXSS class
 *
 * @param {Object} options
 *        whiteList (or allowList), onTag, onTagAttr, onIgnoreTag,
 *        onIgnoreTagAttr, safeAttrValue, escapeHtml
 *        stripIgnoreTagBody, allowCommentTag, stripBlankChar
 *        css{whiteList, onAttr, onIgnoreAttr} `css=false` means don't use `cssfilter`
 */
function FilterXSS(options) {
  options = shallowCopyObject(options || {});

  if (options.stripIgnoreTag) {
    if (options.onIgnoreTag) {
      console.error(
        'Notes: cannot use these two options "stripIgnoreTag" and "onIgnoreTag" at the same time'
      );
    }
    options.onIgnoreTag = DEFAULT.onIgnoreTagStripAll;
  }
  if (options.whiteList || options.allowList) {
    options.whiteList = keysToLowerCase(options.whiteList || options.allowList);
  } else {
    options.whiteList = DEFAULT.whiteList;
  }

  this.attributeWrapSign = options.singleQuotedAttributeValue === true ? "'" : DEFAULT.attributeWrapSign;

  options.onTag = options.onTag || DEFAULT.onTag;
  options.onTagAttr = options.onTagAttr || DEFAULT.onTagAttr;
  options.onIgnoreTag = options.onIgnoreTag || DEFAULT.onIgnoreTag;
  options.onIgnoreTagAttr = options.onIgnoreTagAttr || DEFAULT.onIgnoreTagAttr;
  options.safeAttrValue = options.safeAttrValue || DEFAULT.safeAttrValue;
  options.escapeHtml = options.escapeHtml || DEFAULT.escapeHtml;
  this.options = options;

  if (options.css === false) {
    this.cssFilter = false;
  } else {
    options.css = options.css || {};
    this.cssFilter = new FilterCSS(options.css);
  }
}

/**
 * start process and returns result
 *
 * @param {String} html
 * @return {String}
 */
FilterXSS.prototype.process = function (html) {
  // compatible with the input
  html = html || "";
  html = html.toString();
  if (!html) return "";

  var me = this;
  var options = me.options;
  var whiteList = options.whiteList;
  var onTag = options.onTag;
  var onIgnoreTag = options.onIgnoreTag;
  var onTagAttr = options.onTagAttr;
  var onIgnoreTagAttr = options.onIgnoreTagAttr;
  var safeAttrValue = options.safeAttrValue;
  var escapeHtml = options.escapeHtml;
  var attributeWrapSign = me.attributeWrapSign;
  var cssFilter = me.cssFilter;

  // remove invisible characters
  if (options.stripBlankChar) {
    html = DEFAULT.stripBlankChar(html);
  }

  // remove html comments
  if (!options.allowCommentTag) {
    html = DEFAULT.stripCommentTag(html);
  }

  // if enable stripIgnoreTagBody
  var stripIgnoreTagBody = false;
  if (options.stripIgnoreTagBody) {
    stripIgnoreTagBody = DEFAULT.StripTagBody(
      options.stripIgnoreTagBody,
      onIgnoreTag
    );
    onIgnoreTag = stripIgnoreTagBody.onIgnoreTag;
  }

  var retHtml = parseTag(
    html,
    function (sourcePosition, position, tag, html, isClosing) {
      var info = {
        sourcePosition: sourcePosition,
        position: position,
        isClosing: isClosing,
        isWhite: Object.prototype.hasOwnProperty.call(whiteList, tag),
      };

      // call `onTag()`
      var ret = onTag(tag, html, info);
      if (!isNull(ret)) return ret;

      if (info.isWhite) {
        if (info.isClosing) {
          return "</" + tag + ">";
        }

        var attrs = getAttrs(html);
        var whiteAttrList = whiteList[tag];
        var attrsHtml = parseAttr(attrs.html, function (name, value) {
          // call `onTagAttr()`
          var isWhiteAttr = _.indexOf(whiteAttrList, name) !== -1;
          var ret = onTagAttr(tag, name, value, isWhiteAttr);
          if (!isNull(ret)) return ret;

          if (isWhiteAttr) {
            // call `safeAttrValue()`
            value = safeAttrValue(tag, name, value, cssFilter);
            if (value) {
              return name + '=' + attributeWrapSign + value + attributeWrapSign;
            } else {
              return name;
            }
          } else {
            // call `onIgnoreTagAttr()`
            ret = onIgnoreTagAttr(tag, name, value, isWhiteAttr);
            if (!isNull(ret)) return ret;
            return;
          }
        });

        // build new tag html
        html = "<" + tag;
        if (attrsHtml) html += " " + attrsHtml;
        if (attrs.closing) html += " /";
        html += ">";
        return html;
      } else {
        // call `onIgnoreTag()`
        ret = onIgnoreTag(tag, html, info);
        if (!isNull(ret)) return ret;
        return escapeHtml(html);
      }
    },
    escapeHtml
  );

  // if enable stripIgnoreTagBody
  if (stripIgnoreTagBody) {
    retHtml = stripIgnoreTagBody.remove(retHtml);
  }

  return retHtml;
};

module.exports = FilterXSS;


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
/*!**************************!*\
  !*** ./js/sb-youtube.js ***!
  \**************************/
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var xss = __webpack_require__(/*! xss */ "./node_modules/xss/lib/index.js");
var sby_js_exists = typeof sby_js_exists !== 'undefined' ? true : false;
if (!sby_js_exists) {
  /**
   * Sanitize string by escaping HTML entities
   * @param input
   * @returns {string}
   */
  var sbyEncodeInput = function sbyEncodeInput(input) {
    return xss(input);
  };
  var sbyAddImgLiquid = function sbyAddImgLiquid() {
    /*! imgLiquid v0.9.944 / 03-05-2013 https://github.com/karacas/imgLiquid */
    var _sby_imgLiquid = _sby_imgLiquid || {
      VER: "0.9.944"
    };
    _sby_imgLiquid.bgs_Available = !1, _sby_imgLiquid.bgs_CheckRunned = !1, function (i) {
      function t() {
        if (!_sby_imgLiquid.bgs_CheckRunned) {
          _sby_imgLiquid.bgs_CheckRunned = !0;
          var t = i('<span style="background-size:cover" />');
          i("body").append(t), !function () {
            var i = t[0];
            if (i && window.getComputedStyle) {
              var e = window.getComputedStyle(i, null);
              e && e.backgroundSize && (_sby_imgLiquid.bgs_Available = "cover" === e.backgroundSize);
            }
          }(), t.remove();
        }
      }
      i.fn.extend({
        sby_imgLiquid: function sby_imgLiquid(e) {
          this.defaults = {
            fill: !0,
            verticalAlign: "center",
            horizontalAlign: "center",
            useBackgroundSize: !0,
            useDataHtmlAttr: !0,
            responsive: !0,
            delay: 0,
            fadeInTime: 0,
            removeBoxBackground: !0,
            hardPixels: !0,
            responsiveCheckTime: 500,
            timecheckvisibility: 500,
            onStart: null,
            onFinish: null,
            onItemStart: null,
            onItemFinish: null,
            onItemError: null
          }, t();
          var a = this;
          return this.options = e, this.settings = i.extend({}, this.defaults, this.options), this.settings.onStart && this.settings.onStart(), this.each(function (t) {
            function e() {
              -1 === u.css("background-image").indexOf(encodeURI(c.attr("src"))) && u.css({
                "background-image": 'url("' + encodeURI(c.attr("src")) + '")'
              }), u.css({
                "background-size": g.fill ? "cover" : "contain",
                "background-position": (g.horizontalAlign + " " + g.verticalAlign).toLowerCase(),
                "background-repeat": "no-repeat"
              }), i("a:first", u).css({
                display: "block",
                width: "100%",
                height: "100%"
              }), i("img", u).css({
                display: "none"
              }), g.onItemFinish && g.onItemFinish(t, u, c), u.addClass("sby_imgLiquid_bgSize"), u.addClass("sby_imgLiquid_ready"), l();
            }
            function o() {
              function e() {
                c.data("sby_imgLiquid_error") || c.data("sby_imgLiquid_loaded") || c.data("sby_imgLiquid_oldProcessed") || (u.is(":visible") && c[0].complete && c[0].width > 0 && c[0].height > 0 ? (c.data("sby_imgLiquid_loaded", !0), setTimeout(r, t * g.delay)) : setTimeout(e, g.timecheckvisibility));
              }
              if (c.data("oldSrc") && c.data("oldSrc") !== c.attr("src")) {
                var a = c.clone().removeAttr("style");
                return a.data("sby_imgLiquid_settings", c.data("sby_imgLiquid_settings")), c.parent().prepend(a), c.remove(), c = a, c[0].width = 0, void setTimeout(o, 10);
              }
              return c.data("sby_imgLiquid_oldProcessed") ? void r() : (c.data("sby_imgLiquid_oldProcessed", !1), c.data("oldSrc", c.attr("src")), i("img:not(:first)", u).css("display", "none"), u.css({
                overflow: "hidden"
              }), c.fadeTo(0, 0).removeAttr("width").removeAttr("height").css({
                visibility: "visible",
                "max-width": "none",
                "max-height": "none",
                width: "auto",
                height: "auto",
                display: "block"
              }), c.on("error", n), c[0].onerror = n, e(), void d());
            }
            function d() {
              (g.responsive || c.data("sby_imgLiquid_oldProcessed")) && c.data("sby_imgLiquid_settings") && (g = c.data("sby_imgLiquid_settings"), u.actualSize = u.get(0).offsetWidth + u.get(0).offsetHeight / 1e4, u.sizeOld && u.actualSize !== u.sizeOld && r(), u.sizeOld = u.actualSize, setTimeout(d, g.responsiveCheckTime));
            }
            function n() {
              c.data("sby_imgLiquid_error", !0), u.addClass("sby_imgLiquid_error"), g.onItemError && g.onItemError(t, u, c), l();
            }
            function s() {
              var i = {};
              if (a.settings.useDataHtmlAttr) {
                var t = u.attr("data-sby_imgLiquid-fill"),
                  e = u.attr("data-sby_imgLiquid-horizontalAlign"),
                  o = u.attr("data-sby_imgLiquid-verticalAlign");
                ("true" === t || "false" === t) && (i.fill = Boolean("true" === t)), void 0 === e || "left" !== e && "center" !== e && "right" !== e && -1 === e.indexOf("%") || (i.horizontalAlign = e), void 0 === o || "top" !== o && "bottom" !== o && "center" !== o && -1 === o.indexOf("%") || (i.verticalAlign = o);
              }
              return _sby_imgLiquid.isIE && a.settings.ieFadeInDisabled && (i.fadeInTime = 0), i;
            }
            function r() {
              var i,
                e,
                a,
                o,
                d,
                n,
                s,
                r,
                m = 0,
                h = 0,
                f = u.width(),
                v = u.height();
              void 0 === c.data("owidth") && c.data("owidth", c[0].width), void 0 === c.data("oheight") && c.data("oheight", c[0].height), g.fill === f / v >= c.data("owidth") / c.data("oheight") ? (i = "100%", e = "auto", a = Math.floor(f), o = Math.floor(f * (c.data("oheight") / c.data("owidth")))) : (i = "auto", e = "100%", a = Math.floor(v * (c.data("owidth") / c.data("oheight"))), o = Math.floor(v)), d = g.horizontalAlign.toLowerCase(), s = f - a, "left" === d && (h = 0), "center" === d && (h = .5 * s), "right" === d && (h = s), -1 !== d.indexOf("%") && (d = parseInt(d.replace("%", ""), 10), d > 0 && (h = s * d * .01)), n = g.verticalAlign.toLowerCase(), r = v - o, "left" === n && (m = 0), "center" === n && (m = .5 * r), "bottom" === n && (m = r), -1 !== n.indexOf("%") && (n = parseInt(n.replace("%", ""), 10), n > 0 && (m = r * n * .01)), g.hardPixels && (i = a, e = o), c.css({
                width: i,
                height: e,
                "margin-left": Math.floor(h),
                "margin-top": Math.floor(m)
              }), c.data("sby_imgLiquid_oldProcessed") || (c.fadeTo(g.fadeInTime, 1), c.data("sby_imgLiquid_oldProcessed", !0), g.removeBoxBackground && u.css("background-image", "none"), u.addClass("sby_imgLiquid_nobgSize"), u.addClass("sby_imgLiquid_ready")), g.onItemFinish && g.onItemFinish(t, u, c), l();
            }
            function l() {
              t === a.length - 1 && a.settings.onFinish && a.settings.onFinish();
            }
            var g = a.settings,
              u = i(this),
              c = i("img:first", u);
            return c.length ? (c.data("sby_imgLiquid_settings") ? (u.removeClass("sby_imgLiquid_error").removeClass("sby_imgLiquid_ready"), g = i.extend({}, c.data("sby_imgLiquid_settings"), a.options)) : g = i.extend({}, a.settings, s()), c.data("sby_imgLiquid_settings", g), g.onItemStart && g.onItemStart(t, u, c), void (_sby_imgLiquid.bgs_Available && g.useBackgroundSize ? e() : o())) : void n();
          });
        }
      });
    }(jQuery);

    // Use imagefill to set the images as backgrounds so they can be square
    !function () {
      var css = _sby_imgLiquid.injectCss,
        head = document.getElementsByTagName('head')[0],
        style = document.createElement('style');
      style.type = 'text/css';
      if (style.styleSheet) {
        style.styleSheet.cssText = css;
      } else {
        style.appendChild(document.createTextNode(css));
      }
      head.appendChild(style);
    }();
  };
  /* JavaScript Linkify - v0.3 - 6/27/2009 - http://benalman.com/projects/javascript-linkify/ */
  //Checks whether browser support HTML5 video element
  var sby_supports_video = function sby_supports_video() {
    return !!document.createElement('video').canPlayType;
  }; // Carousel
  window.sbyLinkify = function () {
    var k = "[a-z\\d.-]+://",
      h = "(?:(?:[0-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])\\.){3}(?:[0-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])",
      c = "(?:(?:[^\\s!@#$%^&*()_=+[\\]{}\\\\|;:'\",.<>/?]+)\\.)+",
      n = "(?:ac|ad|aero|ae|af|ag|ai|al|am|an|ao|aq|arpa|ar|asia|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|biz|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|cat|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|coop|com|co|cr|cu|cv|cx|cy|cz|de|dj|dk|dm|do|dz|ec|edu|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gov|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|info|int|in|io|iq|ir|is|it|je|jm|jobs|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mil|mk|ml|mm|mn|mobi|mo|mp|mq|mr|ms|mt|museum|mu|mv|mw|mx|my|mz|name|na|nc|net|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|org|pa|pe|pf|pg|ph|pk|pl|pm|pn|pro|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sv|sy|sz|tc|td|tel|tf|tg|th|tj|tk|tl|tm|tn|to|tp|travel|tr|tt|tv|tw|tz|ua|ug|uk|um|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|xn--0zwm56d|xn--11b5bs3a9aj6g|xn--80akhbyknj4f|xn--9t4b11yi5a|xn--deba0ad|xn--g6w251d|xn--hgbk6aj7f53bba|xn--hlcj6aya9esc7a|xn--jxalpdlp|xn--kgbechtv|xn--zckzah|ye|yt|yu|za|zm|zw)",
      f = "(?:" + c + n + "|" + h + ")",
      o = "(?:[;/][^#?<>\\s]*)?",
      e = "(?:\\?[^#<>\\s]*)?(?:#[^<>\\s]*)?",
      d = "\\b" + k + "[^<>\\s]+",
      a = "\\b" + f + o + e + "(?!\\w)",
      m = "mailto:",
      j = "(?:" + m + ")?[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@" + f + e + "(?!\\w)",
      l = new RegExp("(?:" + d + "|" + a + "|" + j + ")", "ig"),
      g = new RegExp("^" + k, "i"),
      b = {
        "'": "`",
        ">": "<",
        ")": "(",
        "]": "[",
        "}": "{",
        "B;": "B+",
        "b:": "b9"
      },
      i = {
        callback: function callback(q, p) {
          return p ? '<a href="' + p + '" title="' + p + '" target="_blank" rel="noopener">' + q + "</a>" : q;
        },
        punct_regexp: /(?:[!?.,:;'"]|(?:&|&amp;)(?:lt|gt|quot|apos|raquo|laquo|rsaquo|lsaquo);)$/
      };
    return function (u, z) {
      z = z || {};
      var w,
        v,
        A,
        p,
        x = "",
        t = [],
        s,
        E,
        C,
        y,
        q,
        D,
        B,
        r;
      for (v in i) {
        if (z[v] === undefined) {
          z[v] = i[v];
        }
      }
      while (w = l.exec(u)) {
        A = w[0];
        E = l.lastIndex;
        C = E - A.length;
        if (/[\/:]/.test(u.charAt(C - 1))) {
          continue;
        }
        do {
          y = A;
          r = A.substr(-1);
          B = b[r];
          if (B) {
            q = A.match(new RegExp("\\" + B + "(?!$)", "g"));
            D = A.match(new RegExp("\\" + r, "g"));
            if ((q ? q.length : 0) < (D ? D.length : 0)) {
              A = A.substr(0, A.length - 1);
              E--;
            }
          }
          if (z.punct_regexp) {
            A = A.replace(z.punct_regexp, function (F) {
              E -= F.length;
              return "";
            });
          }
        } while (A.length && A !== y);
        p = A;
        if (!g.test(p)) {
          p = (p.indexOf("@") !== -1 ? !p.indexOf(m) ? "" : m : !p.indexOf("irc.") ? "irc://" : !p.indexOf("ftp.") ? "ftp://" : "http://") + p;
        }
        if (s != C) {
          t.push([u.slice(s, C)]);
          s = E;
        }
        t.push([A, p]);
      }
      t.push([u.substr(s)]);
      for (v = 0; v < t.length; v++) {
        x += z.callback.apply(window, t[v]);
      }
      return x || u;
    };
  }();
  !function (a, b, c, d) {
    function e(b, c) {
      this.settings = null, this.options = a.extend({}, e.Defaults, c), this.$element = a(b), this._handlers = {}, this._plugins = {}, this._supress = {}, this._current = null, this._speed = null, this._coordinates = [], this._breakpoint = null, this._width = null, this._items = [], this._clones = [], this._mergers = [], this._widths = [], this._invalidated = {}, this._pipe = [], this._drag = {
        time: null,
        target: null,
        pointer: null,
        stage: {
          start: null,
          current: null
        },
        direction: null
      }, this._states = {
        current: {},
        tags: {
          initializing: ["busy"],
          animating: ["busy"],
          dragging: ["interacting"]
        }
      }, a.each(["onResize", "onThrottledResize"], a.proxy(function (b, c) {
        this._handlers[c] = a.proxy(this[c], this);
      }, this)), a.each(e.Plugins, a.proxy(function (a, b) {
        this._plugins[a.charAt(0).toLowerCase() + a.slice(1)] = new b(this);
      }, this)), a.each(e.Workers, a.proxy(function (b, c) {
        this._pipe.push({
          filter: c.filter,
          run: a.proxy(c.run, this)
        });
      }, this)), this.setup(), this.initialize();
    }
    e.Defaults = {
      items: 3,
      loop: !1,
      center: !1,
      rewind: !1,
      mouseDrag: !0,
      touchDrag: !0,
      pullDrag: !0,
      freeDrag: !1,
      margin: 0,
      stagePadding: 0,
      merge: !1,
      mergeFit: !0,
      autoWidth: !1,
      startPosition: 0,
      rtl: !1,
      smartSpeed: 250,
      fluidSpeed: !1,
      dragEndSpeed: !1,
      responsive: {},
      responsiveRefreshRate: 200,
      responsiveBaseElement: b,
      fallbackEasing: "swing",
      info: !1,
      nestedItemSelector: !1,
      itemElement: "div",
      stageElement: "div",
      refreshClass: "sby-owl-refresh",
      loadedClass: "sby-owl-loaded",
      loadingClass: "sby-owl-loading",
      rtlClass: "sby-owl-rtl",
      responsiveClass: "sby-owl-responsive",
      dragClass: "sby-owl-drag",
      itemClass: "sby-owl-item",
      stageClass: "sby-owl-stage",
      stageOuterClass: "sby-owl-stage-outer",
      grabClass: "sby-owl-grab"
    }, e.Width = {
      Default: "default",
      Inner: "inner",
      Outer: "outer"
    }, e.Type = {
      Event: "event",
      State: "state"
    }, e.Plugins = {}, e.Workers = [{
      filter: ["width", "settings"],
      run: function run() {
        this._width = this.$element.width();
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run(a) {
        a.current = this._items && this._items[this.relative(this._current)];
      }
    }, {
      filter: ["items", "settings"],
      run: function run() {
        this.$stage.children(".cloned").remove();
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run(a) {
        var b = this.settings.margin || "",
          c = !this.settings.autoWidth,
          d = this.settings.rtl,
          e = {
            width: "auto",
            "margin-left": d ? b : "",
            "margin-right": d ? "" : b
          };
        !c && this.$stage.children().css(e), a.css = e;
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run(a) {
        var b = (this.width() / this.settings.items).toFixed(3) - this.settings.margin,
          c = null,
          d = this._items.length,
          e = !this.settings.autoWidth,
          f = [];
        for (a.items = {
          merge: !1,
          width: b
        }; d--;) c = this._mergers[d], c = this.settings.mergeFit && Math.min(c, this.settings.items) || c, a.items.merge = c > 1 || a.items.merge, f[d] = e ? b * c : this._items[d].width();
        this._widths = f;
      }
    }, {
      filter: ["items", "settings"],
      run: function run() {
        var b = [],
          c = this._items,
          d = this.settings,
          e = Math.max(2 * d.items, 4),
          f = 2 * Math.ceil(c.length / 2),
          g = d.loop && c.length ? d.rewind ? e : Math.max(e, f) : 0,
          h = "",
          i = "";
        for (g /= 2; g--;) b.push(this.normalize(b.length / 2, !0)), h += c[b[b.length - 1]][0].outerHTML, b.push(this.normalize(c.length - 1 - (b.length - 1) / 2, !0)), i = c[b[b.length - 1]][0].outerHTML + i;
        this._clones = b, a(h).addClass("cloned").appendTo(this.$stage), a(i).addClass("cloned").prependTo(this.$stage);
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run() {
        for (var a = this.settings.rtl ? 1 : -1, b = this._clones.length + this._items.length, c = -1, d = 0, e = 0, f = []; ++c < b;) d = f[c - 1] || 0, e = this._widths[this.relative(c)] + this.settings.margin, f.push(d + e * a);
        this._coordinates = f;
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run() {
        var a = this.settings.stagePadding,
          b = this._coordinates,
          c = {
            width: Math.ceil(Math.abs(b[b.length - 1])) + 2 * a,
            "padding-left": a || "",
            "padding-right": a || ""
          };
        this.$stage.css(c);
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run(a) {
        var b = this._coordinates.length,
          c = !this.settings.autoWidth,
          d = this.$stage.children();
        if (c && a.items.merge) for (; b--;) a.css.width = this._widths[this.relative(b)], d.eq(b).css(a.css);else c && (a.css.width = a.items.width, d.css(a.css));
      }
    }, {
      filter: ["items"],
      run: function run() {
        this._coordinates.length < 1 && this.$stage.removeAttr("style");
      }
    }, {
      filter: ["width", "items", "settings"],
      run: function run(a) {
        a.current = a.current ? this.$stage.children().index(a.current) : 0, a.current = Math.max(this.minimum(), Math.min(this.maximum(), a.current)), this.reset(a.current);
      }
    }, {
      filter: ["position"],
      run: function run() {
        this.animate(this.coordinates(this._current));
      }
    }, {
      filter: ["width", "position", "items", "settings"],
      run: function run() {
        var a,
          b,
          c,
          d,
          e = this.settings.rtl ? 1 : -1,
          f = 2 * this.settings.stagePadding,
          g = this.coordinates(this.current()) + f,
          h = g + this.width() * e,
          i = [];
        for (c = 0, d = this._coordinates.length; c < d; c++) a = this._coordinates[c - 1] || 0, b = Math.abs(this._coordinates[c]) + f * e, (this.op(a, "<=", g) && this.op(a, ">", h) || this.op(b, "<", g) && this.op(b, ">", h)) && i.push(c);
        this.$stage.children(".active").removeClass("active"), this.$stage.children(":eq(" + i.join("), :eq(") + ")").addClass("active"), this.settings.center && (this.$stage.children(".center").removeClass("center"), this.$stage.children().eq(this.current()).addClass("center"));
      }
    }], e.prototype.initialize = function () {
      if (this.enter("initializing"), this.trigger("initialize"), this.$element.toggleClass(this.settings.rtlClass, this.settings.rtl), this.settings.autoWidth && !this.is("pre-loading")) {
        var b, c, e;
        b = this.$element.find("img"), c = this.settings.nestedItemSelector ? "." + this.settings.nestedItemSelector : d, e = this.$element.children(c).width(), b.length && e <= 0 && this.preloadAutoWidthImages(b);
      }
      this.$element.addClass(this.options.loadingClass), this.$stage = a("<" + this.settings.stageElement + ' class="' + this.settings.stageClass + '"/>').wrap('<div class="' + this.settings.stageOuterClass + '"/>'), this.$element.append(this.$stage.parent()), this.replace(this.$element.children().not(this.$stage.parent())), this.$element.is(":visible") ? this.refresh() : this.invalidate("width"), this.$element.removeClass(this.options.loadingClass).addClass(this.options.loadedClass), this.registerEventHandlers(), this.leave("initializing"), this.trigger("initialized");
    }, e.prototype.setup = function () {
      var b = this.viewport(),
        c = this.options.responsive,
        d = -1,
        e = null;
      c ? (a.each(c, function (a) {
        a <= b && a > d && (d = Number(a));
      }), e = a.extend({}, this.options, c[d]), "function" == typeof e.stagePadding && (e.stagePadding = e.stagePadding()), delete e.responsive, e.responsiveClass && this.$element.attr("class", this.$element.attr("class").replace(new RegExp("(" + this.options.responsiveClass + "-)\\S+\\s", "g"), "$1" + d))) : e = a.extend({}, this.options), this.trigger("change", {
        property: {
          name: "settings",
          value: e
        }
      }), this._breakpoint = d, this.settings = e, this.invalidate("settings"), this.trigger("changed", {
        property: {
          name: "settings",
          value: this.settings
        }
      });
    }, e.prototype.optionsLogic = function () {
      this.settings.autoWidth && (this.settings.stagePadding = !1, this.settings.merge = !1);
    }, e.prototype.prepare = function (b) {
      var c = this.trigger("prepare", {
        content: b
      });
      return c.data || (c.data = a("<" + this.settings.itemElement + "/>").addClass(this.options.itemClass).append(b)), this.trigger("prepared", {
        content: c.data
      }), c.data;
    }, e.prototype.update = function () {
      for (var b = 0, c = this._pipe.length, d = a.proxy(function (a) {
          return this[a];
        }, this._invalidated), e = {}; b < c;) (this._invalidated.all || a.grep(this._pipe[b].filter, d).length > 0) && this._pipe[b].run(e), b++;
      this._invalidated = {}, !this.is("valid") && this.enter("valid");
    }, e.prototype.width = function (a) {
      switch (a = a || e.Width.Default) {
        case e.Width.Inner:
        case e.Width.Outer:
          return this._width;
        default:
          return this._width - 2 * this.settings.stagePadding + this.settings.margin;
      }
    }, e.prototype.refresh = function () {
      this.enter("refreshing"), this.trigger("refresh"), this.setup(), this.optionsLogic(), this.$element.addClass(this.options.refreshClass), this.update(), this.$element.removeClass(this.options.refreshClass), this.leave("refreshing"), this.trigger("refreshed");
    }, e.prototype.onThrottledResize = function () {
      b.clearTimeout(this.resizeTimer), this.resizeTimer = b.setTimeout(this._handlers.onResize, this.settings.responsiveRefreshRate);
    }, e.prototype.onResize = function () {
      return !!this._items.length && this._width !== this.$element.width() && !!this.$element.is(":visible") && (this.enter("resizing"), this.trigger("resize").isDefaultPrevented() ? (this.leave("resizing"), !1) : (this.invalidate("width"), this.refresh(), this.leave("resizing"), void this.trigger("resized")));
    }, e.prototype.registerEventHandlers = function () {
      a.support.transition && this.$stage.on(a.support.transition.end + ".owl.core", a.proxy(this.onTransitionEnd, this)), this.settings.responsive !== !1 && this.on(b, "resize", this._handlers.onThrottledResize), this.settings.mouseDrag && (this.$element.addClass(this.options.dragClass), this.$stage.on("mousedown.owl.core", a.proxy(this.onDragStart, this)), this.$stage.on("dragstart.owl.core selectstart.owl.core", function () {
        return !1;
      })), this.settings.touchDrag && (this.$stage.on("touchstart.owl.core", a.proxy(this.onDragStart, this)), this.$stage.on("touchcancel.owl.core", a.proxy(this.onDragEnd, this)));
    }, e.prototype.onDragStart = function (b) {
      var d = null;
      3 !== b.which && (a.support.transform ? (d = this.$stage.css("transform").replace(/.*\(|\)| /g, "").split(","), d = {
        x: d[16 === d.length ? 12 : 4],
        y: d[16 === d.length ? 13 : 5]
      }) : (d = this.$stage.position(), d = {
        x: this.settings.rtl ? d.left + this.$stage.width() - this.width() + this.settings.margin : d.left,
        y: d.top
      }), this.is("animating") && (a.support.transform ? this.animate(d.x) : this.$stage.stop(), this.invalidate("position")), this.$element.toggleClass(this.options.grabClass, "mousedown" === b.type), this.speed(0), this._drag.time = new Date().getTime(), this._drag.target = a(b.target), this._drag.stage.start = d, this._drag.stage.current = d, this._drag.pointer = this.pointer(b), a(c).on("mouseup.owl.core touchend.owl.core", a.proxy(this.onDragEnd, this)), a(c).one("mousemove.owl.core touchmove.owl.core", a.proxy(function (b) {
        var d = this.difference(this._drag.pointer, this.pointer(b));
        a(c).on("mousemove.owl.core touchmove.owl.core", a.proxy(this.onDragMove, this)), Math.abs(d.x) < Math.abs(d.y) && this.is("valid") || (b.preventDefault(), this.enter("dragging"), this.trigger("drag"));
      }, this)));
    }, e.prototype.onDragMove = function (a) {
      var b = null,
        c = null,
        d = null,
        e = this.difference(this._drag.pointer, this.pointer(a)),
        f = this.difference(this._drag.stage.start, e);
      this.is("dragging") && (a.preventDefault(), this.settings.loop ? (b = this.coordinates(this.minimum()), c = this.coordinates(this.maximum() + 1) - b, f.x = ((f.x - b) % c + c) % c + b) : (b = this.settings.rtl ? this.coordinates(this.maximum()) : this.coordinates(this.minimum()), c = this.settings.rtl ? this.coordinates(this.minimum()) : this.coordinates(this.maximum()), d = this.settings.pullDrag ? -1 * e.x / 5 : 0, f.x = Math.max(Math.min(f.x, b + d), c + d)), this._drag.stage.current = f, this.animate(f.x));
    }, e.prototype.onDragEnd = function (b) {
      var d = this.difference(this._drag.pointer, this.pointer(b)),
        e = this._drag.stage.current,
        f = d.x > 0 ^ this.settings.rtl ? "left" : "right";
      a(c).off(".owl.core"), this.$element.removeClass(this.options.grabClass), (0 !== d.x && this.is("dragging") || !this.is("valid")) && (this.speed(this.settings.dragEndSpeed || this.settings.smartSpeed), this.current(this.closest(e.x, 0 !== d.x ? f : this._drag.direction)), this.invalidate("position"), this.update(), this._drag.direction = f, (Math.abs(d.x) > 3 || new Date().getTime() - this._drag.time > 300) && this._drag.target.one("click.owl.core", function () {
        return !1;
      })), this.is("dragging") && (this.leave("dragging"), this.trigger("dragged"));
    }, e.prototype.closest = function (b, c) {
      var d = -1,
        e = 30,
        f = this.width(),
        g = this.coordinates();
      return this.settings.freeDrag || a.each(g, a.proxy(function (a, h) {
        return "left" === c && b > h - e && b < h + e ? d = a : "right" === c && b > h - f - e && b < h - f + e ? d = a + 1 : this.op(b, "<", h) && this.op(b, ">", g[a + 1] || h - f) && (d = "left" === c ? a + 1 : a), d === -1;
      }, this)), this.settings.loop || (this.op(b, ">", g[this.minimum()]) ? d = b = this.minimum() : this.op(b, "<", g[this.maximum()]) && (d = b = this.maximum())), d;
    }, e.prototype.animate = function (b) {
      var c = this.speed() > 0;
      this.is("animating") && this.onTransitionEnd(), c && (this.enter("animating"), this.trigger("translate")), a.support.transform3d && a.support.transition ? this.$stage.css({
        transform: "translate3d(" + b + "px,0px,0px)",
        transition: this.speed() / 1e3 + "s"
      }) : c ? this.$stage.animate({
        left: b + "px"
      }, this.speed(), this.settings.fallbackEasing, a.proxy(this.onTransitionEnd, this)) : this.$stage.css({
        left: b + "px"
      });
    }, e.prototype.is = function (a) {
      return this._states.current[a] && this._states.current[a] > 0;
    }, e.prototype.current = function (a) {
      if (a === d) return this._current;
      if (0 === this._items.length) return d;
      if (a = this.normalize(a), this._current !== a) {
        var b = this.trigger("change", {
          property: {
            name: "position",
            value: a
          }
        });
        b.data !== d && (a = this.normalize(b.data)), this._current = a, this.invalidate("position"), this.trigger("changed", {
          property: {
            name: "position",
            value: this._current
          }
        });
      }
      return this._current;
    }, e.prototype.invalidate = function (b) {
      return "string" === a.type(b) && (this._invalidated[b] = !0, this.is("valid") && this.leave("valid")), a.map(this._invalidated, function (a, b) {
        return b;
      });
    }, e.prototype.reset = function (a) {
      a = this.normalize(a), a !== d && (this._speed = 0, this._current = a, this.suppress(["translate", "translated"]), this.animate(this.coordinates(a)), this.release(["translate", "translated"]));
    }, e.prototype.normalize = function (a, b) {
      var c = this._items.length,
        e = b ? 0 : this._clones.length;
      return !this.isNumeric(a) || c < 1 ? a = d : (a < 0 || a >= c + e) && (a = ((a - e / 2) % c + c) % c + e / 2), a;
    }, e.prototype.relative = function (a) {
      return a -= this._clones.length / 2, this.normalize(a, !0);
    }, e.prototype.maximum = function (a) {
      var b,
        c,
        d,
        e = this.settings,
        f = this._coordinates.length;
      if (e.loop) f = this._clones.length / 2 + this._items.length - 1;else if (e.autoWidth || e.merge) {
        for (b = this._items.length, c = this._items[--b].width(), d = this.$element.width(); b-- && (c += this._items[b].width() + this.settings.margin, !(c > d)););
        f = b + 1;
      } else f = e.center ? this._items.length - 1 : this._items.length - e.items;
      return a && (f -= this._clones.length / 2), Math.max(f, 0);
    }, e.prototype.minimum = function (a) {
      return a ? 0 : this._clones.length / 2;
    }, e.prototype.items = function (a) {
      return a === d ? this._items.slice() : (a = this.normalize(a, !0), this._items[a]);
    }, e.prototype.mergers = function (a) {
      return a === d ? this._mergers.slice() : (a = this.normalize(a, !0), this._mergers[a]);
    }, e.prototype.clones = function (b) {
      var c = this._clones.length / 2,
        e = c + this._items.length,
        f = function f(a) {
          return a % 2 === 0 ? e + a / 2 : c - (a + 1) / 2;
        };
      return b === d ? a.map(this._clones, function (a, b) {
        return f(b);
      }) : a.map(this._clones, function (a, c) {
        return a === b ? f(c) : null;
      });
    }, e.prototype.speed = function (a) {
      return a !== d && (this._speed = a), this._speed;
    }, e.prototype.coordinates = function (b) {
      var c,
        e = 1,
        f = b - 1;
      return b === d ? a.map(this._coordinates, a.proxy(function (a, b) {
        return this.coordinates(b);
      }, this)) : (this.settings.center ? (this.settings.rtl && (e = -1, f = b + 1), c = this._coordinates[b], c += (this.width() - c + (this._coordinates[f] || 0)) / 2 * e) : c = this._coordinates[f] || 0, c = Math.ceil(c));
    }, e.prototype.duration = function (a, b, c) {
      return 0 === c ? 0 : Math.min(Math.max(Math.abs(b - a), 1), 6) * Math.abs(c || this.settings.smartSpeed);
    }, e.prototype.to = function (a, b) {
      var c = this.current(),
        d = null,
        e = a - this.relative(c),
        f = (e > 0) - (e < 0),
        g = this._items.length,
        h = this.minimum(),
        i = this.maximum();
      this.settings.loop ? (!this.settings.rewind && Math.abs(e) > g / 2 && (e += f * -1 * g), a = c + e, d = ((a - h) % g + g) % g + h, d !== a && d - e <= i && d - e > 0 && (c = d - e, a = d, this.reset(c))) : this.settings.rewind ? (i += 1, a = (a % i + i) % i) : a = Math.max(h, Math.min(i, a)), this.speed(this.duration(c, a, b)), this.current(a), this.$element.is(":visible") && this.update();
    }, e.prototype.next = function (a) {
      a = a || !1, this.to(this.relative(this.current()) + 1, a);
    }, e.prototype.prev = function (a) {
      a = a || !1, this.to(this.relative(this.current()) - 1, a);
    }, e.prototype.onTransitionEnd = function (a) {
      if (a !== d && (a.stopPropagation(), (a.target || a.srcElement || a.originalTarget) !== this.$stage.get(0))) return !1;
      this.leave("animating"), this.trigger("translated");
    }, e.prototype.viewport = function () {
      var d;
      return this.options.responsiveBaseElement !== b ? d = a(this.options.responsiveBaseElement).width() : b.innerWidth ? d = b.innerWidth : c.documentElement && c.documentElement.clientWidth ? d = c.documentElement.clientWidth : console.warn("Can not detect viewport width."), d;
    }, e.prototype.replace = function (b) {
      this.$stage.empty(), this._items = [], b && (b = b instanceof jQuery ? b : a(b)), this.settings.nestedItemSelector && (b = b.find("." + this.settings.nestedItemSelector)), b.filter(function () {
        return 1 === this.nodeType;
      }).each(a.proxy(function (a, b) {
        b = this.prepare(b), this.$stage.append(b), this._items.push(b), this._mergers.push(1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1);
      }, this)), this.reset(this.isNumeric(this.settings.startPosition) ? this.settings.startPosition : 0), this.invalidate("items");
    }, e.prototype.add = function (b, c) {
      var e = this.relative(this._current);
      c = c === d ? this._items.length : this.normalize(c, !0), b = b instanceof jQuery ? b : a(b), this.trigger("add", {
        content: b,
        position: c
      }), b = this.prepare(b), 0 === this._items.length || c === this._items.length ? (0 === this._items.length && this.$stage.append(b), 0 !== this._items.length && this._items[c - 1].after(b), this._items.push(b), this._mergers.push(1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1)) : (this._items[c].before(b), this._items.splice(c, 0, b), this._mergers.splice(c, 0, 1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1)), this._items[e] && this.reset(this._items[e].index()), this.invalidate("items"), this.trigger("added", {
        content: b,
        position: c
      });
    }, e.prototype.remove = function (a) {
      a = this.normalize(a, !0), a !== d && (this.trigger("remove", {
        content: this._items[a],
        position: a
      }), this._items[a].remove(), this._items.splice(a, 1), this._mergers.splice(a, 1), this.invalidate("items"), this.trigger("removed", {
        content: null,
        position: a
      }));
    }, e.prototype.preloadAutoWidthImages = function (b) {
      b.each(a.proxy(function (b, c) {
        this.enter("pre-loading"), c = a(c), a(new Image()).one("load", a.proxy(function (a) {
          c.attr("src", a.target.src), c.css("opacity", 1), this.leave("pre-loading"), !this.is("pre-loading") && !this.is("initializing") && this.refresh();
        }, this)).attr("src", c.attr("src") || c.attr("data-src") || c.attr("data-src-retina"));
      }, this));
    }, e.prototype.destroy = function () {
      this.$element.off(".owl.core"), this.$stage.off(".owl.core"), a(c).off(".owl.core"), this.settings.responsive !== !1 && (b.clearTimeout(this.resizeTimer), this.off(b, "resize", this._handlers.onThrottledResize));
      for (var d in this._plugins) this._plugins[d].destroy();
      this.$stage.children(".cloned").remove(), this.$stage.unwrap(), this.$stage.children().contents().unwrap(), this.$stage.children().unwrap(), this.$element.removeClass(this.options.refreshClass).removeClass(this.options.loadingClass).removeClass(this.options.loadedClass).removeClass(this.options.rtlClass).removeClass(this.options.dragClass).removeClass(this.options.grabClass).attr("class", this.$element.attr("class").replace(new RegExp(this.options.responsiveClass + "-\\S+\\s", "g"), "")).removeData("owl.carousel");
    }, e.prototype.op = function (a, b, c) {
      var d = this.settings.rtl;
      switch (b) {
        case "<":
          return d ? a > c : a < c;
        case ">":
          return d ? a < c : a > c;
        case ">=":
          return d ? a <= c : a >= c;
        case "<=":
          return d ? a >= c : a <= c;
      }
    }, e.prototype.on = function (a, b, c, d) {
      a.addEventListener ? a.addEventListener(b, c, d) : a.attachEvent && a.attachEvent("on" + b, c);
    }, e.prototype.off = function (a, b, c, d) {
      a.removeEventListener ? a.removeEventListener(b, c, d) : a.detachEvent && a.detachEvent("on" + b, c);
    }, e.prototype.trigger = function (b, c, d, f, g) {
      var h = {
          item: {
            count: this._items.length,
            index: this.current()
          }
        },
        i = a.camelCase(a.grep(["on", b, d], function (a) {
          return a;
        }).join("-").toLowerCase()),
        j = a.Event([b, "owl", d || "carousel"].join(".").toLowerCase(), a.extend({
          relatedTarget: this
        }, h, c));
      return this._supress[b] || (a.each(this._plugins, function (a, b) {
        b.onTrigger && b.onTrigger(j);
      }), this.register({
        type: e.Type.Event,
        name: b
      }), this.$element.trigger(j), this.settings && "function" == typeof this.settings[i] && this.settings[i].call(this, j)), j;
    }, e.prototype.enter = function (b) {
      a.each([b].concat(this._states.tags[b] || []), a.proxy(function (a, b) {
        this._states.current[b] === d && (this._states.current[b] = 0), this._states.current[b]++;
      }, this));
    }, e.prototype.leave = function (b) {
      a.each([b].concat(this._states.tags[b] || []), a.proxy(function (a, b) {
        this._states.current[b]--;
      }, this));
    }, e.prototype.register = function (b) {
      if (b.type === e.Type.Event) {
        if (a.event.special[b.name] || (a.event.special[b.name] = {}), !a.event.special[b.name].owl) {
          var c = a.event.special[b.name]._default;
          a.event.special[b.name]._default = function (a) {
            return !c || !c.apply || a.namespace && a.namespace.indexOf("owl") !== -1 ? a.namespace && a.namespace.indexOf("owl") > -1 : c.apply(this, arguments);
          }, a.event.special[b.name].owl = !0;
        }
      } else b.type === e.Type.State && (this._states.tags[b.name] ? this._states.tags[b.name] = this._states.tags[b.name].concat(b.tags) : this._states.tags[b.name] = b.tags, this._states.tags[b.name] = a.grep(this._states.tags[b.name], a.proxy(function (c, d) {
        return a.inArray(c, this._states.tags[b.name]) === d;
      }, this)));
    }, e.prototype.suppress = function (b) {
      a.each(b, a.proxy(function (a, b) {
        this._supress[b] = !0;
      }, this));
    }, e.prototype.release = function (b) {
      a.each(b, a.proxy(function (a, b) {
        delete this._supress[b];
      }, this));
    }, e.prototype.pointer = function (a) {
      var c = {
        x: null,
        y: null
      };
      return a = a.originalEvent || a || b.event, a = a.touches && a.touches.length ? a.touches[0] : a.changedTouches && a.changedTouches.length ? a.changedTouches[0] : a, a.pageX ? (c.x = a.pageX, c.y = a.pageY) : (c.x = a.clientX, c.y = a.clientY), c;
    }, e.prototype.isNumeric = function (a) {
      return !isNaN(parseFloat(a));
    }, e.prototype.difference = function (a, b) {
      return {
        x: a.x - b.x,
        y: a.y - b.y
      };
    }, a.fn.sbyOwlCarousel = function (b) {
      var c = Array.prototype.slice.call(arguments, 1);
      return this.each(function () {
        var d = a(this),
          f = d.data("owl.carousel");
        f || (f = new e(this, "object" == _typeof(b) && b), d.data("owl.carousel", f), a.each(["next", "prev", "to", "destroy", "refresh", "replace", "add", "remove"], function (b, c) {
          f.register({
            type: e.Type.Event,
            name: c
          }), f.$element.on(c + ".owl.carousel.core", a.proxy(function (a) {
            a.namespace && a.relatedTarget !== this && (this.suppress([c]), f[c].apply(this, [].slice.call(arguments, 1)), this.release([c]));
          }, f));
        })), "string" == typeof b && "_" !== b.charAt(0) && f[b].apply(f, c);
      });
    }, a.fn.sbyOwlCarousel.Constructor = e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var e = function e(b) {
      this._core = b, this._interval = null, this._visible = null, this._handlers = {
        "initialized.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.autoRefresh && this.watch();
        }, this)
      }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers);
    };
    e.Defaults = {
      autoRefresh: !0,
      autoRefreshInterval: 500
    }, e.prototype.watch = function () {
      this._interval || (this._visible = this._core.$element.is(":visible"), this._interval = b.setInterval(a.proxy(this.refresh, this), this._core.settings.autoRefreshInterval));
    }, e.prototype.refresh = function () {
      this._core.$element.is(":visible") !== this._visible && (this._visible = !this._visible, this._core.$element.toggleClass("sby-owl-hidden", !this._visible), this._visible && this._core.invalidate("width") && this._core.refresh());
    }, e.prototype.destroy = function () {
      var a, c;
      b.clearInterval(this._interval);
      for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
      for (c in Object.getOwnPropertyNames(this)) "function" != typeof this[c] && (this[c] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.AutoRefresh = e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var e = function e(b) {
      this._core = b, this._loaded = [], this._handlers = {
        "initialized.owl.carousel change.owl.carousel resized.owl.carousel": a.proxy(function (b) {
          if (b.namespace && this._core.settings && this._core.settings.lazyLoad && (b.property && "position" == b.property.name || "initialized" == b.type)) for (var c = this._core.settings, e = c.center && Math.ceil(c.items / 2) || c.items, f = c.center && e * -1 || 0, g = (b.property && b.property.value !== d ? b.property.value : this._core.current()) + f, h = this._core.clones().length, i = a.proxy(function (a, b) {
              this.load(b);
            }, this); f++ < e;) this.load(h / 2 + this._core.relative(g)), h && a.each(this._core.clones(this._core.relative(g)), i), g++;
        }, this)
      }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers);
    };
    e.Defaults = {
      lazyLoad: !1
    }, e.prototype.load = function (c) {
      var d = this._core.$stage.children().eq(c),
        e = d && d.find(".sby-owl-lazy");
      !e || a.inArray(d.get(0), this._loaded) > -1 || (e.each(a.proxy(function (c, d) {
        var e,
          f = a(d),
          g = b.devicePixelRatio > 1 && f.attr("data-src-retina") || f.attr("data-src");
        this._core.trigger("load", {
          element: f,
          url: g
        }, "lazy"), f.is("img") ? f.one("load.owl.lazy", a.proxy(function () {
          f.css("opacity", 1), this._core.trigger("loaded", {
            element: f,
            url: g
          }, "lazy");
        }, this)).attr("src", g) : (e = new Image(), e.onload = a.proxy(function () {
          f.css({
            "background-image": 'url("' + g + '")',
            opacity: "1"
          }), this._core.trigger("loaded", {
            element: f,
            url: g
          }, "lazy");
        }, this), e.src = g);
      }, this)), this._loaded.push(d.get(0)));
    }, e.prototype.destroy = function () {
      var a, b;
      for (a in this.handlers) this._core.$element.off(a, this.handlers[a]);
      for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.Lazy = e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var e = function e(b) {
      this._core = b, this._handlers = {
        "initialized.owl.carousel refreshed.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.autoHeight && this.update();
        }, this),
        "changed.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.autoHeight && "position" == a.property.name && this.update();
        }, this),
        "loaded.owl.lazy": a.proxy(function (a) {
          a.namespace && this._core.settings.autoHeight && a.element.closest("." + this._core.settings.itemClass).index() === this._core.current() && this.update();
        }, this)
      }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers);
    };
    e.Defaults = {
      autoHeight: !1,
      autoHeightClass: "sby-owl-height"
    }, e.prototype.update = function () {
      var b = this._core._current,
        c = b + this._core.settings.items,
        d = this._core.$stage.children().toArray().slice(b, c),
        e = [],
        f = 0;
      a.each(d, function (b, c) {
        e.push(a(c).height());
      }), f = Math.max.apply(null, e), this._core.$stage.parent().height(f).addClass(this._core.settings.autoHeightClass);
    }, e.prototype.destroy = function () {
      var a, b;
      for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
      for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.AutoHeight = e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var e = function e(b) {
      this._core = b, this._videos = {}, this._playing = null, this._handlers = {
        "initialized.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.register({
            type: "state",
            name: "playing",
            tags: ["interacting"]
          });
        }, this),
        "resize.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.video && this.isInFullScreen() && a.preventDefault();
        }, this),
        "refreshed.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.is("resizing") && this._core.$stage.find(".cloned .sby-owl-video-frame").remove();
        }, this),
        "changed.owl.carousel": a.proxy(function (a) {
          a.namespace && "position" === a.property.name && this._playing && this.stop();
        }, this),
        "prepared.owl.carousel": a.proxy(function (b) {
          if (b.namespace) {
            var c = a(b.content).find(".sby-owl-video");
            c.length && (c.css("display", "none"), this.fetch(c, a(b.content)));
          }
        }, this)
      }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers), this._core.$element.on("click.owl.video", ".sby-owl-video-play-icon", a.proxy(function (a) {
        this.play(a);
      }, this));
    };
    e.Defaults = {
      video: !1,
      videoHeight: !1,
      videoWidth: !1
    }, e.prototype.fetch = function (a, b) {
      var c = function () {
          return a.attr("data-vimeo-id") ? "vimeo" : a.attr("data-vzaar-id") ? "vzaar" : "youtube";
        }(),
        d = a.attr("data-vimeo-id") || a.attr("data-youtube-id") || a.attr("data-vzaar-id"),
        e = a.attr("data-width") || this._core.settings.videoWidth,
        f = a.attr("data-height") || this._core.settings.videoHeight,
        g = a.attr("href");
      if (!g) throw new Error("Missing video URL.");
      if (d = g.match(/(http:|https:|)\/\/(player.|www.|app.)?(vimeo\.com|youtu(be\.com|\.be|be\.googleapis\.com)|vzaar\.com)\/(video\/|videos\/|embed\/|channels\/.+\/|groups\/.+\/|watch\?v=|v\/)?([A-Za-z0-9._%-]*)(\&\S+)?/), d[3].indexOf("youtu") > -1) c = "youtube";else if (d[3].indexOf("vimeo") > -1) c = "vimeo";else {
        if (!(d[3].indexOf("vzaar") > -1)) throw new Error("Video URL not supported.");
        c = "vzaar";
      }
      d = d[6], this._videos[g] = {
        type: c,
        id: d,
        width: e,
        height: f
      }, b.attr("data-video", g), this.thumbnail(a, this._videos[g]);
    }, e.prototype.thumbnail = function (b, c) {
      var d,
        e,
        f,
        g = c.width && c.height ? 'style="width:' + c.width + "px;height:" + c.height + 'px;"' : "",
        h = b.find("img"),
        i = "src",
        j = "",
        k = this._core.settings,
        l = function l(a) {
          e = '<div class="sby-owl-video-play-icon"></div>', d = k.lazyLoad ? '<div class="sby-owl-video-tn ' + j + '" ' + i + '="' + a + '"></div>' : '<div class="sby-owl-video-tn" style="opacity:1;background-image:url(' + a + ')"></div>', b.after(d), b.after(e);
        };
      if (b.wrap('<div class="sby-owl-video-wrapper"' + g + "></div>"), this._core.settings.lazyLoad && (i = "data-src", j = "sby-owl-lazy"), h.length) return l(h.attr(i)), h.remove(), !1;
      "youtube" === c.type ? (f = "//img.youtube.com/vi/" + c.id + "/hqdefault.jpg", l(f)) : "vimeo" === c.type ? a.ajax({
        type: "GET",
        url: "//vimeo.com/api/v2/video/" + c.id + ".json",
        jsonp: "callback",
        dataType: "jsonp",
        success: function success(a) {
          f = a[0].thumbnail_large, l(f);
        }
      }) : "vzaar" === c.type && a.ajax({
        type: "GET",
        url: "//vzaar.com/api/videos/" + c.id + ".json",
        jsonp: "callback",
        dataType: "jsonp",
        success: function success(a) {
          f = a.framegrab_url, l(f);
        }
      });
    }, e.prototype.stop = function () {
      this._core.trigger("stop", null, "video"), this._playing.find(".sby-owl-video-frame").remove(), this._playing.removeClass("sby-owl-video-playing"), this._playing = null, this._core.leave("playing"), this._core.trigger("stopped", null, "video");
    }, e.prototype.play = function (b) {
      var c,
        d = a(b.target),
        e = d.closest("." + this._core.settings.itemClass),
        f = this._videos[e.attr("data-video")],
        g = f.width || "100%",
        h = f.height || this._core.$stage.height();
      this._playing || (this._core.enter("playing"), this._core.trigger("play", null, "video"), e = this._core.items(this._core.relative(e.index())), this._core.reset(e.index()), "youtube" === f.type ? c = '<iframe width="' + g + '" height="' + h + '" src="//www.youtube.com/embed/' + f.id + "?autoplay=1&rel=0&v=" + f.id + '" frameborder="0" allowfullscreen></iframe>' : "vimeo" === f.type ? c = '<iframe src="//player.vimeo.com/video/' + f.id + '?autoplay=1" width="' + g + '" height="' + h + '" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>' : "vzaar" === f.type && (c = '<iframe frameborder="0"height="' + h + '"width="' + g + '" allowfullscreen mozallowfullscreen webkitAllowFullScreen src="//view.vzaar.com/' + f.id + '/player?autoplay=true"></iframe>'), a('<div class="sby-owl-video-frame">' + c + "</div>").insertAfter(e.find(".sby-owl-video")), this._playing = e.addClass("sby-owl-video-playing"));
    }, e.prototype.isInFullScreen = function () {
      var b = c.fullscreenElement || c.mozFullScreenElement || c.webkitFullscreenElement;
      return b && a(b).parent().hasClass("sby-owl-video-frame");
    }, e.prototype.destroy = function () {
      var a, b;
      this._core.$element.off("click.owl.video");
      for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
      for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.Video = e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var e = function e(b) {
      this.core = b, this.core.options = a.extend({}, e.Defaults, this.core.options), this.swapping = !0, this.previous = d, this.next = d, this.handlers = {
        "change.owl.carousel": a.proxy(function (a) {
          a.namespace && "position" == a.property.name && (this.previous = this.core.current(), this.next = a.property.value);
        }, this),
        "drag.owl.carousel dragged.owl.carousel translated.owl.carousel": a.proxy(function (a) {
          a.namespace && (this.swapping = "translated" == a.type);
        }, this),
        "translate.owl.carousel": a.proxy(function (a) {
          a.namespace && this.swapping && (this.core.options.animateOut || this.core.options.animateIn) && this.swap();
        }, this)
      }, this.core.$element.on(this.handlers);
    };
    e.Defaults = {
      animateOut: !1,
      animateIn: !1
    }, e.prototype.swap = function () {
      if (1 === this.core.settings.items && a.support.animation && a.support.transition) {
        this.core.speed(0);
        var b,
          c = a.proxy(this.clear, this),
          d = this.core.$stage.children().eq(this.previous),
          e = this.core.$stage.children().eq(this.next),
          f = this.core.settings.animateIn,
          g = this.core.settings.animateOut;
        this.core.current() !== this.previous && (g && (b = this.core.coordinates(this.previous) - this.core.coordinates(this.next), d.one(a.support.animation.end, c).css({
          left: b + "px"
        }).addClass("animated sby-owl-animated-out").addClass(g)), f && e.one(a.support.animation.end, c).addClass("animated sby-owl-animated-in").addClass(f));
      }
    }, e.prototype.clear = function (b) {
      a(b.target).css({
        left: ""
      }).removeClass("animated sby-owl-animated-out sby-owl-animated-in").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut), this.core.onTransitionEnd();
    }, e.prototype.destroy = function () {
      var a, b;
      for (a in this.handlers) this.core.$element.off(a, this.handlers[a]);
      for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.Animate = e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    var e = function e(b) {
      this._core = b, this._timeout = null, this._paused = !1, this._handlers = {
        "changed.owl.carousel": a.proxy(function (a) {
          a.namespace && "settings" === a.property.name ? this._core.settings.autoplay ? this.play() : this.stop() : a.namespace && "position" === a.property.name && this._core.settings.autoplay && this._setAutoPlayInterval();
        }, this),
        "initialized.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.autoplay && this.play();
        }, this),
        "play.owl.autoplay": a.proxy(function (a, b, c) {
          a.namespace && this.play(b, c);
        }, this),
        "stop.owl.autoplay": a.proxy(function (a) {
          a.namespace && this.stop();
        }, this),
        "mouseover.owl.autoplay": a.proxy(function () {
          this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.pause();
        }, this),
        "mouseleave.owl.autoplay": a.proxy(function () {
          this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.play();
        }, this),
        "touchstart.owl.core": a.proxy(function () {
          this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.pause();
        }, this),
        "touchend.owl.core": a.proxy(function () {
          this._core.settings.autoplayHoverPause && this.play();
        }, this)
      }, this._core.$element.on(this._handlers), this._core.options = a.extend({}, e.Defaults, this._core.options);
    };
    e.Defaults = {
      autoplay: !1,
      autoplayTimeout: 5e3,
      autoplayHoverPause: !1,
      autoplaySpeed: !1
    }, e.prototype.play = function (a, b) {
      this._paused = !1, this._core.is("rotating") || (this._core.enter("rotating"), this._setAutoPlayInterval());
    }, e.prototype._getNextTimeout = function (d, e) {
      return this._timeout && b.clearTimeout(this._timeout), b.setTimeout(a.proxy(function () {
        this._paused || this._core.is("busy") || this._core.is("interacting") || c.hidden || this._core.next(e || this._core.settings.autoplaySpeed);
      }, this), d || this._core.settings.autoplayTimeout);
    }, e.prototype._setAutoPlayInterval = function () {
      this._timeout = this._getNextTimeout();
    }, e.prototype.stop = function () {
      this._core.is("rotating") && (b.clearTimeout(this._timeout), this._core.leave("rotating"));
    }, e.prototype.pause = function () {
      this._core.is("rotating") && (this._paused = !0);
    }, e.prototype.destroy = function () {
      var a, b;
      this.stop();
      for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
      for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.autoplay = e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    "use strict";

    var e = function e(b) {
      this._core = b, this._initialized = !1, this._pages = [], this._controls = {}, this._templates = [], this.$element = this._core.$element, this._overrides = {
        next: this._core.next,
        prev: this._core.prev,
        to: this._core.to
      }, this._handlers = {
        "prepared.owl.carousel": a.proxy(function (b) {
          b.namespace && this._core.settings.dotsData && this._templates.push('<div class="' + this._core.settings.dotClass + '">' + a(b.content).find("[data-dot]").addBack("[data-dot]").attr("data-dot") + "</div>");
        }, this),
        "added.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.dotsData && this._templates.splice(a.position, 0, this._templates.pop());
        }, this),
        "remove.owl.carousel": a.proxy(function (a) {
          a.namespace && this._core.settings.dotsData && this._templates.splice(a.position, 1);
        }, this),
        "changed.owl.carousel": a.proxy(function (a) {
          a.namespace && "position" == a.property.name && this.draw();
        }, this),
        "initialized.owl.carousel": a.proxy(function (a) {
          a.namespace && !this._initialized && (this._core.trigger("initialize", null, "navigation"), this.initialize(), this.update(), this.draw(), this._initialized = !0, this._core.trigger("initialized", null, "navigation"));
        }, this),
        "refreshed.owl.carousel": a.proxy(function (a) {
          a.namespace && this._initialized && (this._core.trigger("refresh", null, "navigation"), this.update(), this.draw(), this._core.trigger("refreshed", null, "navigation"));
        }, this)
      }, this._core.options = a.extend({}, e.Defaults, this._core.options), this.$element.on(this._handlers);
    };
    e.Defaults = {
      nav: !1,
      navText: ["prev", "next"],
      navSpeed: !1,
      navElement: "div",
      navContainer: !1,
      navContainerClass: "sby-owl-nav",
      navClass: ["sby-owl-prev", "sby-owl-next"],
      slideBy: 1,
      dotClass: "sby-owl-dot",
      dotsClass: "sby-owl-dots",
      dots: !0,
      dotsEach: !1,
      dotsData: !1,
      dotsSpeed: !1,
      dotsContainer: !1
    }, e.prototype.initialize = function () {
      var b,
        c = this._core.settings;
      this._controls.$relative = (c.navContainer ? a(c.navContainer) : a("<div>").addClass(c.navContainerClass).appendTo(this.$element)).addClass("disabled"), this._controls.$previous = a("<" + c.navElement + ">").addClass(c.navClass[0]).html(c.navText[0]).prependTo(this._controls.$relative).on("click", a.proxy(function (a) {
        this.prev(c.navSpeed);
      }, this)), this._controls.$next = a("<" + c.navElement + ">").addClass(c.navClass[1]).html(c.navText[1]).appendTo(this._controls.$relative).on("click", a.proxy(function (a) {
        this.next(c.navSpeed);
      }, this)), c.dotsData || (this._templates = [a("<div>").addClass(c.dotClass).append(a("<span>")).prop("outerHTML")]), this._controls.$absolute = (c.dotsContainer ? a(c.dotsContainer) : a("<div>").addClass(c.dotsClass).appendTo(this.$element)).addClass("disabled"), this._controls.$absolute.on("click", "div", a.proxy(function (b) {
        var d = a(b.target).parent().is(this._controls.$absolute) ? a(b.target).index() : a(b.target).parent().index();
        b.preventDefault(), this.to(d, c.dotsSpeed);
      }, this));
      for (b in this._overrides) this._core[b] = a.proxy(this[b], this);
    }, e.prototype.destroy = function () {
      var a, b, c, d;
      for (a in this._handlers) this.$element.off(a, this._handlers[a]);
      for (b in this._controls) this._controls[b].remove();
      for (d in this.overides) this._core[d] = this._overrides[d];
      for (c in Object.getOwnPropertyNames(this)) "function" != typeof this[c] && (this[c] = null);
    }, e.prototype.update = function () {
      var a,
        b,
        c,
        d = this._core.clones().length / 2,
        e = d + this._core.items().length,
        f = this._core.maximum(!0),
        g = this._core.settings,
        h = g.center || g.autoWidth || g.dotsData ? 1 : g.dotsEach || g.items;
      if ("page" !== g.slideBy && (g.slideBy = Math.min(g.slideBy, g.items)), g.dots || "page" == g.slideBy) for (this._pages = [], a = d, b = 0, c = 0; a < e; a++) {
        if (b >= h || 0 === b) {
          if (this._pages.push({
            start: Math.min(f, a - d),
            end: a - d + h - 1
          }), Math.min(f, a - d) === f) break;
          b = 0, ++c;
        }
        b += this._core.mergers(this._core.relative(a));
      }
    }, e.prototype.draw = function () {
      var b,
        c = this._core.settings,
        d = this._core.items().length <= c.items,
        e = this._core.relative(this._core.current()),
        f = c.loop || c.rewind;
      this._controls.$relative.toggleClass("disabled", !c.nav || d), c.nav && (this._controls.$previous.toggleClass("disabled", !f && e <= this._core.minimum(!0)), this._controls.$next.toggleClass("disabled", !f && e >= this._core.maximum(!0))), this._controls.$absolute.toggleClass("disabled", !c.dots || d), c.dots && (b = this._pages.length - this._controls.$absolute.children().length, c.dotsData && 0 !== b ? this._controls.$absolute.html(this._templates.join("")) : b > 0 ? this._controls.$absolute.append(new Array(b + 1).join(this._templates[0])) : b < 0 && this._controls.$absolute.children().slice(b).remove(), this._controls.$absolute.find(".active").removeClass("active"), this._controls.$absolute.children().eq(a.inArray(this.current(), this._pages)).addClass("active"));
    }, e.prototype.onTrigger = function (b) {
      var c = this._core.settings;
      b.page = {
        index: a.inArray(this.current(), this._pages),
        count: this._pages.length,
        size: c && (c.center || c.autoWidth || c.dotsData ? 1 : c.dotsEach || c.items)
      };
    }, e.prototype.current = function () {
      var b = this._core.relative(this._core.current());
      return a.grep(this._pages, a.proxy(function (a, c) {
        return a.start <= b && a.end >= b;
      }, this)).pop();
    }, e.prototype.getPosition = function (b) {
      var c,
        d,
        e = this._core.settings;
      return "page" == e.slideBy ? (c = a.inArray(this.current(), this._pages), d = this._pages.length, b ? ++c : --c, c = this._pages[(c % d + d) % d].start) : (c = this._core.relative(this._core.current()), d = this._core.items().length, b ? c += e.slideBy : c -= e.slideBy), c;
    }, e.prototype.next = function (b) {
      a.proxy(this._overrides.to, this._core)(this.getPosition(!0), b);
    }, e.prototype.prev = function (b) {
      a.proxy(this._overrides.to, this._core)(this.getPosition(!1), b);
    }, e.prototype.to = function (b, c, d) {
      var e;
      !d && this._pages.length ? (e = this._pages.length, a.proxy(this._overrides.to, this._core)(this._pages[(b % e + e) % e].start, c)) : a.proxy(this._overrides.to, this._core)(b, c);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.Navigation = e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    "use strict";

    var e = function e(c) {
      this._core = c, this._hashes = {}, this.$element = this._core.$element, this._handlers = {
        "initialized.owl.carousel": a.proxy(function (c) {
          c.namespace && "URLHash" === this._core.settings.startPosition && a(b).trigger("hashchange.owl.navigation");
        }, this),
        "prepared.owl.carousel": a.proxy(function (b) {
          if (b.namespace) {
            var c = a(b.content).find("[data-hash]").addBack("[data-hash]").attr("data-hash");
            if (!c) return;
            this._hashes[c] = b.content;
          }
        }, this),
        "changed.owl.carousel": a.proxy(function (c) {
          if (c.namespace && "position" === c.property.name) {
            var d = this._core.items(this._core.relative(this._core.current())),
              e = a.map(this._hashes, function (a, b) {
                return a === d ? b : null;
              }).join();
            if (!e || b.location.hash.slice(1) === e) return;
            b.location.hash = e;
          }
        }, this)
      }, this._core.options = a.extend({}, e.Defaults, this._core.options), this.$element.on(this._handlers), a(b).on("hashchange.owl.navigation", a.proxy(function (a) {
        var c = b.location.hash.substring(1),
          e = this._core.$stage.children(),
          f = this._hashes[c] && e.index(this._hashes[c]);
        f !== d && f !== this._core.current() && this._core.to(this._core.relative(f), !1, !0);
      }, this));
    };
    e.Defaults = {
      URLhashListener: !1
    }, e.prototype.destroy = function () {
      var c, d;
      a(b).off("hashchange.owl.navigation");
      for (c in this._handlers) this._core.$element.off(c, this._handlers[c]);
      for (d in Object.getOwnPropertyNames(this)) "function" != typeof this[d] && (this[d] = null);
    }, a.fn.sbyOwlCarousel.Constructor.Plugins.Hash = e;
  }(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
    function e(b, c) {
      var e = !1,
        f = b.charAt(0).toUpperCase() + b.slice(1);
      return a.each((b + " " + h.join(f + " ") + f).split(" "), function (a, b) {
        if (g[b] !== d) return e = !c || b, !1;
      }), e;
    }
    function f(a) {
      return e(a, !0);
    }
    var g = a("<support>").get(0).style,
      h = "Webkit Moz O ms".split(" "),
      i = {
        transition: {
          end: {
            WebkitTransition: "webkitTransitionEnd",
            MozTransition: "transitionend",
            OTransition: "oTransitionEnd",
            transition: "transitionend"
          }
        },
        animation: {
          end: {
            WebkitAnimation: "webkitAnimationEnd",
            MozAnimation: "animationend",
            OAnimation: "oAnimationEnd",
            animation: "animationend"
          }
        }
      },
      j = {
        csstransforms: function csstransforms() {
          return !!e("transform");
        },
        csstransforms3d: function csstransforms3d() {
          return !!e("perspective");
        },
        csstransitions: function csstransitions() {
          return !!e("transition");
        },
        cssanimations: function cssanimations() {
          return !!e("animation");
        }
      };
    j.csstransitions() && (a.support.transition = new String(f("transition")), a.support.transition.end = i.transition.end[a.support.transition]), j.cssanimations() && (a.support.animation = new String(f("animation")), a.support.animation.end = i.animation.end[a.support.animation]), j.csstransforms() && (a.support.transform = new String(f("transform")), a.support.transform3d = j.csstransforms3d());
  }(window.Zepto || window.jQuery, window, document);

  // Two Row Carousel
  ;
  (function ($, window, document, undefined) {
    Owl2row = function (_Owl2row) {
      function Owl2row(_x) {
        return _Owl2row.apply(this, arguments);
      }
      Owl2row.toString = function () {
        return _Owl2row.toString();
      };
      return Owl2row;
    }(function (scope) {
      this.owl = scope;
      this.owl.options = $.extend({}, Owl2row.Defaults, this.owl.options);
      //link callback events with owl carousel here

      this.handlers = {
        'initialize.owl.carousel': $.proxy(function (e) {
          if (this.owl.settings.owl2row) {
            this.build2row(this);
          }
        }, this)
      };
      this.owl.$element.on(this.handlers);
    });
    Owl2row.Defaults = {
      owl2row: false,
      owl2rowTarget: 'sby_item',
      owl2rowContainer: 'sby_owl2row-item',
      owl2rowDirection: 'utd' // ltr
    };

    //mehtods:
    Owl2row.prototype.build2row = function (thisScope) {
      var carousel = $(thisScope.owl.$element);
      var carouselItems = carousel.find('.' + thisScope.owl.options.owl2rowTarget);
      var aEvenElements = [];
      var aOddElements = [];
      $.each(carouselItems, function (index, item) {
        if (index % 2 === 0) {
          aEvenElements.push(item);
        } else {
          aOddElements.push(item);
        }
      });

      //carousel.empty();

      switch (thisScope.owl.options.owl2rowDirection) {
        case 'ltr':
          thisScope.leftToright(thisScope, carousel, carouselItems);
          break;
        default:
          thisScope.upTodown(thisScope, aEvenElements, aOddElements, carousel);
      }
    };
    Owl2row.prototype.leftToright = function (thisScope, carousel, carouselItems) {
      var o2wContainerClass = thisScope.owl.options.owl2rowContainer;
      var owlMargin = thisScope.owl.options.margin;
      var carouselItemsLength = carouselItems.length;
      var firsArr = [];
      var secondArr = [];
      if (carouselItemsLength % 2 === 1) {
        carouselItemsLength = (carouselItemsLength - 1) / 2 + 1;
      } else {
        carouselItemsLength = carouselItemsLength / 2;
      }
      $.each(carouselItems, function (index, item) {
        if (index < carouselItemsLength) {
          firsArr.push(item);
        } else {
          secondArr.push(item);
        }
      });
      $.each(firsArr, function (index, item) {
        var rowContainer = $('<div class="' + o2wContainerClass + '"/>');
        var firstRowElement = firsArr[index];
        firstRowElement.style.marginBottom = owlMargin + 'px';
        rowContainer.append(firstRowElement).append(secondArr[index]);
        carousel.append(rowContainer);
      });
    };
    Owl2row.prototype.upTodown = function (thisScope, aEvenElements, aOddElements, carousel) {
      var o2wContainerClass = thisScope.owl.options.owl2rowContainer;
      var owlMargin = thisScope.owl.options.margin;
      $.each(aEvenElements, function (index, item) {
        var rowContainer = $('<div class="' + o2wContainerClass + '"/>');
        var evenElement = aEvenElements[index];
        evenElement.style.marginBottom = owlMargin + 'px';
        rowContainer.append(evenElement).append(aOddElements[index]);
        carousel.append(rowContainer);
      });
    };

    /**
     * Destroys the plugin.
     */
    Owl2row.prototype.destroy = function () {
      var handler, property;
    };
    $.fn.sbyOwlCarousel.Constructor.Plugins['owl2row'] = Owl2row;
  })(window.Zepto || window.jQuery, window, document);
  (function ($) {
    function sbyAddVisibilityListener() {
      /* Detect when element becomes visible. Used for when the feed is initially hidden, in a tab for example. https://github.com/shaunbowe/jquery.visibilityChanged */
      !function (i) {
        var n = {
            callback: function callback() {},
            runOnLoad: !0,
            frequency: 100,
            sbyPreviousVisibility: null
          },
          c = {};
        c.sbyCheckVisibility = function (i, n) {
          if (jQuery.contains(document, i[0])) {
            var e = n.sbyPreviousVisibility,
              t = i.is(":visible");
            n.sbyPreviousVisibility = t, null == e ? n.runOnLoad && n.callback(i, t) : e !== t && n.callback(i, t), setTimeout(function () {
              c.sbyCheckVisibility(i, n);
            }, n.frequency);
          }
        }, i.fn.sbyVisibilityChanged = function (e) {
          var t = i.extend({}, n, e);
          return this.each(function () {
            c.sbyCheckVisibility(i(this), t);
          });
        };
      }(jQuery);
    }
    function Sby() {
      this.feeds = {};
      this.ctas = {};
      this.options = sbyOptions;
      this.isTouch = sbyIsTouch();
    }
    Sby.prototype = {
      createPage: function createPage(createFeeds, createFeedsArgs) {
        if (typeof window.sbyajaxurl === 'undefined' || window.sbyajaxurl.indexOf(window.location.hostname) === -1) {
          window.sbyajaxurl = window.location.hostname + '/wp-admin/admin-ajax.php';
        }
        $('.sby_no_js_error_message').remove();
        $('.sby_no_js').removeClass('sby_no_js');
        createFeeds(createFeedsArgs);
      },
      maybeAddYTAPI: function maybeAddYTAPI() {
        var youtubeScriptId = "sby-youtube-api";
        var youtubeScript = document.getElementById(youtubeScriptId);
        if (youtubeScript === null) {
          var tag = document.createElement("script");
          var firstScript = document.getElementsByTagName("script")[0];
          tag.src = "https://www.youtube.com/iframe_api";
          tag.id = youtubeScriptId;
          firstScript.parentNode.insertBefore(tag, firstScript);
        }
      },
      createLightbox: function createLightbox() {
        var lbBuilder = sbyGetlightboxBuilder();
        var sby_lb_delay = function () {
          var sby_timer = 0;
          return function (sby_callback, sby_ms) {
            clearTimeout(sby_timer);
            sby_timer = setTimeout(sby_callback, sby_ms);
          };
        }();
        jQuery(window).on('resize', function () {
          sby_lb_delay(function () {
            lbBuilder.afterResize();
          }, 200);
        });
        /* Lightbox v2.7.1 by Lokesh Dhakar - http://lokeshdhakar.com/projects/lightbox2/ - Heavily modified specifically for this plugin */
        (function () {
          var a = jQuery,
            b = function () {
              function a() {
                this.fadeDuration = 500, this.fitImagesInViewport = !0, this.resizeDuration = 700, this.positionFromTop = 50, this.showImageNumberLabel = !0, this.alwaysShowNavOnTouchDevices = !1, this.wrapAround = !1;
              }
              return a.prototype.albumLabel = function (a, b) {
                return a + " / " + b;
              }, a;
            }(),
            c = function () {
              function b(a) {
                this.options = a, this.album = [], this.currentImageIndex = void 0, this.init();
              }
              return b.prototype.init = function () {
                this.enable(), this.build();
              }, b.prototype.enable = function () {
                var b = this;
                a("body").on("click", "a[data-sby-lightbox]", function (c) {
                  return b.start(a(c.currentTarget)), !1;
                });
              }, b.prototype.build = function () {
                var b = this;
                a("" + lbBuilder.template()).appendTo(a("body")), this.$lightbox = a("#sby_lightbox"), this.$overlay = a("#sby_lightboxOverlay"), this.$outerContainer = this.$lightbox.find(".sby_lb-outerContainer"), this.$container = this.$lightbox.find(".sby_lb-container"), this.containerTopPadding = parseInt(this.$container.css("padding-top"), 10), this.containerRightPadding = parseInt(this.$container.css("padding-right"), 10), this.containerBottomPadding = parseInt(this.$container.css("padding-bottom"), 10), this.containerLeftPadding = parseInt(this.$container.css("padding-left"), 10), this.$overlay.hide().on("click", function () {
                  return b.end(), !1;
                }), jQuery(document).on('click', function (event, b, c) {
                  //Fade out the lightbox if click anywhere outside of the two elements defined below
                  if (!jQuery(event.target).closest('.sby_lb-outerContainer').length) {
                    if (!jQuery(event.target).closest('.sby_lb-dataContainer').length) {
                      //Fade out lightbox
                      lightboxOnClose();
                      lbBuilder.pausePlayer();
                      jQuery('#sby_lightboxOverlay, #sby_lightbox').fadeOut();
                    }
                  }
                }), this.$lightbox.hide(), jQuery('#sby_lightboxOverlay').on("click", function (c) {
                  lbBuilder.pausePlayer();
                  jQuery('.sby_gdpr_notice').remove();
                  return "sby_lightbox" === a(c.target).attr("id") && b.end(), !1;
                }), this.$lightbox.find(".sby_lb-prev").on("click", function () {
                  lbBuilder.pausePlayer();
                  jQuery('.sby_gdpr_notice').remove();
                  return b.changeImage(0 === b.currentImageIndex ? b.album.length - 1 : b.currentImageIndex - 1), !1;
                }), this.$lightbox.find(".sby_lb-container").on("swiperight", function () {
                  lbBuilder.pausePlayer();
                  jQuery('.sby_gdpr_notice').remove();
                  return b.changeImage(0 === b.currentImageIndex ? b.album.length - 1 : b.currentImageIndex - 1), !1;
                }), this.$lightbox.find(".sby_lb-next").on("click", function () {
                  lbBuilder.pausePlayer();
                  jQuery('.sby_gdpr_notice').remove();
                  return b.changeImage(b.currentImageIndex === b.album.length - 1 ? 0 : b.currentImageIndex + 1), !1;
                }), this.$lightbox.find(".sby_lb-container").on("swipeleft", function () {
                  lbBuilder.pausePlayer();
                  jQuery('.sby_gdpr_notice').remove();
                  return b.changeImage(b.currentImageIndex === b.album.length - 1 ? 0 : b.currentImageIndex + 1), !1;
                }), this.$lightbox.find(".sby_lb-loader, .sby_lb-close").on("click", function () {
                  lightboxOnClose();
                  lbBuilder.pausePlayer();
                  return b.end(), !1;
                });
              }, b.prototype.start = function (b) {
                function c(a) {
                  d.album.push(lbBuilder.getData(a));
                }
                var d = this,
                  e = a(window);
                e.on("resize", a.proxy(this.sizeOverlay, this)), a("select, object, embed").css({
                  visibility: "hidden"
                }), this.sizeOverlay(), this.album = [];
                var f,
                  g = 0,
                  h = b.attr("data-sby-lightbox");
                if (h) {
                  f = a(b.prop("tagName") + '[data-sby-lightbox="' + h + '"]');
                  for (var i = 0; i < f.length; i = ++i) c(a(f[i])), f[i] === b[0] && (g = i);
                } else if ("lightbox" === b.attr("rel")) c(b);else {
                  f = a(b.prop("tagName") + '[rel="' + b.attr("rel") + '"]');
                  for (var j = 0; j < f.length; j = ++j) c(a(f[j])), f[j] === b[0] && (g = j);
                }
                var k = e.scrollTop() + this.options.positionFromTop - 50,
                  l = e.scrollLeft();
                this.$lightbox.css({
                  top: k + "px",
                  left: l + "px"
                }).fadeIn(this.options.fadeDuration), this.changeImage(g);
              }, b.prototype.changeImage = function (b) {
                var c = this;
                this.disableKeyboardNav();
                var d = this.$lightbox.find(".sby_lb-image");
                this.$overlay.fadeIn(this.options.fadeDuration), a(".sby_lb-loader").fadeIn("slow"), this.$lightbox.find(".sby_lb-image, .sby_lb-nav, .sby_lb-prev, .sby_lb-next, .sby_lb-dataContainer, .sby_lb-numbers, .sby_lb-caption").hide(), this.$outerContainer.addClass("animating");
                var e = new Image();
                e.onload = function () {
                  var f, g, h, i, j, k, l;
                  var sbyArrowWidth = 100;
                  d.attr("src", c.album[b].link), f = a(e), d.width(e.width), d.height(e.height), c.options.fitImagesInViewport && (l = a(window).width(), k = a(window).height(), j = l - c.containerLeftPadding - c.containerRightPadding - 20 - sbyArrowWidth, i = k - c.containerTopPadding - c.containerBottomPadding - 150, (e.width > j || e.height > i) && (e.width / j > e.height / i ? (h = j, g = parseInt(e.height / (e.width / h), 10), d.width(h), d.height(g)) : (g = i, h = parseInt(e.width / (e.height / g), 10), d.width(h), d.height(g)))), c.sizeContainer(d.width(), d.height());
                }, e.src = this.album[b].link, this.currentImageIndex = b;
              }, b.prototype.sizeOverlay = function () {
                this.$overlay.width(a(window).width()).height(a(document).height());
              }, b.prototype.sizeContainer = function (a, b) {
                function c() {
                  d.$lightbox.find(".sby_lb-dataContainer").width(g), d.$lightbox.find(".sby_lb-prevLink").height(h), d.$lightbox.find(".sby_lb-nextLink").height(h), d.showImage();
                }
                var d = this,
                  e = this.$outerContainer.outerWidth(),
                  f = this.$outerContainer.outerHeight(),
                  g = a + this.containerLeftPadding + this.containerRightPadding,
                  h = b + this.containerTopPadding + this.containerBottomPadding;
                e !== g || f !== h ? this.$outerContainer.animate({
                  width: g,
                  height: h
                }, this.options.resizeDuration, "swing", function () {
                  c();
                }) : c();
              }, b.prototype.showImage = function () {
                this.$lightbox.find(".sby_lb-loader").hide(), this.$lightbox.find(".sby_lb-image").fadeIn("slow"), this.updateNav(), this.updateDetails(), this.preloadNeighboringImages(), this.enableKeyboardNav();
              }, b.prototype.updateNav = function () {
                var a = !1;
                try {
                  document.createEvent("TouchEvent"), a = this.options.alwaysShowNavOnTouchDevices ? !0 : !1;
                } catch (b) {}
                this.$lightbox.find(".sby_lb-nav").show(), this.album.length > 1 && (this.options.wrapAround ? (a && this.$lightbox.find(".sby_lb-prev, .sby_lb-next").css("opacity", "1"), this.$lightbox.find(".sby_lb-prev, .sby_lb-next").show()) : (this.currentImageIndex > 0 && (this.$lightbox.find(".sby_lb-prev").show(), a && this.$lightbox.find(".sby_lb-prev").css("opacity", "1")), this.currentImageIndex < this.album.length - 1 && (this.$lightbox.find(".sby_lb-next").show(), a && this.$lightbox.find(".sby_lb-next").css("opacity", "1"))));
              }, b.prototype.updateDetails = function () {
                var b = this;

                /** NEW PHOTO ACTION **/
                if (jQuery('iframe.sby_lb-player-loaded').length) {
                  jQuery('.sby_lb-player-placeholder').replaceWith(jQuery('iframe.sby_lb-player-loaded'));
                  jQuery('iframe.sby_lb-player-loaded').removeClass('sby_lb-player-loaded').show();
                }
                //Switch video when either a new popup or navigating to new one
                var feed = window.sby.feeds[this.album[this.currentImageIndex].feedIndex];
                lbBuilder.beforePlayerSetup(this.$lightbox, this.album[this.currentImageIndex], this.currentImageIndex, this.album, feed);
                if (sby_supports_video()) {
                  jQuery('#sby_lightbox').removeClass('sby_video_lightbox');
                  if (feed.settings.consentGiven && this.album[this.currentImageIndex].video.length) {
                    jQuery('.sby_gdpr_notice').remove();
                    var playerID = 'sby_lb-player';
                    jQuery('#sby_lightbox').addClass('sby_video_lightbox');
                    if (!window.sbyOptions.isPro) {
                      jQuery('#sby_lightbox').addClass('sby_lightbox_free');
                    }
                    var videoID = this.album[this.currentImageIndex].video,
                      autoplay = sbyOptions.autoplay;
                    if (typeof window.sbyLightboxPlayer === 'undefined') {
                      var args = {
                        host: window.location.protocol + feed.embedURL,
                        videoId: videoID,
                        playerVars: {
                          modestbranding: 1,
                          rel: 0,
                          autoplay: autoplay
                        },
                        events: {
                          'onStateChange': function onStateChange(data) {
                            var videoID = data.target.getVideoData()['video_id'];
                            feed.afterStateChange(playerID, videoID, data, $('#' + playerID).closest('.sby_video_thumbnail_wrap'));
                          }
                        }
                      };
                      feed.maybeAddCTA(playerID);
                      window.sbyLightboxPlayer = new window.YT.Player(playerID, args);
                    } else {
                      window.sbyLightboxPlayer.loadVideoById(videoID);
                    }
                    this.$outerContainer.removeClass("animating");
                    this.$lightbox.find(".sby_lb-dataContainer").fadeIn(this.options.resizeDuration, function () {
                      return b.sizeOverlay();
                    });
                    setTimeout(function () {
                      $('#sby_lightbox .sby_lb-player').css({
                        'height': $('#sby_lightbox .sby_lb-outerContainer').height() + 'px',
                        'width': $('#sby_lightbox .sby_lb-outerContainer').width() + 'px',
                        'top': 0
                      });
                    }, 1);
                    if (this.$lightbox.find('iframe').length) {
                      this.$lightbox.find('iframe').attr('title', this.album[this.currentImageIndex].videoTitle);
                    }
                  } else {
                    var fullImage = $('.sby_item[data-video-id=' + this.album[this.currentImageIndex].video + ']').find('.sby_video_thumbnail').attr('data-full-res');
                    $('.sby_lb-image').attr('src', fullImage);
                    this.$outerContainer.removeClass("animating");
                    this.$lightbox.find(".sby_lb-dataContainer").fadeIn(this.options.resizeDuration, function () {
                      return b.sizeOverlay();
                    });
                    jQuery(".sby_lb-container").prepend('<a href="https://www.youtube.com/watch?v=' + this.album[this.currentImageIndex].video + '" target="_blank" rel="noopener noreferrer" class="sby_gdpr_notice"><svg style="color: rgba(255,255,255,1)" class="svg-inline--fa fa-play fa-w-14 sby_playbtn" aria-label="Play" aria-hidden="true" data-fa-processed="" data-prefix="fa" data-icon="play" role="presentation" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z"></path></svg></a>');
                  }
                  lbBuilder.afterPlayerSetup(this.$lightbox, this.album[this.currentImageIndex], this.currentImageIndex, this.album);
                  if (this.album.length > 1 && this.options.showImageNumberLabel) {
                    this.$lightbox.find(".sby_lb-number").text(this.options.albumLabel(this.currentImageIndex + 1, this.album.length)).fadeIn("fast");
                  } else {
                    this.$lightbox.find(".sby_lb-number").hide();
                  }
                }
              }, b.prototype.preloadNeighboringImages = function () {
                if (this.album.length > this.currentImageIndex + 1) {
                  var a = new Image();
                  a.src = this.album[this.currentImageIndex + 1].link;
                }
                if (this.currentImageIndex > 0) {
                  var b = new Image();
                  b.src = this.album[this.currentImageIndex - 1].link;
                }
              }, b.prototype.enableKeyboardNav = function () {
                a(document).on("keyup.keyboard", a.proxy(this.keyboardAction, this));
              }, b.prototype.disableKeyboardNav = function () {
                a(document).off(".keyboard");
              }, b.prototype.keyboardAction = function (a) {
                var KEYCODE_ESC = 27;
                var KEYCODE_LEFTARROW = 37;
                var KEYCODE_RIGHTARROW = 39;
                var keycode = event.keyCode;
                var key = String.fromCharCode(keycode).toLowerCase();
                if (keycode === KEYCODE_ESC || key.match(/x|o|c/)) {
                  if (sby_supports_video()) $('#sby_lightbox video.sby_video')[0].pause();
                  $('#sby_lightbox iframe').attr('src', '');
                  this.end();
                } else if (key === 'p' || keycode === KEYCODE_LEFTARROW) {
                  if (this.currentImageIndex !== 0) {
                    this.changeImage(this.currentImageIndex - 1);
                  } else if (this.options.wrapAround && this.album.length > 1) {
                    this.changeImage(this.album.length - 1);
                  }
                  if (sby_supports_video()) $('#sby_lightbox video.sby_video')[0].pause();
                  $('#sby_lightbox iframe').attr('src', '');
                } else if (key === 'n' || keycode === KEYCODE_RIGHTARROW) {
                  if (this.currentImageIndex !== this.album.length - 1) {
                    this.changeImage(this.currentImageIndex + 1);
                  } else if (this.options.wrapAround && this.album.length > 1) {
                    this.changeImage(0);
                  }
                  lbBuilder.pausePlayer();
                }
              }, b.prototype.end = function () {
                this.disableKeyboardNav(), a(window).off("resize", this.sizeOverlay), this.$lightbox.fadeOut(this.options.fadeDuration), this.$overlay.fadeOut(this.options.fadeDuration), a("select, object, embed").css({
                  visibility: "visible"
                });
              }, b;
            }();
          a(function () {
            {
              var a = new b();
              new c(a);
              //Lightbox hide photo function
              $('.sby_lightbox_action a').off().on('click', function () {
                $(this).parent().find('.sby_lightbox_tooltip').toggle();
              });
            }
          });
        }).call(this);
        window.sbyOptions.lightboxCreated = true;
      },
      createFeeds: function createFeeds(args) {
        if (!sbyOptions.isAdmin && sbyOptions.lightboxCreated === undefined) {
          window.sby.createLightbox();
        }
        args.whenFeedsCreated($('.sb_youtube').each(function (index) {
          $(this).attr('data-sby-index', index + 1);
          $(this).find('.sby_player').replaceWith('<div id="sby_player' + index + '"></div>');
          var $self = $(this),
            flags = typeof $self.attr('data-sby-flags') !== 'undefined' ? $self.attr('data-sby-flags').split(',') : [],
            general = typeof $self.attr('data-options') !== 'undefined' ? JSON.parse($self.attr('data-options')) : {};
          if (flags.indexOf('testAjax') > -1) {
            window.sby.triggeredTest = true;
            var submitData = {
                'action': 'sby_on_ajax_test_trigger'
              },
              onSuccess = function onSuccess(data) {
                console.log('did test');
              };
            sbyAjax(submitData, onSuccess);
          }
          var feedOptions = {
            cols: $self.attr('data-cols'),
            colsmobile: $self.attr('data-colsmobile') !== 'same' ? $self.attr('data-colsmobile') : $self.attr('data-cols'),
            num: $self.attr('data-num'),
            imgRes: $self.attr('data-res'),
            feedID: $self.attr('data-feedid'),
            postID: typeof $self.attr('data-postid') !== 'undefined' ? $self.attr('data-postid') : 'unknown',
            shortCodeAtts: $self.attr('data-shortcode-atts'),
            resizingEnabled: flags.indexOf('resizeDisable') === -1,
            imageLoadEnabled: flags.indexOf('imageLoadDisable') === -1,
            debugEnabled: flags.indexOf('debug') > -1,
            favorLocal: flags.indexOf('favorLocal') > -1,
            ajaxPostLoad: flags.indexOf('ajaxPostLoad') > -1,
            checkWPPosts: flags.indexOf('checkWPPosts') > -1,
            singleCheckPosts: flags.indexOf('singleCheckPosts') > -1,
            narrowPlayer: flags.indexOf('narrowPlayer') > -1,
            gdpr: flags.indexOf('gdpr') > -1,
            consentGiven: flags.indexOf('gdpr') === -1,
            noCDN: flags.indexOf('disablecdn') > -1,
            allowCookies: flags.indexOf('allowcookies') > -1,
            lightboxEnabled: typeof $self.attr('data-sby-supports-lightbox') !== 'undefined',
            locator: flags.indexOf('locator') > -1,
            autoMinRes: 1,
            general: general,
            subscribeBarEnabled: true
          };
          window.sby.feeds[index] = sbyGetNewFeed(this, index, feedOptions);
          if (typeof window.sbyAPIReady !== 'undefined') {
            window.sby.feeds[index].playerAPIReady = true;
          }
          window.sby.feeds[index].setResizedImages();
          window.sby.feeds[index].init();
          var evt = jQuery.Event('sbyafterfeedcreate');
          evt.feed = window.sby.feeds[index];
          jQuery(window).trigger(evt);
        }));
      },
      afterFeedsCreated: function afterFeedsCreated() {
        // enable header hover action
        $('.sb_youtube_header').each(function () {
          var $thisHeader = $(this);
          $thisHeader.find('.sby_header_link').on('mouseenter mouseleave', function (e) {
            switch (e.type) {
              case 'mouseenter':
                $thisHeader.find('.sby_header_img_hover').addClass('sby_fade_in');
                break;
              case 'mouseleave':
                $thisHeader.find('.sby_header_img_hover').removeClass('sby_fade_in');
                break;
            }
          });
        });
        if (window.sbyAPIReady) {
          var evt = jQuery.Event('sbyfeedandytready');
          jQuery(window).trigger(evt);
        }
      },
      encodeHTML: function encodeHTML(raw) {
        // make sure passed variable is defined
        if (typeof raw === 'undefined') {
          return '';
        }
        // replace greater than and less than symbols with html entity to disallow html in comments
        var encoded = raw.replace(/(>)/g, '&gt;'),
          encoded = encoded.replace(/(<)/g, '&lt;');
        encoded = encoded.replace(/(&lt;br\/&gt;)/g, '<br>');
        encoded = encoded.replace(/(&lt;br&gt;)/g, '<br>');
        return encoded;
      },
      urlDetect: function urlDetect(text) {
        var urlRegex = /https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g;
        return text.match(urlRegex);
      },
      ctaDetect: function ctaDetect(text) {
        var ctaMatches = text.match(/{Link:(.*)}/g),
          cta = false;
        if (ctaMatches !== null) {
          var urlMatches = window.sby.urlDetect(ctaMatches[0]);
          if (urlMatches !== null) {
            var url = urlMatches[0].trim(),
              sbyButtonText = ctaMatches[0].replace('{Link:', '').replace('}', '').replace(url, '').replace('  ', ' ').trim();
            cta = {
              callback: 'link',
              url: url,
              text: sbyButtonText
            };
          } else {
            console.log('CTA found but no URL');
          }
        }
        return cta;
      },
      shuffle: function shuffle(array) {
        var currentIndex = array.length,
          temporaryValue,
          randomIndex;

        // While there remain elements to shuffle...
        while (0 !== currentIndex) {
          // Pick a remaining element...
          randomIndex = Math.floor(Math.random() * currentIndex);
          currentIndex -= 1;

          // And swap it with the current element.
          temporaryValue = array[currentIndex];
          array[currentIndex] = array[randomIndex];
          array[randomIndex] = temporaryValue;
        }
        return array;
      }
    };
    function SbyFeed(el, index, settings) {
      this.el = el;
      this.index = index;
      this.settings = settings;
      this.placeholderURL = window.sby.options.placeholder;
      if (settings.narrowPlayer) {
        this.placeholderURL = window.sby.options.placeholderNarrow;
      }
      this.playerAPIReady = false;
      this.consentGiven = settings.consentGiven;
      this.players = {};
      this.minImageWidth = 0;
      this.imageResolution = 150;
      this.resizedImages = {};
      this.needsResizing = [];
      this.outOfPages = false;
      this.isInitialized = false;
      this.mostRecentlyLoadedPosts = [];
      this.embedURL = '//www.youtube-nocookie.com';
      if (settings.allowCookies) {
        this.embedURL = '//www.youtube.com';
      }
    }
    SbyFeed.prototype = {
      init: function init() {
        var feed = this;
        feed.settings.consentGiven = feed.checkConsent();
        if (feed.settings.consentGiven) {
          window.sby.maybeAddYTAPI();
        }
        if (feed.settings.noCDN && !feed.settings.consentGiven) {
          if ($(this.el).find('.sb_youtube_header').length) {
            $(this.el).find('.sb_youtube_header').addClass('sby_no_consent');
          } else if ($(this.el).prev('.sb_youtube_header').length) {
            $(this.el).prev('.sb_youtube_header').addClass('sby_no_consent');
          }
        }
        if ($(this.el).find('#sby_mod_error').length) {
          $(this.el).prepend($(this.el).find('#sby_mod_error'));
        }
        if (this.settings.ajaxPostLoad) {
          this.getNewPostSet();
        } else {
          this.afterInitialImagesLoaded();
          //Only check the width once the resize event is over
        }
        var sby_delay = function () {
          var sby_timer = 0;
          return function (sby_callback, sby_ms) {
            clearTimeout(sby_timer);
            sby_timer = setTimeout(sby_callback, sby_ms);
          };
        }();
        jQuery(window).on('resize', function () {
          sby_delay(function () {
            feed.afterResize();
          }, 1);
        });
      },
      initLayout: function initLayout() {
        this.initGalleryLayout();
      },
      initGalleryLayout: function initGalleryLayout() {
        var $self = $(this.el),
          feed = this;
        if ($self.hasClass('sby_layout_gallery') && $self.find('.sby_player_outer_wrap').length) {
          this.maybeRaiseSingleImageResolution($self.find('.sby_player_outer_wrap'), 0, true);
          $self.find('.sby_player_outer_wrap .sby_video_thumbnail').off().on('click', function (event) {
            if ((!feed.settings.lightboxEnabled || feed.settings.lightboxEnabled && feed.settings.noCDN) && (feed.settings.noCDN || !feed.settings.consentGiven)) {
              if ($(this).closest('.sby_item').length && typeof $(this).closest('.sby_item').attr('data-video-id') !== 'undefined') {
                $(this).attr('href', 'https://www.youtube.com/watch?v=' + $(this).closest('.sby_item').attr('data-video-id'));
              }
              return;
            }
            event.preventDefault();
            feed.onThumbnailClick($(this), true);
          });
          $self.find('.sby_item').first().addClass('sby_current');
          $self.on('mouseenter', function () {
            if (!feed.canCreatePlayer()) {
              return;
            }
            if (!$self.find('.sby_player_outer_wrap iframe').length) {
              $self.addClass('sby_player_added').find('.sby_player_outer_wrap').addClass('sby_player_loading');
              $self.find('.sby_player_outer_wrap .sby_video_thumbnail').find('.sby_loader').show().removeClass('sby_hidden');
              feed.createPlayer('sby_player' + feed.index);
            } else if (typeof feed.player === 'undefined' && feed.playerEagerLoaded()) {
              feed.createPlayer('sby_player' + feed.index);
            }
          });
          if (window.sbySemiEagerLoading) {
            feed.createPlayer('sby_player' + feed.index);
          }
          if (feed.settings.noCDN) {
            $self.find('.sby_player_outer_wrap').append('<div class="sby_play_btn">\n' + '                        <span class="sby_play_btn_bg"></span>\n' + '                    <svg aria-hidden="true" focusable="false" data-prefix="fab" data-icon="youtube" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="svg-inline--fa fa-youtube fa-w-18"><path fill="currentColor" d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z" class=""></path></svg>                    </div>');
          }
        }
      },
      createPlayer: function createPlayer(playerID, videoID, autoplay, args) {
        var $self = $(this.el),
          feed = this;
        videoID = typeof videoID !== 'undefined' ? videoID : this.getVideoID($self.find('.sby_item').first());
        autoplay = typeof autoplay !== 'undefined' ? autoplay : 0;

        // do not create player in customizer preview
        if (sbyOptions.isCustomizer !== undefined && sbyOptions.isCustomizer) {
          return;
        }
        if (typeof args === 'undefined') {
          args = {
            host: window.location.protocol + feed.embedURL,
            videoId: videoID,
            playerVars: {
              modestbranding: 1,
              rel: 0,
              autoplay: autoplay
            }
          };
        }
        if (typeof args.events === 'undefined') {
          args.events = {
            'onReady': function onReady() {
              $self.find('.sby_player_outer_wrap').removeClass('sby_player_loading').find('.sby_video_thumbnail').css('z-index', -1).find('.sby_loader').hide().addClass('sby_hidden');
              if ($('#' + playerID).length && $('#' + playerID).closest('.sby_video_thumbnail_wrap').find('.sby_video_thumbnail').length) {
                $('#' + playerID).closest('.sby_video_thumbnail_wrap').find('.sby_video_thumbnail').fadeTo(0, 'slow', function () {
                  $(this).css('z-index', -1);
                  $(this).find('.sby_loader').hide().addClass('sby_hidden');
                  $(this).closest('.sby_item').removeClass('sby_player_loading');
                });
              }
              var evt = jQuery.Event('sbyafterplayerready');
              evt.feed = feed;
              evt.player = this;
              jQuery(window).trigger(evt);
            },
            'onStateChange': function onStateChange(data) {
              $self.find('.sby_player_outer_wrap').removeClass('sby_player_loading').find('.sby_video_thumbnail').css('z-index', -1).find('.sby_loader').hide().addClass('sby_hidden');
              feed.afterStateChange(playerID, videoID, data, $('#' + playerID).closest('.sby_video_thumbnail_wrap'));
              if (data.data !== 1) return;
              var feedID;
              if (feed.el) {
                var shortcodeAttr = feed.el.getAttribute('data-shortcode-atts');
                if (shortcodeAttr) {
                  var _JSON$parse;
                  feedID = (_JSON$parse = JSON.parse(shortcodeAttr)) === null || _JSON$parse === void 0 ? void 0 : _JSON$parse.feed;
                }
              }
              document.dispatchEvent(new CustomEvent('sby-video-interaction', {
                detail: {
                  videoID: videoID,
                  feedID: feedID
                }
              }));
              if (typeof feed.players !== 'undefined') {
                $self.find('.sby_item').each(function () {
                  var itemVidID = feed.getVideoID($(this));
                  if ($(this).find('iframe').length && itemVidID !== videoID) {
                    if (typeof feed.players[itemVidID] !== 'undefined' && typeof feed.players[itemVidID].pauseVideo === 'function') {
                      feed.players[itemVidID].pauseVideo();
                    }
                  }
                });
              }
            }
          };
        }
        if (window.sbyEagerLoading) {
          var newPlayer = YT.get(playerID);
        } else {
          var newPlayer = new window.YT.Player(playerID, args);
        }
        this.maybeAddCTA(playerID);
        if ($self.hasClass('sby_layout_list') && typeof this.players[videoID] === 'undefined') {
          this.players[videoID] = newPlayer;
        } else if (typeof this.player === 'undefined') {
          this.player = newPlayer;
        }
        var evt = jQuery.Event('sbyafterplayercreated');
        evt.feed = this;
        jQuery(window).trigger(evt);
        $self.find('.sby_player_outer_wrap .sby_play_btn').remove();
        return newPlayer;
      },
      afterStateChange: function afterStateChange(playerID, videoID, data, $player) {},
      afterInitialImagesLoaded: function afterInitialImagesLoaded() {
        this.initLayout();
        this.loadMoreButtonInit();
        this.hideExtraItemsForWidth();
        this.beforeNewImagesRevealed();
        this.revealNewImages();
        this.afterNewImagesRevealed();
        this.afterFeedSet();
        this.sizePlayer();
        this.sizeItems();
        if (this.settings.consentGiven) {
          this.applyFullFeatures();
        } else {
          this.removeFeatures();
        }
      },
      afterResize: function afterResize() {
        this.setImageHeight();
        this.setImageResolution();
        this.maybeRaiseImageResolution();
        this.setImageSizeClass();
      },
      afterLoadMoreClicked: function afterLoadMoreClicked($button) {
        $button.find('.sby_loader').removeClass('sby_hidden');
        $button.find('.sby_btn_text').addClass('sby_hidden');
        $button.closest('.sb_youtube').find('.sby_num_diff_hide').addClass('sby_transition').removeClass('sby_num_diff_hide');
      },
      afterNewImagesLoaded: function afterNewImagesLoaded() {
        var $self = $(this.el),
          feed = this;
        this.beforeNewImagesRevealed();
        this.revealNewImages();
        this.afterNewImagesRevealed();
        this.sizePlayer();
        this.sizeItems();
        setTimeout(function () {
          //Hide the loader in the load more button
          $self.find('.sby_loader').addClass('sby_hidden');
          $self.find('.sby_btn_text').removeClass('sby_hidden');
          feed.maybeRaiseImageResolution();
        }, 1);
        if (this.settings.consentGiven) {
          this.applyFullFeatures();
        } else {
          this.removeFeatures();
        }
      },
      beforeNewImagesRevealed: function beforeNewImagesRevealed() {
        this.setImageHeight();
        this.maybeRaiseImageResolution(true);
        this.setImageSizeClass();
      },
      afterFeedSet: function afterFeedSet() {},
      sizePlayer: function sizePlayer() {
        var $self = $(this.el),
          feed = this;
        if ($self.hasClass('sby_layout_gallery')) {
          $playerThumbnail = $self.find('.sby_player_item').find('.sby_player_video_thumbnail');
          var playerWidth = $playerThumbnail.innerWidth(),
            newPlayerHeight = Math.floor(playerWidth * 9 / 16);
          if (feed.settings.narrowPlayer) {
            newPlayerHeight = Math.floor(playerWidth * 3 / 4);
          }
          $playerThumbnail.css('height', newPlayerHeight + 'px').css('overflow', 'hidden');
        } else if ($self.hasClass('sby_layout_list')) {
          $self.find('.sby_item').each(function () {
            $playerThumbnail = $(this).find('.sby_item_video_thumbnail');
            var playerWidth = $playerThumbnail.innerWidth(),
              newPlayerHeight = Math.floor(playerWidth * 9 / 16);
            if (feed.settings.narrowPlayer) {
              newPlayerHeight = Math.floor(playerWidth * 3 / 4);
            }
            $playerThumbnail.css('height', newPlayerHeight + 'px').css('overflow', 'hidden');
          });
        }
      },
      sizeItems: function sizeItems() {
        var $self = $(this.el),
          feed = this;
        if (!$self.hasClass('sby_layout_list')) {
          $self.find('.sby_item').find('.sby_item_video_thumbnail').each(function () {
            if ($(this).hasClass('sby_imgLiquid_ready')) {
              var thumbWidth = $(this).innerWidth(),
                newThumbHeight = Math.floor(thumbWidth * 9 / 16);
              $(this).css('height', newThumbHeight + 'px').css('overflow', 'hidden');
            }
          });
        }
      },
      revealNewImages: function revealNewImages() {
        var $self = $(this.el),
          feed = this;
        this.applyImageLiquid();

        // Call Custom JS if it exists
        if (typeof sbyCustomJS == 'function') setTimeout(function () {
          sbyCustomJS();
        }, 100);
        $self.find('.sby-screenreader').find('img').remove();
        $self.find('.sby_item.sby_new').each(function (index) {
          var $self = jQuery(this);

          //Photo links
          //If lightbox is disabled
          videoID = $self.attr('data-video-id');
          if (window.sbyEagerLoading && feed.canCreatePlayer() && $('#sby_player_' + videoID).length) {
            player = new YT.Player('sby_player_' + videoID, {
              height: '100',
              width: '100',
              videoId: videoID,
              playerVars: {
                modestbranding: 1,
                rel: 0,
                autoplay: 0
              },
              events: {
                'onStateChange': function onStateChange(data) {
                  var videoID = data.target.getVideoData()['video_id'];
                  if (data.data !== 1) return;
                  document.dispatchEvent(videoInteractionEvent, {
                    videoID: videoID
                  });
                  $self.find('.sby_item').each(function () {
                    var itemVidID = jQuery(this).attr('data-video-id');
                    if (jQuery(this).find('iframe').length && jQuery(data.target.a).attr('id') !== jQuery(this).find('iframe').attr('id')) {
                      YT.get('sby_player_' + itemVidID).pauseVideo();
                    }
                  });
                }
              }
            });
          }
          $self.find('.sby_video_thumbnail').on('mouseenter', function () {
            feed.onThumbnailEnter($(this), false);
          });
          $self.find('.sby_player_wrap').on('mouseleave', function () {
            feed.onThumbnailLeave($(this), false);
          });
          //init click
          $self.find('.sby_video_thumbnail').on('click', function (event) {
            if ((!feed.settings.lightboxEnabled || feed.settings.lightboxEnabled && feed.settings.noCDN) && (feed.settings.noCDN || !feed.settings.consentGiven)) {
              if ($(this).closest('.sby_item').length && typeof $(this).closest('.sby_item').attr('data-video-id') !== 'undefined') {
                $(this).attr('href', 'https://www.youtube.com/watch?v=' + $(this).closest('.sby_item').attr('data-video-id'));
              }
              return;
            }
            event.preventDefault();
            feed.onThumbnailClick($(this), false);
          });

          // lightbox
          if (feed.settings.lightboxEnabled) {
            $self.find('.sby_video_thumbnail').attr('data-sby-lightbox', feed.index);
            if (typeof sbyOptions !== 'undefined' && typeof sbyOptions.lightboxPlaceholder !== 'undefined') {
              if (feed.settings.narrowPlayer) {
                $self.find('.sby_video_thumbnail').attr('href', sbyOptions.lightboxPlaceholderNarrow);
              } else {
                $self.find('.sby_video_thumbnail').attr('href', sbyOptions.lightboxPlaceholder);
              }
            }
          }
          feed.afterItemRevealed($self);

          // no info
          if ($self.find('.sby_info_item').text().trim() === '') {
            $self.find('.sby_info_item').addClass('sby_no_space');
          }
        }); //End .sby_item each

        $self.find('.sby_player_item').each(function (index) {
          var $self = jQuery(this);
          feed.afterItemRevealed($self);
        }); //End .sby_item each

        //Remove the new class after 500ms, once the sorting is done
        setTimeout(function () {
          $self.find('.sby_item.sby_new').removeClass('sby_new');
          //Loop through items and remove class to reveal them
          var time = 1,
            num = $self.find('.sby_transition').length;
          $self.find('.sby_transition').each(function (index) {
            var $sby_item_transition_el = jQuery(this);
            setTimeout(function () {
              $sby_item_transition_el.removeClass('sby_transition');
            }, time);
            //time += 10;
          });
        }, 1);
      },
      afterItemRevealed: function afterItemRevealed() {},
      afterNewImagesRevealed: function afterNewImagesRevealed() {
        this.listenForVisibilityChange();
        this.sendNeedsResizingToServer();
        this.sendCheckWPPostsToServer();
        if (!this.settings.imageLoadEnabled) {
          $('.sby_no_resraise').removeClass('sby_no_resraise');
        }
        var evt = $.Event('sbyafterimagesloaded');
        evt.el = $(this.el);
        $(window).trigger(evt);
      },
      setResizedImages: function setResizedImages() {
        if ($(this.el).find('.sby_resized_image_data').length && typeof $(this.el).find('.sby_resized_image_data').attr('data-resized') !== 'undefined' && $(this.el).find('.sby_resized_image_data').attr('data-resized').indexOf('{"') === 0) {
          this.resizedImages = JSON.parse($(this.el).find('.sby_resized_image_data').attr('data-resized'));
          $(this.el).find('.sby_resized_image_data').remove();
        }
      },
      sendNeedsResizingToServer: function sendNeedsResizingToServer() {
        var feed = this;
        if (feed.needsResizing.length > 0 && feed.settings.resizingEnabled) {
          var itemOffset = $(this.el).find('.sby_item').length;
          var submitData = {
            action: 'sby_resized_images_submit',
            needs_resizing: feed.needsResizing,
            offset: itemOffset,
            feed_id: feed.settings.feedID,
            location: feed.locationGuess(),
            post_id: feed.settings.postID,
            atts: feed.settings.shortCodeAtts
          };
          var onSuccess = function onSuccess(data) {
            if (data.trim().indexOf('{') === 0) {
              var response = JSON.parse(data);
              if (feed.settings.debugEnabled) {
                console.log(response);
              }
            }
          };
          sbyAjax(submitData, onSuccess);
        }
      },
      sendCheckWPPostsToServer: function sendCheckWPPostsToServer() {
        var feed = this;
        if (feed.settings.checkWPPosts || feed.settings.singleCheckPosts) {
          var feedID = typeof feed.settings.feedID !== 'undefined' ? feed.settings.feedID : 'sby_single',
            posts = feed.mostRecentlyLoadedPosts;
          feed.mostRecentlyLoadedPosts = [];
          var submitData = {
            action: 'sby_check_wp_submit',
            feed_id: feedID,
            atts: feed.settings.shortCodeAtts,
            location: feed.locationGuess(),
            post_id: feed.settings.postID,
            offset: !$(this.el).hasClass('sby_layout_carousel') ? $(this.el).find('.sby_item').length : Math.floor($(this.el).find('.sby_item').length / 2 - 1),
            posts: posts
          };
          var onSuccess = function onSuccess(data) {
            if (data.trim().indexOf('{') === 0) {
              var response = JSON.parse(data);
              if (feed.settings.debugEnabled) {
                console.log(response);
              }
              feed.afterSendCheckWPPostsToServer(response);
            }
          };
          sbyAjax(submitData, onSuccess);
        }
      },
      afterSendCheckWPPostsToServer: function afterSendCheckWPPostsToServer(response) {},
      loadMoreButtonInit: function loadMoreButtonInit() {
        var $self = $(this.el),
          feed = this;
        $self.find('.sby_footer .sby_load_btn').off().on('click', function () {
          feed.afterLoadMoreClicked(jQuery(this));
          feed.getNewPostSet();
        }); //End click event
      },
      getNewPostSet: function getNewPostSet() {
        var $self = $(this.el),
          feed = this;
        var itemOffset = $self.find('.sby_item').length,
          submitData = {
            action: 'sby_load_more_clicked',
            offset: itemOffset,
            feed_id: feed.settings.feedID,
            atts: feed.settings.shortCodeAtts,
            location: feed.locationGuess(),
            post_id: feed.settings.postID,
            current_resolution: feed.imageResolution
          };
        var onSuccess = function onSuccess(data) {
          if (data.trim().indexOf('{') === 0) {
            var response = JSON.parse(data),
              checkWPPosts = typeof response.feedStatus.checkWPPosts !== 'undefined' ? response.feedStatus.checkWPPosts : false;
            ;
            if (feed.settings.debugEnabled) {
              console.log(response);
            }
            if (checkWPPosts) {
              feed.settings.checkWPPosts = true;
            } else {
              feed.settings.checkWPPosts = false;
            }
            feed.appendNewPosts(response.html);
            feed.addResizedImages(response.resizedImages);
            if (feed.settings.ajaxPostLoad) {
              feed.settings.ajaxPostLoad = false;
              feed.afterInitialImagesLoaded();
            } else {
              feed.afterNewImagesLoaded();
            }
            if (!response.feedStatus.shouldPaginate) {
              feed.outOfPages = true;
              $self.find('.sby_load_btn').hide();
            } else {
              feed.outOfPages = false;
            }
            $('.sby_no_js').removeClass('sby_no_js');
            openComments();
          }
        };
        sbyAjax(submitData, onSuccess);
      },
      appendNewPosts: function appendNewPosts(newPostsHtml) {
        var $self = $(this.el),
          feed = this;
        if ($self.find('.sby_items_wrap .sby_item').length) {
          $self.find('.sby_items_wrap .sby_item').last().after(newPostsHtml);
        } else {
          $self.find('.sby_items_wrap').append(newPostsHtml);
        }
      },
      addResizedImages: function addResizedImages(resizedImagesToAdd) {
        for (var imageID in resizedImagesToAdd) {
          this.resizedImages[imageID] = resizedImagesToAdd[imageID];
        }
      },
      setImageHeight: function setImageHeight() {},
      maybeRaiseSingleImageResolution: function maybeRaiseSingleImageResolution($item, index, forceChange) {
        var feed = this,
          imgSrcSet = feed.getImageUrls($item),
          currentUrl = $item.find('.sby_video_thumbnail > img').attr('src'),
          currentRes = 150,
          aspectRatio = 1,
          // all thumbnails are oriented the same so the best calculation uses 1
          forceChange = typeof forceChange !== 'undefined' ? forceChange : false;
        if ($item.hasClass('sby_no_resraise') || !feed.settings.consentGiven && feed.settings.noCDN) {
          return;
        }
        $.each(imgSrcSet, function (index, value) {
          if (value === currentUrl) {
            currentRes = parseInt(index);
            // If the image has already been changed to an existing real source, don't force the change
            forceChange = false;
          }
        });
        //Image res
        var newRes = 640;
        switch (feed.settings.imgRes) {
          case 'thumb':
            newRes = 120;
            break;
          case 'medium':
            newRes = 320;
            break;
          case 'large':
            newRes = 480;
            break;
          case 'full':
            newRes = 640;
            break;
          default:
            var minImageWidth = Math.max(feed.settings.autoMinRes, $item.find('.sby_video_thumbnail').innerWidth()),
              thisImageReplace = feed.getBestResolutionForAuto(minImageWidth, aspectRatio, $(this.el).find('sby_item').first());
            switch (thisImageReplace) {
              case 480:
                newRes = 480;
                break;
              case 320:
                newRes = 320;
                break;
              case 120:
                newRes = 120;
                break;
            }
            break;
        }
        if (newRes > currentRes || currentUrl === feed.placeholderURL || forceChange) {
          if (feed.settings.debugEnabled) {
            var reason = currentUrl === feed.placeholderURL ? 'was placeholder' : 'too small';
            console.log('rais res for ' + currentUrl, reason);
          }
          var newUrl = imgSrcSet[newRes];
          $item.find('.sby_video_thumbnail > img').attr('src', newUrl);
          if ($item.find('.sby_video_thumbnail').hasClass('sby_imgLiquid_ready')) {
            $item.find('.sby_video_thumbnail').css('background-image', 'url("' + newUrl + '")');
          }
        }
        $item.find('img').on('error', function () {
          if (!$(this).hasClass('sby_img_error')) {
            $(this).addClass('sby_img_error');
            var sourceFromAPI = $(this).attr('src').indexOf('i.ytimg.com') > -1;
            if (!sourceFromAPI) {
              if (typeof $(this).closest('.sby_video_thumbnail').attr('data-full-res') !== 'undefined') {
                $(this).attr('src', $(this).closest('.sby_video_thumbnail').attr('data-full-res'));
                $(this).closest('.sby_video_thumbnail').css('background-image', 'url(' + $(this).closest('.sby_video_thumbnail').attr('data-full-res') + ')');
              } else if ($(this).closest('.sby_video_thumbnail').attr('href') !== 'undefined') {
                $(this).attr('src', $(this).closest('.sby_video_thumbnail').attr('href') + 'media?size=l');
                $(this).closest('.sby_video_thumbnail').css('background-image', 'url(' + $(this).closest('.sby_video_thumbnail').attr('href') + 'media?size=l)');
              }
            } else {
              feed.settings.favorLocal = true;
              var srcSet = feed.getImageUrls($(this).closest('.sby_item'));
              if (typeof srcSet[640] !== 'undefined') {
                $(this).attr('src', srcSet[640]);
                $(this).closest('.sby_video_thumbnail').css('background-image', 'url(' + srcSet[640] + ')');
              }
            }
            setTimeout(function () {
              feed.afterResize();
            }, 1);
          } else {
            console.log('unfixed error ' + $(this).attr('src'));
          }
        });
      },
      maybeRaiseImageResolution: function maybeRaiseImageResolution(justNew) {
        var feed = this,
          itemsSelector = typeof justNew !== 'undefined' && justNew === true ? '.sby_item.sby_new' : '.sby_item',
          forceChange = !feed.isInitialized ? true : false;
        $(feed.el).find(itemsSelector).each(function (index) {
          if (!$(this).hasClass('sby_num_diff_hide') && $(this).find('.sby_video_thumbnail').length && typeof $(this).find('.sby_video_thumbnail').attr('data-img-src-set') !== 'undefined') {
            feed.maybeRaiseSingleImageResolution($(this), index, forceChange);
          }
        }); //End .sby_item each
        feed.isInitialized = true;
      },
      getBestResolutionForAuto: function getBestResolutionForAuto(colWidth, aspectRatio, $item) {
        if (isNaN(aspectRatio) || aspectRatio < 1) {
          aspectRatio = 1;
        }
        var bestWidth = colWidth * aspectRatio,
          bestWidthRounded = Math.ceil(bestWidth / 10) * 10,
          customSizes = [120, 320, 480, 640];
        if ($item.hasClass('sby_highlighted')) {
          bestWidthRounded = bestWidthRounded * 2;
        }
        if (customSizes.indexOf(parseInt(bestWidthRounded)) === -1) {
          var done = false;
          $.each(customSizes, function (index, item) {
            if (item > parseInt(bestWidthRounded) && !done) {
              bestWidthRounded = item;
              done = true;
            }
          });
        }
        return bestWidthRounded;
      },
      hideExtraItemsForWidth: function hideExtraItemsForWidth() {
        if (this.layout === 'carousel') {
          return;
        }
        var $self = $(this.el),
          num = typeof $self.attr('data-num') !== 'undefined' && $self.attr('data-num') !== '' ? parseInt($self.attr('data-num')) : 1,
          nummobile = typeof $self.attr('data-nummobile') !== 'undefined' && $self.attr('data-nummobile') !== '' ? parseInt($self.attr('data-nummobile')) : num;
        if (!$self.hasClass('.sby_layout_carousel')) {
          if ($(window).width() < 480) {
            if (nummobile < $self.find('.sby_item').length) {
              $self.find('.sby_item').slice(nummobile - $self.find('.sby_item').length).addClass('sby_num_diff_hide');
            }
          } else {
            if (num < $self.find('.sby_item').length) {
              $self.find('.sby_item').slice(num - $self.find('.sby_item').length).addClass('sby_num_diff_hide');
            }
          }
        }
      },
      setImageSizeClass: function setImageSizeClass() {
        var $self = $(this.el);
        $self.removeClass('sby_small sby_medium');
        var feedWidth = $self.innerWidth(),
          photoPadding = parseInt($self.find('.sby_items_wrap').outerWidth() - $self.find('.sby_items_wrap').width()) / 2,
          cols = this.getColumnCount(),
          feedWidthSansPadding = feedWidth - photoPadding * (cols + 2),
          colWidth = feedWidthSansPadding / cols;
        if (colWidth > 140 && colWidth < 240) {
          $self.addClass('sby_medium');
        } else if (colWidth <= 140) {
          $self.addClass('sby_small');
        }
      },
      setMinImageWidth: function setMinImageWidth() {
        if ($(this.el).find('.sby_item .sby_video_thumbnail').first().length) {
          this.minImageWidth = $(this.el).find('.sby_item .sby_video_thumbnail').first().innerWidth();
        } else {
          this.minImageWidth = 150;
        }
      },
      setImageResolution: function setImageResolution() {
        if (this.settings.imgRes === 'auto') {
          this.imageResolution = 'auto';
        } else {
          switch (this.settings.imgRes) {
            case 'thumb':
              this.imageResolution = 150;
              break;
            case 'medium':
              this.imageResolution = 320;
              break;
            default:
              this.imageResolution = 640;
          }
        }
      },
      getImageUrls: function getImageUrls($item) {
        var srcSet = JSON.parse($item.find('.sby_video_thumbnail').attr('data-img-src-set').replace(/\\\//g, '/')),
          id = $item.attr('id').replace('sby_', '').replace('player_', '');
        if (typeof this.resizedImages[id] !== 'undefined' && this.resizedImages[id] !== 'video' && this.resizedImages[id] !== 'pending' && this.resizedImages[id].id !== 'error' && this.resizedImages[id].id !== 'video' && this.resizedImages[id].id !== 'pending') {
          if (typeof this.resizedImages[id]['sizes'] !== 'undefined') {
            var foundSizes = [];
            if (typeof this.resizedImages[id]['sizes']['full'] !== 'undefined') {
              foundSizes.push(640);
              srcSet[640] = sbyOptions.resized_url + this.resizedImages[id].id + 'full.jpg';
              $item.find('.sby_link_area').attr('href', sbyOptions.resized_url + this.resizedImages[id].id + 'full.jpg');
              $item.find('.sby_video_thumbnail').attr('data-full-res', sbyOptions.resized_url + this.resizedImages[id].id + 'full.jpg');
            }
            if (typeof this.resizedImages[id]['sizes']['low'] !== 'undefined') {
              foundSizes.push(320);
              srcSet[320] = sbyOptions.resized_url + this.resizedImages[id].id + 'low.jpg';
              if (this.settings.favorLocal && typeof this.resizedImages[id]['sizes']['full'] === 'undefined') {
                $item.find('.sby_link_area').attr('href', sbyOptions.resized_url + this.resizedImages[id].id + 'low.jpg');
                $item.find('.sby_video_thumbnail').attr('data-full-res', sbyOptions.resized_url + this.resizedImages[id].id + 'low.jpg');
              }
            }
            if (typeof this.resizedImages[id]['sizes']['thumb'] !== 'undefined') {
              foundSizes.push(150);
              srcSet[150] = sbyOptions.resized_url + this.resizedImages[id].id + 'thumb.jpg';
            }
            if (this.settings.favorLocal) {
              if (foundSizes.indexOf(640) === -1) {
                if (foundSizes.indexOf(320) > -1) {
                  srcSet[640] = sbyOptions.resized_url + this.resizedImages[id].id + 'low.jpg';
                }
              }
              if (foundSizes.indexOf(320) === -1) {
                if (foundSizes.indexOf(640) > -1) {
                  srcSet[320] = sbyOptions.resized_url + this.resizedImages[id].id + 'full.jpg';
                } else if (foundSizes.indexOf(150) > -1) {
                  srcSet[320] = sbyOptions.resized_url + this.resizedImages[id].id + 'thumb.jpg';
                }
              }
              if (foundSizes.indexOf(150) === -1) {
                if (foundSizes.indexOf(320) > -1) {
                  srcSet[150] = sbyOptions.resized_url + this.resizedImages[id].id + 'low.jpg';
                } else if (foundSizes.indexOf(640) > -1) {
                  srcSet[150] = sbyOptions.resized_url + this.resizedImages[id].id + 'full.jpg';
                }
              }
            }
          }
        } else if (typeof this.resizedImages[id] === 'undefined' || typeof this.resizedImages[id]['id'] !== 'undefined' && this.resizedImages[id]['id'] !== 'pending' && this.resizedImages[id]['id'] !== 'error') {
          this.addToNeedsResizing(id);
        }
        return srcSet;
      },
      getVideoID: function getVideoID($el) {
        if ($el.hasClass('sby_item') || $el.hasClass('sby_player_item')) {
          if (typeof $el.find('.sby_video_thumbnail').attr('data-video-id') !== 'undefined') {
            return $el.find('.sby_video_thumbnail').attr('data-video-id');
          }
        } else if ($el.closest('sby_item').length || $el.closest('sby_player_item').length) {
          var $targeEl = $el.closest('sby_item').length ? $el.closest('sby_item') : $el.closest('sby_player_item');
          if (typeof $targeEl.find('.sby_video_thumbnail').attr('data-video-id') !== 'undefined') {
            return $targeEl.find('.sby_video_thumbnail').attr('data-video-id');
          }
        } else if ($el.hasClass('sb_youtube')) {
          return $el.find('.sby_item').first().find('.sby_video_thumbnail').attr('data-video-id');
        } else if ($(this.el).find('.sby_video_thumbnail').first().length && typeof $(this.el).find('.sby_video_thumbnail').first().attr('data-video-id') !== 'undefined') {
          return $(this.el).find('.sby_video_thumbnail').first().attr('data-video-id');
        }
        return '';
      },
      getAvatarUrl: function getAvatarUrl(username, favorType) {
        if (username === '') {
          return '';
        }
        var availableAvatars = this.settings.general.avatars,
          favorType = typeof favorType !== 'undefined' ? favorType : 'local';
        if (favorType === 'local') {
          if (typeof availableAvatars['LCL' + username] !== 'undefined' && parseInt(availableAvatars['LCL' + username]) === 1) {
            return sbyOptions.resized_url + username + '.jpg';
          } else if (typeof availableAvatars[username] !== 'undefined') {
            return availableAvatars[username];
          } else {
            return '';
          }
        } else {
          if (typeof availableAvatars[username] !== 'undefined') {
            return availableAvatars[username];
          } else if (typeof availableAvatars['LCL' + username] !== 'undefined' && parseInt(availableAvatars['LCL' + username]) === 1) {
            return sbyOptions.resized_url + username + '.jpg';
          } else {
            return '';
          }
        }
      },
      addToNeedsResizing: function addToNeedsResizing(id) {
        if (this.needsResizing.indexOf(id) === -1) {
          this.needsResizing.push(id);
        }
      },
      applyImageLiquid: function applyImageLiquid() {
        var $self = $(this.el),
          feed = this;
        sbyAddImgLiquid();
        if (typeof $self.find(".sby_player_item").sby_imgLiquid == 'function') {
          if ($self.find('.sby_player_item').length) {
            $self.find(".sby_player_item .sby_player_video_thumbnail").sby_imgLiquid({
              fill: true
            });
          }
          $self.find(".sby_item .sby_item_video_thumbnail").sby_imgLiquid({
            fill: true
          });
        }
      },
      listenForVisibilityChange: function listenForVisibilityChange() {
        var feed = this;
        sbyAddVisibilityListener();
        if (typeof $(this.el).filter(':hidden').sbyVisibilityChanged == 'function') {
          //If the feed is initially hidden (in a tab for example) then check for when it becomes visible and set then set the height
          $(this.el).filter(':hidden').sbyVisibilityChanged({
            callback: function callback(element, visible) {
              feed.afterResize();
            },
            runOnLoad: false
          });
        }
      },
      getColumnCount: function getColumnCount() {
        var $self = $(this.el),
          cols = this.settings.cols,
          colsmobile = this.settings.colsmobile,
          returnCols = cols;
        sbyWindowWidth = window.innerWidth;
        if ($self.hasClass('sby_mob_col_auto')) {
          if (sbyWindowWidth < 640 && parseInt(cols) > 2 && parseInt(cols) < 7) returnCols = 2;
          if (sbyWindowWidth < 640 && parseInt(cols) > 6 && parseInt(cols) < 11) returnCols = 4;
          if (sbyWindowWidth <= 480 && parseInt(cols) > 2) returnCols = 1;
        } else if (sbyWindowWidth <= 480) {
          returnCols = colsmobile;
        }
        return parseInt(returnCols);
      },
      onThumbnailClick: function onThumbnailClick($clicked, isPlayer, videoID) {
        if (!this.canCreatePlayer()) {
          return;
        }
        var $self = $(this.el);
        if ($self.hasClass('sby_layout_gallery')) {
          $self.find('.sby_current').removeClass('sby_current');
          $clicked.closest('.sby_item').addClass('sby_current');
          $clicked.closest('.sby_item').addClass('sby_current');
          $self.addClass('sby_player_added').find('.sby_player_outer_wrap').addClass('sby_player_loading');
          $self.find('.sby_player_outer_wrap .sby_video_thumbnail').find('.sby_loader').show().removeClass('sby_hidden');
          if (!$self.find('.sby_player_outer_wrap iframe').length) {
            if (isPlayer) {
              this.createPlayer('sby_player' + this.index);
            } else {
              var videoID = typeof videoID === 'undefined' ? this.getVideoID($clicked.closest('.sby_item')) : videoID;
              this.createPlayer('sby_player' + this.index, videoID);
            }
          } else {
            if (isPlayer) {
              var videoID = typeof videoID === 'undefined' ? this.getVideoID($self.find('.sby_item').first()) : videoID;
              this.playVideoInPlayer(videoID);
            } else {
              var videoID = typeof videoID === 'undefined' ? this.getVideoID($clicked.closest('.sby_item')) : videoID;
              this.changePlayerInfo($clicked.closest('.sby_item'));
              this.playVideoInPlayer(videoID);
              this.afterVideoChanged();
            }
          }
          this.updateGalleryPlayerSubscribeBtn($clicked);
        } else if ($(this.el).hasClass('sby_layout_grid') || $(this.el).hasClass('sby_layout_carousel')) {
          var $sbyItem = $clicked.closest('.sby_item'),
            videoID = typeof videoID === 'undefined' ? this.getVideoID($sbyItem) : videoID;
          this.playVideoInPlayer(videoID);
          this.afterVideoChanged();
        } else if ($(this.el).hasClass('sby_layout_list')) {
          var $sbyItem = $clicked.closest('.sby_item'),
            videoID = typeof videoID === 'undefined' ? this.getVideoID($sbyItem) : videoID;
          if ($sbyItem.length && !$sbyItem.find('iframe').length) {
            $sbyItem.find('.sby_loader').show().removeClass('sby_hidden');
            $sbyItem.addClass('sby_player_loading sby_player_loaded');
            this.createPlayer('sby_player_' + videoID, videoID);
          } else {
            this.playVideoInPlayer(videoID, $sbyItem.attr('data-video-id'));
            this.afterVideoChanged();
          }
        }
      },
      onThumbnailEnter: function onThumbnailEnter($hovered) {
        if (!this.canCreatePlayer()) {
          return;
        }
        var $self = $(this.el);
        if ($self.hasClass('sby_layout_list')) {
          var $sbyItem = $hovered.closest('.sby_item'),
            videoID = this.getVideoID($sbyItem);
          if (!$sbyItem.find('iframe').length) {
            $sbyItem.find('.sby_loader').show().removeClass('sby_hidden');
            $sbyItem.addClass('sby_player_loading sby_player_loaded');
            this.createPlayer('sby_player_' + videoID, videoID, 0);
          }
        }
      },
      onThumbnailLeave: function onThumbnailLeave($hovered) {},
      changePlayerInfo: function changePlayerInfo($newItem) {},
      playerEagerLoaded: function playerEagerLoaded() {
        if (typeof this.player !== 'undefined' || $(this.el).hasClass('sby_player_loaded')) {
          return true;
        }
      },
      canCreatePlayer: function canCreatePlayer() {
        if ($(this.el).find('#sby_blank').length) {
          return false;
        }
        var concentGiven = this.settings.consentGiven;

        // Fix for elementor builder for list view. Where video would not load on hocer.
        var elementorCheck = window.sby.feeds[this.index].playerAPIReady && concentGiven;
        return this.playerEagerLoaded() || this.playerAPIReady && concentGiven || window.sbyAPIReady && concentGiven || elementorCheck;
      },
      playVideoInPlayer: function playVideoInPlayer(videoID, playerID) {
        if (typeof this.player !== 'undefined' && typeof this.player.loadVideoById !== 'undefined') {
          this.player.loadVideoById(videoID);
        } else if (typeof window.sbyLightboxPlayer !== 'undefined' && typeof window.sbyLightboxPlayer.loadVideoById !== 'undefined') {
          window.sbyLightboxPlayer.loadVideoById(videoID);
        } else if (typeof playerID !== 'undefined' && typeof this.players !== 'undefined' && typeof this.players[playerID] !== 'undefined' && typeof this.players[playerID].loadVideoById !== 'undefined') {
          this.players[playerID].loadVideoById(videoID);
        }
      },
      afterVideoChanged: function afterVideoChanged() {
        if ($(this.el).hasClass('sby_layout_gallery')) {
          $(this.el).find('.sby_player_outer_wrap').removeClass('sby_player_loading');
          $(this.el).find('.sby_player_outer_wrap .sby_video_thumbnail').find('.sby_loader').hide().addClass('sby_hidden');
          $('html, body').animate({
            scrollTop: $(this.el).find('.sby_player_outer_wrap').offset().top
          }, 300);
        }
      },
      updateGalleryPlayerSubscribeBtn: function updateGalleryPlayerSubscribeBtn($clicked) {
        var itemURL = $clicked.attr('href');
        var regex = /channel\/(.*)$/;
        var match = itemURL.match(regex);
        if (!match) {
          return;
        }
        var channelId = match[1];
        var subscribeBtnURL = 'http://www.youtube.com/channel/' + channelId + '?sub_confirmation=1&feature=subscribe-embed-click';
        $('.sby-channel-subscribe-btn a').attr('href', subscribeBtnURL);
      },
      checkConsent: function checkConsent() {
        if (this.settings.consentGiven || !this.settings.gdpr) {
          this.settings.noCDN = false;
          return true;
        }
        if (typeof window.WPConsent !== 'undefined') {
          this.settings.consentGiven = window.WPConsent.hasConsent('marketing');
        } else if (typeof CLI_Cookie !== "undefined") {
          // GDPR Cookie Consent by WebToffee
          if (CLI_Cookie.read(CLI_ACCEPT_COOKIE_NAME) !== null) {
            // WebToffee no longer uses this cookie but being left here to maintain backwards compatibility
            if (CLI_Cookie.read('cookielawinfo-checkbox-non-necessary') !== 'null') {
              this.settings.consentGiven = CLI_Cookie.read('cookielawinfo-checkbox-non-necessary') === 'yes';
            }
            if (CLI_Cookie.read('cookielawinfo-checkbox-necessary') !== 'null') {
              this.settings.consentGiven = CLI_Cookie.read('cookielawinfo-checkbox-necessary') === 'yes';
            }
          }
        } else if (typeof window.cnArgs !== "undefined") {
          // Cookie Notice by dFactory
          var value = "; " + document.cookie,
            parts = value.split('; cookie_notice_accepted=');
          if (parts.length === 2) {
            var val = parts.pop().split(';').shift();
            this.settings.consentGiven = val === 'true';
          }
        } else if (typeof window.complianz !== 'undefined') {
          // Complianz by Really Simple Plugins
          this.settings.consentGiven = sbyCmplzGetCookie('cmplz_marketing') === 'allow' || jQuery('body').hasClass('cmplz-status-marketing');
        } else if (typeof window.Cookiebot !== "undefined") {
          // Cookiebot by Cybot A/S
          this.settings.consentGiven = Cookiebot.consented;
        } else if (typeof window.BorlabsCookie !== 'undefined') {
          // Borlabs Cookie by Borlabs
          this.settings.consentGiven = typeof window.BorlabsCookie.Consents !== 'undefined' ? window.BorlabsCookie.Consents.hasConsent('youtube') : window.BorlabsCookie.checkCookieConsent('youtube');
        } else if (sbyCmplzGetCookie('moove_gdpr_popup')) {
          // Moove GDPR Popup
          var moove_gdpr_popup = JSON.parse(decodeURIComponent(sbyCmplzGetCookie('moove_gdpr_popup')));
          this.settings.consentGiven = typeof moove_gdpr_popup.thirdparty !== "undefined" && moove_gdpr_popup.thirdparty === "1";
        }
        var evt = jQuery.Event('sbycheckconsent');
        evt.feed = this;
        jQuery(window).trigger(evt);
        if (this.settings.consentGiven) {
          this.settings.noCDN = false;
        }
        return this.settings.consentGiven; // GDPR not enabled
      },
      afterConsentToggled: function afterConsentToggled() {
        if (this.checkConsent()) {
          var feed = this;
          window.sby.maybeAddYTAPI();
          feed.maybeRaiseImageResolution();
          feed.applyFullFeatures();
          setTimeout(function () {
            feed.afterResize();
          }, 500);
        }
      },
      removeFeatures: function removeFeatures() {
        var feed = this;
        if (feed.settings.noCDN) {
          $(feed.el).find('.sby_video_thumbnail').each(function () {
            $(this).removeAttr('data-sby-lightbox');
          });
        }
      },
      applyFullFeatures: function applyFullFeatures() {
        var feed = this;
        $(feed.el).find('.sby_header_img img').attr('src', $(feed.el).find('.sby_header_img').attr('data-avatar-url'));
        if (typeof $(feed.el).find('.sby_video_thumbnail').first().attr('data-sby-lightbox') === 'undefined' && feed.settings.lightboxEnabled) {
          $(feed.el).find('.sby_video_thumbnail').each(function () {
            $(this).attr('data-sby-lightbox', feed.index);
          });
        }
        var $self = $(feed.el);
        $self.find('.sby_no_consent').removeClass('sby_no_consent');
        if ($self.hasClass('sby_layout_gallery') && $self.find('.sby_player_outer_wrap').length) {
          this.maybeRaiseSingleImageResolution($self.find('.sby_player_outer_wrap'), 0, true);
          $self.find('.sby_item').first().addClass('sby_current');
          if (!feed.canCreatePlayer()) {
            return;
          }
          if (!$self.find('.sby_player_outer_wrap iframe').length) {
            feed.createPlayer('sby_player' + feed.index);
          }
        }
      },
      locationGuess: function locationGuess() {
        var $feed = $(this.el),
          location = 'content';
        if ($feed.closest('footer').length) {
          location = 'footer';
        } else if ($feed.closest('.header').length || $feed.closest('header').length) {
          location = 'header';
        } else if ($feed.closest('.sidebar').length || $feed.closest('aside').length) {
          location = 'sidebar';
        }
        return location;
      }
    };
    function SbyFeedPro(el, index, settings) {
      SbyFeed.call(this, el, index, settings);
      this.CTA = {};
      this.initLayout = function () {
        this.initGalleryLayout();
        this.initGrid();
        this.initCarousels();
        var evt = jQuery.Event('sbyafterlayoutinit');
        evt.feed = this;
        jQuery(window).trigger(evt);
        openComments();
      };
      this.initGrid = function () {
        if (window.sbySemiEagerLoading && jQuery('#sby_lightbox').length) {
          var feed = this;
          playerID = 'sby_lb-player';
          jQuery('#sby_lightbox').addClass('sby_video_lightbox');
          if (!window.sbyOptions.isPro) {
            jQuery('#sby_lightbox').addClass('sby_lightbox_free');
          }
          var videoID = $(this.el).find('sby_item').first().attr('data-video-id'),
            autoplay = sbyOptions.autoplay;
          if (typeof window.sbyLightboxPlayer === 'undefined') {
            var args = {
              host: window.location.protocol + feed.embedURL,
              videoId: videoID,
              playerVars: {
                modestbranding: 1,
                rel: 0,
                autoplay: autoplay
              },
              events: {
                'onStateChange': function onStateChange(data) {
                  var videoID = data.target.getVideoData()['video_id'];
                  feed.afterStateChange(playerID, videoID, data, $('#' + playerID).closest('.sby_video_thumbnail_wrap'));
                }
              }
            };
            feed.maybeAddCTA(playerID);
            window.sbyLightboxPlayer = new window.YT.Player(playerID, args);
          }
        }
      };
      this.initCarousels = function () {
        var feed = this,
          $self = $(this.el);
        if (typeof this.settings.general.carousel === 'undefined') {
          return;
        }
        var cols = this.settings.cols,
          colsmobile = this.settings.colsmobile;
        $self.find('.sby_items_wrap').addClass('sby_carousel');
        $self.find('.sby_load_btn').remove();
        $self.find('.sby_item').css({
          'padding-top': $self.find('.sby_items_wrap').css('padding-top'),
          'padding-right': $self.find('.sby_items_wrap').css('padding-top'),
          'padding-bottom': $self.find('.sby_items_wrap').css('padding-top'),
          'padding-left': $self.find('.sby_items_wrap').css('padding-top')
        });
        $self.find('.sby_item').each(function () {
          $(this).attr('style', $(this).attr('style').replace('padding: ' + $self.find('.sby_items_wrap').css('padding-top'), 'padding: ' + $self.find('.sby_items_wrap').css('padding-top') + ' !important'));
        });
        var arrows = feed.settings.general.carousel[0],
          pagination = feed.settings.general.carousel[1],
          autoplay = feed.settings.general.carousel[2],
          time = feed.settings.general.carousel[3],
          loop = feed.settings.general.carousel[4],
          rows = feed.settings.general.carousel[5];
        //Initiate carousel
        if (!autoplay) time = false;

        //Set defaults for responsive breakpoints
        var itemsTabletSmall = cols,
          itemsMobile = cols,
          arrows = arrows ? 'onhover' : 'hide',
          autoplay = time !== false,
          has2rows = rows == 2,
          loop = !loop,
          onChange = function onChange() {
            setTimeout(function () {
              feed.afterResize();
            }, 1);
          },
          afterInit = function afterInit() {
            var $self = jQuery(feed.el);
            $self.find('.sby_items_wrap.sby_carousel').fadeIn();
            setTimeout(function () {
              $self.find('.sby_items_wrap.sby_carousel .sby_info, .sby_owl2row-item,.sby_items_wrap.sby_carousel').fadeIn();
            }, 1);
            setTimeout(function () {
              var $navElementsWrapper = $self.find('.sby-owl-nav');
              if (arrows === 'onhover') {} else if (arrows === 'below') {
                var $dots = $self.find('.sby-owl-dots'),
                  $prev = $self.find('.sby-owl-prev'),
                  $next = $self.find('.sby-owl-next'),
                  $nav = $self.find('.sby-owl-nav'),
                  $dot = $self.find('.sby-owl-dot'),
                  widthDots = $dot.length * $dot.innerWidth(),
                  maxWidth = $self.innerWidth();
                $prev.after($dots);
                $nav.css('position', 'relative');
                $next.css('position', 'absolute').css('top', '-6px').css('right', Math.max(.5 * $nav.innerWidth() - .5 * widthDots - $next.innerWidth() - 6, 0));
                $prev.css('position', 'absolute').css('top', '-6px').css('left', Math.max(.5 * $nav.innerWidth() - .5 * widthDots - $prev.innerWidth() - 6, 0));
              } else if (arrows === 'hide') {
                $navElementsWrapper.addClass('hide').hide();
              }
            }, 1);
          };

        //Disable mobile layout
        if ($self.hasClass('sby_mob_col_auto')) {
          itemsTabletSmall = 2;
          if (parseInt(cols) != 2) itemsMobile = 1;
          if (parseInt(cols) == 2) itemsMobile = 2; //If the cols are set to 2 then don't change to 1 col on mobile
        } else {
          itemsMobile = colsmobile;
        }
        this.carouselArgs = {
          items: cols,
          loop: loop,
          rewind: !loop,
          autoplay: autoplay,
          autoplayTimeout: Math.max(time, 2000),
          autoplayHoverPause: true,
          nav: true,
          navText: ['<svg class="svg-inline--fa fa-chevron-left fa-w-10" aria-hidden="true" data-fa-processed="" data-prefix="fa" data-icon="chevron-left" role="presentation" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path fill="currentColor" d="M34.52 239.03L228.87 44.69c9.37-9.37 24.57-9.37 33.94 0l22.67 22.67c9.36 9.36 9.37 24.52.04 33.9L131.49 256l154.02 154.75c9.34 9.38 9.32 24.54-.04 33.9l-22.67 22.67c-9.37 9.37-24.57 9.37-33.94 0L34.52 272.97c-9.37-9.37-9.37-24.57 0-33.94z"></path></svg>', '<svg class="svg-inline--fa fa-chevron-right fa-w-10" aria-hidden="true" data-fa-processed="" data-prefix="fa" data-icon="chevron-right" role="presentation" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path fill="currentColor" d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569-9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z"></path></svg>'],
          dots: pagination,
          owl2row: has2rows,
          responsive: {
            0: {
              items: itemsMobile
            },
            480: {
              items: itemsTabletSmall
            },
            640: {
              items: cols
            }
          },
          onChange: onChange,
          onInitialize: afterInit
        };
      };
      this.stripEmojihtml = function ($el) {
        $el.find('.emoji').each(function () {
          $(this).replaceWith($(this).attr('alt'));
        });
        return $el.html();
      };
      this.afterItemRevealed = function ($item) {
        var feed = this;
        if ($item.find('.sby_caption').length && !$item.find('.sby_caption').hasClass('sby_full_caption')) {
          //Expand post
          var $caption = $item.find('.sby_item_caption_wrap .sby_caption'),
            $hoverCaption = $item.find('.sby_item_video_thumbnail .sby_caption'),
            text_limit = typeof feed.settings.general.descriptionlength !== 'undefined' ? parseInt(feed.settings.general.descriptionlength) : 150;
          if (text_limit < 1) text_limit = 99999;
          //Set the full text to be the caption (used in the image alt)

          var captionText = this.stripEmojihtml($item.find('.sby_caption').first()),
            brCount = (captionText.match(/<br>/g) || []).length,
            brAdjust = typeof sbyOptions.brAdjust === 'undefined' || sbyOptions.brAdjust === '1' || sbyOptions.brAdjust === true;
          // comment out unnecessary code that stripes out text limit with wrong text limit
          // replace emoji with alt for more accurate shortening
          //                     if (brAdjust && brCount > 0 && captionText.indexOf('<br>') < text_limit) {
          //                         var $sizingCaption = $item.find('.sby_video_title').first();
          //                         captionWidth = $sizingCaption.width() > 20 ? $sizingCaption.width() : $item.width(),
          //                           fontSize = $sizingCaption.css('font-size'),
          //                           charactersPerLine = captionWidth / parseInt(fontSize) * 1.85,
          //                           maxCharsPerLine = Math.floor(charactersPerLine),
          //                           projectedMaxLines = Math.ceil(text_limit / charactersPerLine);
          //                         var splitCaption = captionText.split('<br>'),
          //                           linesConsumed = 0,
          //                           adjustedTextLimit = 0;
          //                         jQuery.each(splitCaption, function () {
          //                             var linesLeft = projectedMaxLines - linesConsumed;
          //                             if (linesLeft > 0) {
          //                                 var thisLinesConsumed = Math.max(1, Math.ceil(this.length / charactersPerLine));
          //                                 adjustedTextLimit += Math.min(this.length + 4, linesLeft * maxCharsPerLine);
          //                                 linesConsumed += thisLinesConsumed;
          //                             }
          //                         });
          //                         text_limit = adjustedTextLimit;
          //                     }
          var short_text = captionText.substring(0, text_limit);
          short_text = captionText.length > text_limit ? short_text.substr(0, Math.min(short_text.length, short_text.lastIndexOf(" "))) : short_text;

          //Cut the text based on limits set
          if ($caption.length) {
            $caption.html(sbyLinkify(short_text));
            if (short_text === captionText) {
              $caption.next('.sby_expand').remove();
            }
          }
          if ($hoverCaption.length) {
            var hoverCaptionText = short_text;
            if (short_text !== captionText) {
              hoverCaptionText += '<span class="sby_more">...</span>';
            }
            $hoverCaption.html(hoverCaptionText);
          }

          //Show the 'See More' link if needed
          if (captionText.length > text_limit) {
            $item.find('.sby_expand').show();
          }
          //Click function
          $item.find('.sby_expand a').off('click').on('click', function (e) {
            e.preventDefault();
            var $expand = jQuery(this);
            $caption = typeof $caption !== 'undefined' ? $caption : $item.find('.sby_info .sby_caption');
            captionText = typeof captiontext !== 'undefined' ? captionText : sbyEncodeInput($item.find('.sby_item_video_thumbnail').attr('data-title'));
            if ($item.hasClass('sby_caption_full') && typeof short_text !== 'undefined') {
              $caption.html(short_text);
              $item.removeClass('sby_caption_full');
            } else {
              $caption.html(sbyLinkify(captionText));
              $item.addClass('sby_caption_full');
            }
            feed.afterResize();
          });
        }
        this.setUpCTA($item);

        //Photo links
        //If lightbox is disabled
        var disablelightbox = typeof feed.settings.general.disablelightbox !== 'undefined' ? feed.settings.general.disablelightbox : false,
          captionlinks = typeof feed.settings.general.captionlinks !== 'undefined' ? feed.settings.general.captionlinks : false;
        if (disablelightbox || captionlinks) {
          if (captionlinks) {
            var sbyUrlDetect = function sbyUrlDetect(text) {
              var urlRegex = /https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g;
              return text.match(urlRegex);
            };
            var cap = '';
            if (typeof $item.find('img').attr('alt') !== 'undefined') {
              cap = $item.find('img').attr('alt');
            } else if (typeof $item.find('video').attr('alt') !== 'undefined') {
              cap = $item.find('video').attr('alt');
            }
            var url = sbyUrlDetect(cap);
            if (url) {
              $item.find('a').attr('href', url);
            }
          }
          $item.find('.sby_link').addClass('sby_disable_lightbox');
          //If lightbox is enabled add lightbox links
        } else {
          var $sby_photo_wrap = $item.find('.sby_photo_wrap'),
            $sby_link = $sby_photo_wrap.find('.sby_link');
          feedOptions = {
            hovereffect: 'true'
          };
          if (feedOptions.hovereffect == 'none') {
            //launch lightbox on click
            $sby_link.css('background', 'none').show();
            $sby_link.find('*').hide().end().find('.sby_link_area').show();
          } else {
            $sby_photo_wrap.on('mouseenter mouseleave', function (e) {
              switch (e.type) {
                case 'mouseenter':
                  $item.addClass('sby_animate');
                  break;
                case 'mouseleave':
                  $item.removeClass('sby_animate');
                  break;
              }
            });
          }
        }
        var videoID = typeof $item.attr('data-video-id') !== 'undefined' ? $item.attr('data-video-id') : $item.find('.sby_video_thumbnail').attr('data-video-id');
        this.mostRecentlyLoadedPosts.push(videoID);
      };
      this.afterFeedSet = function () {
        if (typeof this.carouselArgs !== 'undefined') {
          $(this.el).find('.sby_carousel').sbyOwlCarousel(this.carouselArgs);
          if (parseInt(this.settings.general.carousel[5]) === 2) {
            $(this.el).addClass('sby_carousel_2_row');
          }
        }
      };
      this.setUpCTA = function ($item, videoID) {
        //window.sby.ctas

        var videoID = typeof videoID !== 'undefined' ? videoID : $item.find('.sby_item_video_thumbnail').attr('data-video-id'),
          text = sbyEncodeInput(typeof $item.find('.sby_item_video_thumbnail').attr('data-title') !== 'undefined' ? $item.find('.sby_item_video_thumbnail').attr('data-title') : ''),
          ctaInCaption = window.sby.ctaDetect(text);
        if (ctaInCaption) {
          window.sby.ctas[videoID] = ctaInCaption;
        } else {
          window.sby.ctas[videoID] = this.getDefaultCTA();
        }
      };
      this.getDefaultCTA = function () {
        if (typeof this.settings.general.cta !== 'undefined' && this.settings.general.cta.type !== 'default') {
          if (this.settings.general.cta.type === 'link') {
            return {
              callback: 'link',
              url: this.settings.general.cta.defaultLink,
              text: this.settings.general.cta.defaultText
            };
          } else {
            return {
              callback: 'related',
              related: this.settings.general.cta.defaultPosts
            };
          }
        } else {
          return false;
        }
      };
      this.afterResize = function () {
        this.setImageHeight();
        this.setImageResolution();
        this.maybeRaiseImageResolution();
        this.setImageSizeClass();
        this.setAllCTADimensions();
        this.sizePlayer();
        this.sizeItems();
      };
      this.setAllCTADimensions = function () {
        $.each(this.CTA, function (index, CTAObj) {
          if (CTAObj.isInitialized) {
            CTAObj.setCTAStyles();
          }
        });
      };
      this.afterSendCheckWPPostsToServer = function (response) {
        var $self = $(this.el);
        $self.find('.sby_item').each(function () {
          if (typeof response[$(this).attr('data-video-id')] !== 'undefined') {
            var data = response[$(this).attr('data-video-id')];
            //sby_views_count
            $(this).find('.sby_view_count').text(data.sby_view_count);
            $(this).find('.sby_comment_count').text(data.sby_comment_count);
            $(this).find('.sby_like_count').text(data.sby_like_count);

            //Set for attributes too.
            $(this).find('.sby_video_thumbnail').attr('data-views', data.sby_view_count);
            $(this).find('.sby_video_thumbnail').attr('data-comment-count', data.sby_comment_count);
            if (data.sby_live_broadcast.broadcast_type !== 'none') {
              $(this).find('.sby_ls_message').text(data.sby_live_broadcast.live_streaming_string);
              $(this).find('.sby_date').html(data.sby_live_broadcast.live_streaming_date);
            }
            if (typeof data.sby_live_broadcast.live_streaming_timestamp !== 'undefined') {
              $(this).attr('data-live-date', data.sby_live_broadcast.live_streaming_timestamp);
            }
            if (typeof data.sby_description !== 'undefined') {
              $(this).find('.sby_item_video_thumbnail').attr('data-title', sbyEncodeInput(data.sby_description));
            }
          }
        });
        $self.find('.sby_player_item').each(function () {
          if (typeof response[$(this).find('.sby_video_thumbnail').attr('data-video-id')] !== 'undefined') {
            var data = response[$(this).find('.sby_video_thumbnail').attr('data-video-id')];
            $(this).find('.sby_view_count').text(data.sby_view_count);
            $(this).find('.sby_comment_count').text(data.sby_comment_count);
            $(this).find('.sby_like_count').text(data.sby_like_count);
            if (data.sby_live_broadcast.broadcast_type !== 'none') {
              $(this).find('.sby_ls_message').text(data.sby_live_broadcast.live_streaming_string);
              $(this).find('.sby_date').html(data.sby_live_broadcast.live_streaming_date);
            }
            if (typeof data.sby_live_broadcast.live_streaming_timestamp !== 'undefined') {
              $(this).attr('data-live-date', data.sby_live_broadcast.live_streaming_timestamp);
            }
          }
        });
        var evt = jQuery.Event('sbyaftercheckposts');
        evt.feed = window.sby.feeds[index];
        evt.response = response;
        jQuery(window).trigger(evt);
      };
      this.afterStateChange = function (playerID, videoID, data, $player) {
        this.CTA[playerID].toggleCTA(videoID, data.data, $player);
      };
      this.changePlayerInfo = function ($newItem) {
        var $self = $(this.el);
        $self.find('.sby_player_item').find('.sby_info').replaceWith($newItem.find('.sby_info').clone(true, true));
        var videoTitle = checkValue($newItem.attr('data-video-title'));
        var videoPublishData = checkValue($newItem.find('.sby_video_thumbnail').attr('data-formatted-published-date'));
        $self.find('.sby-player-info .sby-video-header-info .sby-video-info-header h5').text(videoTitle);
        $self.find('.sby-player-info .sby-video-header-meta .sby-video-date').text(videoPublishData);
        resetComments($self);
        openComments();
      };
      this.maybeAddCTA = function (playerID, $el) {
        if (typeof this.CTA[playerID] === 'undefined') {
          this.CTA[playerID] = new SbyCTA(playerID, this);
        }
      };
    }
    SbyFeedPro.prototype = Object.create(SbyFeed.prototype);
    function SbyLightboxBuilder() {}
    SbyLightboxBuilder.prototype = {
      getData: function getData(a) {
        var closestFeedIndex = parseInt(a.closest('.sb_youtube').attr('data-sby-index') - 1);
        return {
          feedIndex: closestFeedIndex,
          link: a.attr("href"),
          videoTitle: typeof a.attr("data-video-title") !== 'undefined' ? sbyEncodeInput(a.attr("data-video-title")) : 'YouTube Video',
          video: a.attr("data-video-id"),
          channelID: a.attr("data-channel-id")
        };
      },
      template: function template() {
        return "<div id='sby_lightboxOverlay' class='sby_lightboxOverlay'></div>" + "<div id='sby_lightbox' class='sby_lightbox'>" + "<div class='sby_lb-outerContainer'>" + "<div class='sby_lb-container'>" + "<img class='sby_lb-image' alt='Lightbox image placeholder' src='' />" + "<div class='sby_lb-player sby_lb-player-placeholder' id='sby_lb-player'></div>" + "<div class='sby_lb-nav'><a class='sby_lb-prev' href='#' ><p class='sby-screenreader'>Previous Slide</p><span></span></a><a class='sby_lb-next' href='#' ><p class='sby-screenreader'>Next Slide</p><span></span></a></div>" + "<div class='sby_lb-loader'><a class='sby_lb-cancel'></a></div>" + "</div>" + "</div>" + "<div class='sby_lb-dataContainer'>" + "<div class='sby_lb-data'>" + "<div class='sby_lb-details'>" + "<div class='sby_lb-caption'></div>" + "<div class='sby_lb-info'>" + "<div class='sby_lb-number'></div>" + "</div>" + "</div>" + "<div class='sby_lb-closeContainer'><a class='sby_lb-close'></a></div>" + "</div>" + "</div>" + "</div>";
      },
      beforePlayerSetup: function beforePlayerSetup($lightbox, data, index, album, feed) {},
      afterPlayerSetup: function afterPlayerSetup($lightbox, data, index, album) {},
      afterResize: function afterResize() {
        var playerHeight = $('#sby_lightbox .sby_lb-player').height();
        if (playerHeight > 100) {
          var heightDif = $('#sby_lightbox .sby_lb-outerContainer').height() - playerHeight;
          if (heightDif > 10) {
            $('#sby_lightbox .sby_lb-player').css('top', heightDif / 2);
          }
        }
      },
      pausePlayer: function pausePlayer() {
        if (typeof window.sbyLightboxPlayer === 'undefined' && typeof YT === 'undefined') {
          return;
        }
        if (typeof YT.get('sby_lb-player') !== 'undefined' && typeof YT.get('sby_lb-player').pauseVideo === 'function') {
          YT.get('sby_lb-player').pauseVideo();
        } else if (typeof window.sbyLightboxPlayer !== 'undefined' && typeof window.sbyLightboxPlayer.pauseVideo === 'function') {
          window.sbyLightboxPlayer.pauseVideo();
        }
      }
    };
    SbyLightboxBuilderPro.prototype = Object.create(SbyLightboxBuilder.prototype);
    function SbyLightboxBuilderPro() {
      SbyLightboxBuilder.call(this);
      this.getData = function (a) {
        var feedParent = a.closest('.sb_youtube');
        var closestFeedIndex = parseInt(feedParent.attr('data-sby-index') - 1);
        var subscribeBtnText = feedParent.attr('data-subscribe-btn-text');
        var subscribeBtn = feedParent.attr('data-subscribe-btn');
        var colorScheme = feedParent.hasClass('sby_palette_dark') ? 'dark' : 'light';
        var atts = feedParent.attr('data-shortcode-atts');
        var liveDataAttr = a.closest('.sby_item').attr('data-live-date');
        var channelHeaderColorsAttr = feedParent.attr('data_channel_header_colors') ? JSON.parse(feedParent.attr('data_channel_header_colors')) : '';
        return {
          feedIndex: closestFeedIndex,
          link: a.attr("href"),
          video: a.attr("data-video-id"),
          title: sbyEncodeInput(a.attr("data-title")),
          videoTitle: typeof a.attr("data-video-title") !== 'undefined' ? sbyEncodeInput(a.attr("data-video-title")) : 'YouTube Video',
          avatar: a.attr("data-avatar"),
          user: sbyEncodeInput(a.attr("data-user")),
          channelURL: a.attr("data-url"),
          channelID: a.attr("data-channel-id"),
          channelSubscribers: a.closest('.sb_youtube').attr('data-channel-subscribers'),
          subscribeBtn: subscribeBtn,
          subscribeBtnText: subscribeBtnText,
          colorScheme: colorScheme,
          publishedDate: a.attr("data-published-date"),
          commentCount: a.attr("data-comment-count"),
          views: a.attr("data-views"),
          liveData: liveDataAttr,
          channelHeaderColors: channelHeaderColorsAttr,
          atts: atts
        };
      };
      this.template = function () {
        return "\n                <div id='sby_lightboxOverlay' class='sby_lightboxOverlay'></div>\n                <div id='sby_lightbox' class='sby_lightbox'>\n                 <div class='sby_lb-header'></div>\n                  <div class='sby_lb-outerContainer'>\n                    <a class='sby_lb-close'></a>\n                    <div class='sby_lb-container'>\n                      <div class='sby_lb_video_thumbnail_wrap'>\n                        <span class='sby_lb_video_thumbnail'>\n                          <img class='sby_lb-image' alt='Lightbox image placeholder' src='' />\n                          <div class='sby_lb-player' id='sby_lb-player'></div>\n                        </span>\n                      </div>\n                      <div class='sby_lb-nav'>\n                        <a class='sby_lb-prev' href='#'>\n                          <p class='sby-screenreader'>Previous Slide</p>\n                          <span></span>\n                        </a>\n                        <a class='sby_lb-next' href='#'>\n                          <p class='sby-screenreader'>Next Slide</p>\n                          <span></span>\n                        </a>\n                      </div>\n                      <div class='sby_lb-loader'>\n                        <a class='sby_lb-cancel'></a>\n                      </div>\n                    </div>\n                  </div>\n                  <div class='sby_lb-dataContainer'>\n                    <div class='sby_lb-data'>\n                      <div class='sby_lb-details'>\n                        <div class='sby_lb-caption'>\n                        </div>\n                        <div class='sby_lb-info'>\n                          <div class='sby_lb-number'></div>\n                        </div>\n                      </div>\n                    </div>\n                  </div>\n                </div>";
      };
      this.beforePlayerSetup = function ($lightbox, data, index, album, feed) {
        $('body').css('overflow', 'hidden');
        if (!$lightbox.find('.sby_cta_items_wraps').length) {
          $lightbox.find('.sby_lb_video_thumbnail_wrap').append($(feed.el).find('.sby_cta_items_wraps').clone());
        } else {
          $lightbox.find('.sby_cta_items_wraps').replaceWith($(feed.el).find('.sby_cta_items_wraps').clone());
        }
      };
      this.afterPlayerSetup = function ($lightbox, data, index, album) {
        var _data$channelSubscrib;
        this.availableAvatarUrls = {};
        var subscribeSection = data !== null && data !== void 0 && data.subscribeBtn ? data.subscribeBtn : false;
        var subscribeBtnText = data !== null && data !== void 0 && data.subscribeBtnText ? data.subscribeBtnText : '';
        if (typeof sbyLightboxAction === 'function') {
          setTimeout(function () {
            sbyLightboxAction();
          }, 100);
        }
        if (data !== null && data !== void 0 && data.colorScheme && 'dark' === data.colorScheme) {
          LightboxColorScheme(data.colorScheme, true);
        }
        var avatarImage = '',
          subscribeBtn = subscribeSection ? '<a class="sby-lb-subscribe-btn" href="http://www.youtube.com/channel/' + data.channelID + '?sub_confirmation=1&feature=subscribe-embed-click" target="_blank" rel="noopener noreferrer">' + getStaticSVG('youtube') + ' <p>' + subscribeBtnText + '</p></a>' : '';
        if (typeof data.avatar !== 'undefined' && data.avatar !== '' && typeof data.user !== 'undefined') {
          avatarImage = data.avatar !== 'undefined' ? data.avatar : '';
        } else if (typeof data.user !== 'undefined') {
          jQuery.each(window.sby.feeds, function () {
            if (typeof this.availableAvatarUrls !== 'undefined' && typeof this.availableAvatarUrls[data.user] !== 'undefined' && this.availableAvatarUrls[data.user] !== 'undefined') {
              avatarImage = this.availableAvatarUrls[data.user];
            }
          });
        }
        var channelSubscribers = (_data$channelSubscrib = data === null || data === void 0 ? void 0 : data.channelSubscribers) !== null && _data$channelSubscrib !== void 0 ? _data$channelSubscrib : '';
        var avatarImageHtml = avatarImage ? '<img src="' + avatarImage + '" referrerPolicy="no-referrer"/>' : getStaticSVG('profile-picture');
        var userHtml = subscribeSection && avatarImage ? '<div class="sby-lb-channel-header"><a class="sby_lightbox_username" href="' + data.channelURL + '" target="_blank" rel="noopener">' + avatarImageHtml + '<p class="sby-lb-channel-name-with-subs"><span>@' + data.user + '</span><span>' + channelSubscribers + '</span></p></a> ' + subscribeBtn + '</div>' : '';
        var subscribeClass = subscribeSection && avatarImage ? 'sby_lb-channel-info' : 'sby_lb-no-channel-info';
        if (window.sbyOptions.isPro) {
          var description = data !== null && data !== void 0 && data.title ? addLinksTotext(data.title) : '';
          var publishedDate = data !== null && data !== void 0 && data.publishedDate ? timeAgo(convertUnixToMs(data.publishedDate)) : '';
          var views = data !== null && data !== void 0 && data.views ? data.views : '';
          var videoHeaderSection = "\n                    <div class=\"sby_lb-video-heading\">\n                        <h3>".concat(data.videoTitle, "</h3>\n                        <div class=\"sby_lb-video-info\">\n                            <span>").concat(views, "</span>\n                            <span class=\"sby_lb-spacer\">\xB7</span>\n                            <span>").concat(publishedDate, "</span>\n                        </div>\n                    </div>\n                ");
          var videoDescriptionhtml = "\n                    <div class=\"sby_lb-video-description-wrap\">\n                        <div class=\"sby_lb-description sby-read-more-target\">\n                            ".concat(description, "\n                        </div>\n                        <button class=\"sby_lb-more-info-btn sby-read-more-trigger\">Description").concat(getStaticSVG('angle-down'), "</button>\n                    </div>\n                ");
          var commentSectionHtml = "\n                    <div class=\"sby-comments-wrap\">\n                    </div>\n                ";
          var videoDescription = description ? videoDescriptionhtml : '';
          $lightbox.find(".sby_lb-caption").html("<div class=\"sby_lb-caption-inner ".concat(subscribeClass, "\">") + videoHeaderSection + userHtml + videoDescription + commentSectionHtml + "</div>").fadeIn("fast");
          if (data !== null && data !== void 0 && data.liveData && '0' === data.liveData) {
            var videoId = data !== null && data !== void 0 && data.video ? data.video : '';
            var atts = data !== null && data !== void 0 && data.atts ? data.atts : '';
            var _currentCommentCount = data !== null && data !== void 0 && data.commentCount ? data.commentCount : '';
            var target = $lightbox.find(".sby-comments-wrap");
            generateCommentSection(videoId, atts, target, _currentCommentCount);
          } else {
            toggleReadMore();
          }
          if (data !== null && data !== void 0 && data.channelHeaderColors) {
            setColorsToChannelHeader(data.channelHeaderColors);
          }
        }
      };
    }
    function SbyCTA(videoID, feed) {
      this.isInitialized = false;
      this.videoID = videoID;
      this.callback = this.related;
      this.callbackArgs = {};
      this.feedObjInContext = feed;
      this.state = 1;
      this.numItems = 4;
      this.numItemColumns = 2;
      this.$player = false;
    }
    SbyCTA.prototype = {
      toggleCTA: function toggleCTA(videoID, dataNum, $player) {
        this.$player = $player.length ? $player : $('.sby_lb-container'); // use the lightbox container if no player is set
        this.state = dataNum;
        this.videoID = videoID;
        this.isInitialized = true;
        this.resetCTA();

        //ctaDetect

        if (typeof window.sby.ctas[videoID] !== 'undefined') {
          this.callbackArgs = window.sby.ctas[videoID];
        }
        var callback = this.callbackArgs.callback;
        if (callback === 'link') {
          this.callback = this.link;
        } else if (callback === 'related') {
          this.callback = this.related;
        } else {
          return;
        }
        if (dataNum === 2 || dataNum === 0) {
          this.$player.find('.sby_cta_items_wraps').addClass('sby_cta_is_open');
          if (dataNum === 2) {
            this.$player.find('.sby_cta_items_wraps').addClass('sby_cta_state_paused');
          } else {
            this.$player.find('.sby_cta_items_wraps').addClass('sby_cta_state_ended');
          }
          this.$player.find('.sby_cta_items_wraps').show();
          this.callback();
          this.setCTAStyles();
        } else {
          this.$player.find('.sby_cta_items_wraps').removeClass('sby_cta_is_open');
          this.$player.find('.sby_cta_items_wraps').hide().removeClass('sby_cta_state_paused').removeClass('sby_cta_state_ended').removeClass('sby_cta_is_open');
        }
      },
      related: function related(args) {
        var ctaObj = this,
          feedObjInContext = this.feedObjInContext,
          related = window.sby.shuffle(this.getRelated(feedObjInContext)),
          added = 0,
          currentVideoId = this.videoID,
          $player = this.$player;
        this.$player.find('.sby_cta_items_wraps').removeClass('sby_cta_cols_' + this.numItemColumns);
        this.numItems = 4;
        this.numItemColumns = 2;
        if ($player.width() < 480) {
          this.numItems = 1;
          this.numItemColumns = 1;
        }
        var numItems = this.numItems;
        $.each(related, function (index, value) {
          if (value.videoID !== currentVideoId && added < numItems) {
            $player.find('.sby_cta_items_wraps .sby_cta_inner_wrap').append('<div class="sby_cta_item"><div class="sby_video_thumbnail_wrap">' + '<a class="sby_video_thumbnail" href="javascript:void(0);" target="_blank" rel="noopener" data-video-id="' + value.videoID + '">' + '<div class="sby_thumbnail_hover">' + '<div class="sby_thumbnail_hover_inner">' + '<span class="sby_video_title">' + value.title + '</span>' + '</div>' + '</div>' + '<span class="sby-screenreader">Play</span>' + '<img src="' + value.thumbnail + '" alt="' + value.title + '">' + '<span class="sby_loader sby_hidden" style="background-color: rgb(255, 255, 255);"></span>' + '</a>' + '</div>' + '</div>');
            added++;
          }
        });
        $player.find('.sby_cta_items_wraps .sby_video_thumbnail').each(function () {
          $(this).off().on('click', function (event) {
            event.preventDefault();
            var newVideoID = $(this).attr('data-video-id');
            feedObjInContext.onThumbnailClick($(this), true, newVideoID);
            ctaObj.videoID = newVideoID;
          });
        });
      },
      getRelated: function getRelated(feedObjInContext) {
        if (typeof feedObjInContext.settings.general.cta.defaultPosts[0] === 'undefined') {
          var $feedEl = $(feedObjInContext.el),
            relatedVids = [];
          $feedEl.find('.sby_item').each(function () {
            if (typeof $(this).find('.sby_item_video_thumbnail').attr('data-full-res') !== 'undefined') {
              var thisVid = {
                videoID: $(this).attr('data-video-id'),
                title: sbyEncodeInput($(this).attr('data-video-title')),
                thumbnail: $(this).find('.sby_item_video_thumbnail').attr('data-full-res')
              };
              relatedVids.push(thisVid);
            }
          });
          return relatedVids;
        }
        return feedObjInContext.settings.general.cta.defaultPosts;
      },
      link: function link(args) {
        var $player = this.$player,
          feedObjInContext = this.feedObjInContext;
        this.$player.find('.sby_cta_items_wraps').removeClass('sby_cta_cols_' + this.numItemColumns);
        this.numItems = 1;
        this.numItemColumns = 1;
        var style = '',
          styleClass = '';
        if (feedObjInContext.settings.general.cta.color !== '' || feedObjInContext.settings.general.cta.textColor !== '') {
          style = ' style="';
          styleClass = ' sby_custom';
          if (feedObjInContext.settings.general.cta.color !== '') {
            style += 'background: rgb(' + feedObjInContext.settings.general.cta.color + ');';
          }
          if (feedObjInContext.settings.general.cta.textColor !== '') {
            style += 'color: rgb(' + feedObjInContext.settings.general.cta.textColor + ');';
          }
          style += '"';
        }
        var openAtts = '';
        if (feedObjInContext.settings.general.cta.openType === 'newwindow') {
          openAtts = ' target="_blank" rel="noopener"';
        }
        $player.find('.sby_cta_items_wraps .sby_cta_inner_wrap').append('<div class="sby_cta_item">' + '<div class="sby_btn_wrap">' + '<div class="sby_btn' + styleClass + '">' + '<a class="sby_cta_button" href="' + this.callbackArgs.url + '"' + openAtts + ' data-video-id="' + this.videoID + '"' + style + '>' + this.callbackArgs.text + '</a>' + '</div>' + '</div>' + '</div>');
      },
      setCTAStyles: function setCTAStyles() {
        var playerTopHeight = 60,
          playerBottomHeight = 49,
          minimumHeight = 90,
          ctaOverlayHeight = Math.max(minimumHeight, this.$player.height() - playerTopHeight - playerBottomHeight);
        this.$player.find('.sby_cta_items_wraps').css('height', ctaOverlayHeight + 'px').css('width', this.$player.find('iframe').width() - 20 + 'px').addClass('sby_cta_cols_' + this.numItemColumns);
        var numRows = Math.max(1, this.numItems / this.numItemColumns),
          totalVerticalPadding = parseInt(this.$player.find('.sby_cta_items_wraps').css('padding-top').replace('px', '')) * 2,
          maxCTAItemHeight = Math.max(minimumHeight, (ctaOverlayHeight - totalVerticalPadding) / numRows);
        this.$player.find('.sby_cta_item').css('max-height', maxCTAItemHeight + 'px').find('img').css({
          'max-height': maxCTAItemHeight + 'px',
          'width': 'auto',
          'margin': 'auto'
        });
        this.$player.find('.sby_btn_wrap').css('height', maxCTAItemHeight + 'px');
      },
      resetCTA: function resetCTA() {
        this.$player.find('.sby_cta_items_wraps .sby_cta_inner_wrap').empty();
      }
    };
    window.sby_init = function () {
      window.sby = new Sby();
      window.sby.createPage(window.sby.createFeeds, {
        whenFeedsCreated: window.sby.afterFeedsCreated
      });
    };
    window.sby_carousel_init = function () {
      console.log('log');
    };
    function sbyGetNewFeed(feed, index, feedOptions) {
      return new SbyFeedPro(feed, index, feedOptions);
    }
    function sbyGetlightboxBuilder() {
      return new SbyLightboxBuilderPro();
    }
    function sbyIsTouch() {
      if ("ontouchstart" in document.documentElement) {
        return true;
      }
      return false;
    }
    function sbyCmplzGetCookie(cname) {
      var name = cname + "="; //Create the cookie name variable with cookie name concatenate with = sign
      var cArr = window.document.cookie.split(';'); //Create cookie array by split the cookie by ';'

      //Loop through the cookies and return the cookie value if it find the cookie name
      for (var i = 0; i < cArr.length; i++) {
        var c = cArr[i].trim();
        //If the name is the cookie string at position 0, we found the cookie and return the cookie value
        if (c.indexOf(name) == 0) return c.substring(name.length, c.length);
      }
      return "";
    }
  })(jQuery);
  if (typeof window.sbyEagerLoading === 'undefined') {
    window.sbyEagerLoading = typeof window.sbyOptions !== 'undefined' ? window.sbyOptions.eagerload : false;
    if (jQuery('.elementor-widget-video').length) {
      var settings = typeof jQuery('.elementor-widget-video').attr('data-settings') !== 'undefined' ? JSON.parse(jQuery('.elementor-widget-video').attr('data-settings')) : false;
      if (settings && typeof settings.youtube_url !== 'undefined') {
        window.sbyEagerLoading = true;
      }
    }
    if (jQuery('div[data-vc-video-bg]').length) {
      window.sbyEagerLoading = true;
    }
  }
  if (typeof window.sbySemiEagerLoading === 'undefined') {
    window.sbySemiEagerLoading = typeof window.sbyOptions !== 'undefined' ? window.sbyOptions.semiEagerload : false;
    if (jQuery('div[data-vc-video-bg]').length || window.sbyEagerLoading) {
      window.sbySemiEagerLoading = false;
    }
  }
  jQuery(document).ready(function ($) {
    if (!window.sbySemiEagerLoading) {
      sby_init();
    }

    // Cookie Notice by dFactory
    $('#cookie-notice a').on('click', function () {
      setTimeout(function () {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].afterConsentToggled();
        });
      }, 1000);
    });

    // Cookie Notice by dFactory
    $('#cookie-law-info-bar a').on('click', function () {
      setTimeout(function () {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].afterConsentToggled();
        });
      }, 1000);
    });

    // GDPR Cookie Consent by WebToffee
    $('.cli-user-preference-checkbox').on('click', function () {
      setTimeout(function () {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].settings.consentGiven = false;
          window.sby.feeds[index].afterConsentToggled();
        });
      }, 1000);
    });

    // Cookiebot
    $(window).on('CookiebotOnAccept', function (event) {
      $.each(window.sby.feeds, function (index) {
        window.sby.feeds[index].settings.consentGiven = true;
        window.sby.feeds[index].afterConsentToggled();
      });
    });

    // Complianz by Really Simple Plugins
    document.addEventListener('cmplz_status_change', function (e) {
      if (e.detail.category === 'marketing' && e.detail.value === 'allow') {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].settings.consentGiven = true;
          window.sby.feeds[index].afterConsentToggled();
        });
      }
    });
    $(document).on('cmplzFireCategories', function (event) {
      if (event.detail.category === 'marketing') {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].settings.consentGiven = true;
          window.sby.feeds[index].afterConsentToggled();
        });
      }
    });

    // Borlabs Cookie by Borlabs
    $(document).on('borlabs-cookie-consent-saved', function (event) {
      $.each(window.sby.feeds, function (index) {
        window.sby.feeds[index].settings.consentGiven = false;
        window.sby.feeds[index].afterConsentToggled();
      });
    });
    if (typeof window.consentApi !== 'undefined') {
      var _window$consentApi;
      (_window$consentApi = window.consentApi) === null || _window$consentApi === void 0 || _window$consentApi.consent("feeds-for-youtube").then(function () {
        try {
          // applies full features to feed
          $.each(window.sby.feeds, function (index) {
            window.sby.feeds[index].settings.consentGiven = true;
            window.sby.feeds[index].afterConsentToggled();
          });
        } catch (error) {
          // do nothing
        }
      });
    }
    $('.moove-gdpr-infobar-allow-all').on('click', function () {
      setTimeout(function () {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].afterConsentToggled();
        });
      }, 1000);
    });

    // WPConsent
    window.addEventListener('wpconsent_consent_saved', function (event) {
      setTimeout(function () {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].afterConsentToggled();
        });
      }, 1000);
    });
    window.addEventListener('wpconsent_consent_updated', function (event) {
      setTimeout(function () {
        $.each(window.sby.feeds, function (index) {
          window.sby.feeds[index].afterConsentToggled();
        });
      }, 1000);
    });

    // hide notice on click and send ajax request to backend
    $('#sby-frce-hide-license-error').on('click', function () {
      $('#sby-fr-ce-license-error').slideUp();
      jQuery.ajax({
        url: sbyOptions.adminAjaxUrl,
        type: 'post',
        data: {
          action: 'sby_hide_frontend_license_error',
          nonce: sbyOptions.nonce
        },
        success: function success(msg) {
          console.log(msg);
        }
      });
    });
  });
} // if sby_js_exists

if (window.sbySemiEagerLoading) {
  var sbyYScriptId = "sby-youtube-api";
  var sbyYScript = document.getElementById(sbyYScriptId);
  if (sbyYScript === null) {
    var tag = document.createElement("script");
    var firstScript = document.getElementsByTagName("script")[0];
    tag.src = "https://www.youtube.com/iframe_api";
    tag.id = sbyYScriptId;
    firstScript.parentNode.insertBefore(tag, firstScript);
  }
}
window.onYouTubeIframeAPIReady = function () {
  var numFeeds = document.getElementsByClassName('sb_youtube').length;
  if (numFeeds > 0) {
    if (window.sbySemiEagerLoading) {
      if (typeof window.sby !== 'undefined') {
        for (var i = 0; i < numFeeds; i++) {
          window.sby.feeds[i].playerAPIReady = true;
        }
      } else {
        window.sbyAPIReady = true;
      }
      sby_init();
    } else {
      if (window.sbyEagerLoading) {
        var flagLightbox = false,
          autoplay = false;
        jQuery('.sb_youtube').each(function (index) {
          var $self = jQuery(this);
          if ($self.hasClass('sby_layout_list')) {
            jQuery(this).addClass('sby_player_loaded');
            $self.find('.sby_item').each(function () {
              videoID = jQuery(this).attr('data-video-id');
              //this.createPlayer(,videoID,0);
              player = new YT.Player('sby_player_' + videoID, {
                height: '100',
                width: '100',
                videoId: videoID,
                playerVars: {
                  modestbranding: 1,
                  rel: 0,
                  autoplay: autoplay
                },
                events: {
                  'onStateChange': function onStateChange(data) {
                    var videoID = data.target.getVideoData()['video_id'];
                    if (data.data !== 1) return;
                    $self.find('.sby_item').each(function () {
                      var itemVidID = jQuery(this).attr('data-video-id');
                      if (jQuery(this).find('iframe').length && jQuery(data.target.a).attr('id') !== jQuery(this).find('iframe').attr('id')) {
                        YT.get('sby_player_' + itemVidID).pauseVideo();
                      }
                    });
                  }
                }
              });
            });
          } else if ($self.hasClass('sby_layout_gallery')) {
            jQuery(this).addClass('sby_player_loaded');
            player = new YT.Player('sby_player' + index, {
              height: '100',
              width: '100',
              videoId: jQuery(this).find('.sby_item').first().attr('data-video-id'),
              playerVars: {
                modestbranding: 1,
                rel: 0,
                autoplay: autoplay
              },
              events: {
                'onStateChange': function onStateChange(data) {
                  var videoID = data.target.getVideoData()['video_id'];
                  if (data.data !== 1) return;
                  $self.find('.sby_item').each(function () {
                    var itemVidID = jQuery(this).attr('data-video-id');
                    if (jQuery(this).find('iframe').length && jQuery(data.target.a).attr('id') !== jQuery(this).find('iframe').attr('id')) {
                      YT.get('sby_player_' + itemVidID).pauseVideo();
                    }
                  });
                }
              }
            });
          } else {
            flagLightbox = true;
          }
        });
      } else if (typeof window.sby !== 'undefined') {
        for (var i = 0; i < numFeeds; i++) {
          window.sby.feeds[i].playerAPIReady = true;
        }
      } else {
        window.sbyAPIReady = true;
      }
    }
    jQuery('.sb_youtube').each(function (index) {
      var $self = jQuery(this);
      if ($self.find('.sby_live_player').length) {
        player = new YT.Player($self.find('.sby_live_player').attr('id'), {
          events: {
            'onReady': function onReady() {
              $self.find('.sby_live_player').hide();
              $self.find('.sby_item').remove();
              var videoID = YT.get($self.find('.sby_live_player').attr('id')).getVideoData().video_id;
              $self.find('.sby_player_video_thumbnail').attr('data-video-id', videoID).css('z-index', -1);
              var itemOffset = $self.find('.sby_item').length,
                submitData = {
                  action: 'sby_live_retrieve',
                  video_id: videoID,
                  feed_id: $self.attr('data-feedid'),
                  atts: $self.attr('data-shortcode-atts')
                };
              var onSuccess = function onSuccess(data) {
                if (data.trim().indexOf('{') === 0) {
                  var feed = window.sby.feeds[index],
                    response = JSON.parse(data),
                    checkWPPosts = typeof response.feedStatus.checkWPPosts !== 'undefined' ? response.feedStatus.checkWPPosts : false;
                  if (feed.settings.debugEnabled) {
                    console.log(response);
                  }
                  if (checkWPPosts) {
                    feed.settings.checkWPPosts = true;
                  } else {
                    feed.settings.checkWPPosts = false;
                  }
                  feed.appendNewPosts(response.html);
                  feed.addResizedImages(response.resizedImages);
                  feed.afterInitialImagesLoaded();
                  if (!response.feedStatus.shouldPaginate) {
                    feed.outOfPages = true;
                    $self.find('.sby_load_btn').hide();
                  } else {
                    feed.outOfPages = false;
                  }
                  jQuery('.sby_no_js').removeClass('sby_no_js');
                  $self.find('.sby_live_player').remove();
                  if ($self.hasClass('sby_layout_gallery')) {
                    feed.createPlayer('sby_player' + feed.index);
                  }
                  $self.find('.sby_player_item').css('opacity', 1);
                  $self.find('.sby_item').css('opacity', 1);
                  $self.find('.sby_player_loading').removeClass('sby_player_loading');
                  if ($self.hasClass('sby_layout_list')) {
                    $self.find('.sby_item_video_thumbnail').on('mouseenter', function () {
                      jQuery(this).css('z-index', -1);
                    });
                  }
                }
              };
              jQuery.ajax({
                url: sbyOptions.adminAjaxUrl,
                type: 'post',
                data: submitData,
                success: onSuccess
              });
            }
          }
        });
      }
    });
    if (flagLightbox) {
      if (!jQuery('#sby_lb-player').length) {
        jQuery('.sb_youtube').first().append('<div class="sby_lb-player-loaded sby_lb-player" id="sby_lb-player" style="display: none;"></div>');
      }
      player = new YT.Player('sby_lb-player', {
        height: '100',
        width: '100',
        videoId: jQuery(this).find('.sby_item').first().attr('data-video-id'),
        playerVars: {
          modestbranding: 1,
          rel: 0,
          autoplay: autoplay
        }
      });
      window.sbyLightboxPlayer = player;
    }
  }
  if (typeof window.sby !== 'undefined') {
    var evt = jQuery.Event('sbyfeedandytready');
    jQuery(window).trigger(evt);
  }
};

/**
 * Retrieves a specific attribute value from the given API data object.
 * 
 * @param {Object} rootPath
 * @param {string} attrName
 * 
 * @returns {string|boolean}
 */

function getSingleApiData(rootPath, attrName) {
  var _rootPath$snippet, _rootPath$snippet2, _rootPath$snippet3, _rootPath$snippet4, _rootPath$snippet5, _rootPath$snippet6;
  switch (attrName) {
    case 'authorProfileImageUrl':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet = rootPath.snippet) !== null && _rootPath$snippet !== void 0 && _rootPath$snippet.authorProfileImageUrl ? rootPath.snippet.authorProfileImageUrl : '';
    case 'authorDisplayName':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet2 = rootPath.snippet) !== null && _rootPath$snippet2 !== void 0 && _rootPath$snippet2.authorDisplayName ? rootPath.snippet.authorDisplayName : '';
    case 'authorChannelUrl':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet3 = rootPath.snippet) !== null && _rootPath$snippet3 !== void 0 && _rootPath$snippet3.authorChannelUrl ? rootPath.snippet.authorChannelUrl : '';
    case 'textDisplay':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet4 = rootPath.snippet) !== null && _rootPath$snippet4 !== void 0 && _rootPath$snippet4.textDisplay ? rootPath.snippet.textDisplay : '';
    case 'likeCount':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet5 = rootPath.snippet) !== null && _rootPath$snippet5 !== void 0 && _rootPath$snippet5.likeCount ? rootPath.snippet.likeCount : '';
    case 'publishedAt':
      return rootPath !== null && rootPath !== void 0 && (_rootPath$snippet6 = rootPath.snippet) !== null && _rootPath$snippet6 !== void 0 && _rootPath$snippet6.publishedAt ? rootPath.snippet.publishedAt : '';
    case 'totalReplyCount':
      return rootPath !== null && rootPath !== void 0 && rootPath.totalReplyCount ? rootPath.totalReplyCount : '';
    default:
      return false;
  }
}

/**
 * Retrieves a static SVG image based on the provided name.
 * @param {string} name 
 * @returns {string|boolean} 
 */
function getStaticSVG(name) {
  switch (name) {
    case 'profile-picture':
      return '<svg fill="currentColor" width="800px" height="800px" viewBox="0 0 512 512" id="_x30_1" version="1.1" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M256,0C114.615,0,0,114.615,0,256s114.615,256,256,256s256-114.615,256-256S397.385,0,256,0z M256,90  c37.02,0,67.031,35.468,67.031,79.219S293.02,248.438,256,248.438s-67.031-35.468-67.031-79.219S218.98,90,256,90z M369.46,402  H142.54c-11.378,0-20.602-9.224-20.602-20.602C121.938,328.159,181.959,285,256,285s134.062,43.159,134.062,96.398  C390.062,392.776,380.839,402,369.46,402z"/></svg>';
    case 'thumbs-up':
      return '<svg width="15" height="13" viewBox="0 0 15 13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.4159 4.18027C13.761 4.18027 14.0778 4.32177 14.3664 4.60477C14.6549 4.88777 14.7992 5.20738 14.7992 5.5636V6.2706C14.7992 6.36471 14.7902 6.45188 14.7722 6.5321C14.7542 6.61232 14.7272 6.69266 14.6912 6.7731L12.684 11.4908C12.5845 11.7449 12.4181 11.9486 12.1849 12.1019C11.9517 12.2552 11.69 12.3318 11.3999 12.3318H5.15938C4.77282 12.3318 4.44566 12.2006 4.17788 11.9383C3.90999 11.6759 3.77604 11.346 3.77604 10.9484V4.7561C3.77604 4.56277 3.81332 4.38049 3.88788 4.20927C3.96254 4.03804 4.06477 3.88754 4.19454 3.75777L7.28938 0.662932C7.5186 0.431043 7.79427 0.281321 8.11638 0.213765C8.43849 0.146321 8.71416 0.178988 8.94338 0.311765C9.22549 0.46421 9.40932 0.695932 9.49488 1.00693C9.58032 1.31793 9.58999 1.62804 9.52388 1.93727L9.09554 4.18027H13.4159ZM1.34404 12.3318C1.01393 12.3318 0.726767 12.2097 0.482544 11.9654C0.238322 11.7212 0.116211 11.434 0.116211 11.1039V5.40827C0.116211 5.07804 0.236989 4.79082 0.478544 4.5466C0.7201 4.30238 1.00466 4.18027 1.33221 4.18027H1.34804C1.67827 4.18027 1.96549 4.30238 2.20971 4.5466C2.45393 4.79082 2.57604 5.07804 2.57604 5.40827V11.1039C2.57604 11.434 2.45393 11.7212 2.20971 11.9654C1.96549 12.2097 1.67827 12.3318 1.34804 12.3318H1.34404Z" fill="currentColor"/></svg>';
    case 'angle-down':
      return '<svg width="8" height="6" viewBox="0 0 8 6" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0.94 0.726654L4 3.77999L7.06 0.726654L8 1.66665L4 5.66665L0 1.66665L0.94 0.726654Z" fill="currentColor"/></svg>';
    case 'youtube':
      return '<svg width="14" height="11" viewBox="0 0 14 11" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M5.66671 7.5L9.12671 5.5L5.66671 3.5V7.5ZM13.3734 2.28C13.46 2.59334 13.52 3.01334 13.56 3.54667C13.6067 4.08 13.6267 4.54 13.6267 4.94L13.6667 5.5C13.6667 6.96 13.56 8.03334 13.3734 8.72C13.2067 9.32 12.82 9.70667 12.22 9.87334C11.9067 9.96 11.3334 10.02 10.4534 10.06C9.58671 10.1067 8.79337 10.1267 8.06004 10.1267L7.00004 10.1667C4.20671 10.1667 2.46671 10.06 1.78004 9.87334C1.18004 9.70667 0.793374 9.32 0.626707 8.72C0.540041 8.40667 0.480041 7.98667 0.440041 7.45334C0.393374 6.92 0.373374 6.46 0.373374 6.06L0.333374 5.5C0.333374 4.04 0.440041 2.96667 0.626707 2.28C0.793374 1.68 1.18004 1.29334 1.78004 1.12667C2.09337 1.04 2.66671 0.980002 3.54671 0.940002C4.41337 0.893336 5.20671 0.873336 5.94004 0.873336L7.00004 0.833336C9.79337 0.833336 11.5334 0.940003 12.22 1.12667C12.82 1.29334 13.2067 1.68 13.3734 2.28Z" fill="currentColor"/></svg>';
    case 'cross':
      return '<svg width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.25 1.41L12.84 0L7.25 5.59L1.66 0L0.25 1.41L5.84 7L0.25 12.59L1.66 14L7.25 8.41L12.84 14L14.25 12.59L8.66 7L14.25 1.41Z" fill="currentColor"/></svg>';
    case 'message':
      return '<svg width="28" height="26" viewBox="0 0 28 26" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3.33341 22C2.60008 22 1.9723 21.7389 1.45008 21.2167C0.927859 20.6944 0.666748 20.0667 0.666748 19.3333V3.33334C0.666748 2.6 0.927859 1.97223 1.45008 1.45001C1.9723 0.927783 2.60008 0.666672 3.33341 0.666672H24.6667C25.4001 0.666672 26.0279 0.927783 26.5501 1.45001C27.0723 1.97223 27.3334 2.6 27.3334 3.33334V24.1C27.3334 24.7 27.0612 25.1167 26.5167 25.35C25.9723 25.5833 25.489 25.4889 25.0667 25.0667L22.0001 22H3.33341ZM23.1334 19.3333L24.6667 20.8333V3.33334H3.33341V19.3333H23.1334Z" fill="currentColor"/></svg>';
    default:
      return false;
  }
}

/**
 * Generates the HTML template for a single comment.
 * 
 * @param {string} authorProfileImageUrl
 * @param {string} authorDisplayName
 * @param {string} authorChannelUrl
 * @param {string} textDisplay
 * @param {number} likeCount
 * @param {string} publishedAt
 * @param {number} totalReplyCount
 * 
 * @returns {string}
 */
function commentSingleTemplate(authorProfileImageUrl, authorDisplayName, authorChannelUrl, textDisplay, likeCount, publishedAt, totalReplyCount) {
  var dummyProfilePic = authorProfileImageUrl ? "<img src=".concat(authorProfileImageUrl, " loading=\"lazy\" referrerPolicy=\"no-referrer\"/>") : getStaticSVG('profile-picture');
  var replies = totalReplyCount ? "<button class=\"sby-replies\">".concat(totalReplyCount ? totalReplyCount : 0, " Replies ").concat(getStaticSVG('angle-down'), "</button>") : '';
  return "\n            <div class=\"sby-comment-profile-pic\">\n                ".concat(dummyProfilePic, "\n            </div>\n            <div class=\"sby-comment-heading\">\n                <a href=\"").concat(authorChannelUrl, "\" target=\"_blank\" class=\"sby-comment-user-name\">").concat(authorDisplayName, "</a>\n                <span>").concat(timeAgo(publishedAt), "</span>\n            </div>\n                <div class=\"sby-comment-text\">\n                <p class=\"sby-read-more-target\">").concat(textDisplay, "</p>\n                <div class=\"sby-read-more-trigger\">\n                    <button class=\"sby-read-more-text\">Read More</button>\n                    <button class=\"sby-read-less-text\">Read Less</button>\n                </div>\n             </div>\n            <div class=\"sby-comment-bottom\">\n                <span class=\"sby-comment-likes\">\n                    ").concat(getStaticSVG('thumbs-up'), " ").concat(likeCount ? formatLargeNumber(likeCount) : 0, "\n                </span>\n                ").concat(replies, "\n            </div>\n    ");
}

/**
 * Generates the HTML template when no comments are found.
 *
 * @returns {string}
 */

function noCommentsTemplate() {
  return "\n        <h4 class=\"sby-comments-sub-heading\">Comments</h4>\n        <div class=\"sby-no-comments\">\n            ".concat(getStaticSVG('message'), "\n            <p>There are no comments to display</p>\n        </div>");
}

/**
 * Generates the HTML template when there is an error retriving comments.
 *
 * @returns {string}
 */
function errorCommentTemplate(error) {
  return "\n        <h4 class=\"sby-comments-sub-heading\">Comments</h4>\n        <div class=\"sby-no-comments\">\n            <p>".concat(error, "</p>\n        </div>");
}

/**
 * Format date and time for ISO 8601
 * 
 * @param timestamp
 * 
 * @returns {string}
 */
function timeAgo(timestamp) {
  var now = new Date();
  var past = new Date(timestamp);
  var diffMs = now - past;

  // Helper functions to get time units
  var seconds = Math.floor(diffMs / 1000);
  var minutes = Math.floor(seconds / 60);
  var hours = Math.floor(minutes / 60);
  var days = Math.floor(hours / 24);
  var months = Math.floor(days / 30);
  var years = Math.floor(months / 12);

  // Determine the largest unit of time that applies
  if (years > 0) {
    return "".concat(years, " year").concat(years > 1 ? 's' : '', " ago");
  }
  if (months > 0) {
    return "".concat(months, " month").concat(months > 1 ? 's' : '', " ago");
  }
  if (days > 0) {
    return "".concat(days, " day").concat(days > 1 ? 's' : '', " ago");
  }
  if (hours > 0) {
    return "".concat(hours, " hour").concat(hours > 1 ? 's' : '', " ago");
  }
  if (minutes > 0) {
    return "".concat(minutes, " minute").concat(minutes > 1 ? 's' : '', " ago");
  }
  if (seconds > 0) {
    return "".concat(seconds, " second").concat(seconds > 1 ? 's' : '', " ago");
  }
  return 'just now';
}

/**
 * Converts plain text into HTML with clickable links.
 * 
 * @param {string} text
 * 
 * @returns {string} 
 */
function addLinksTotext(text) {
  //Add links to the caption
  if (!text) {
    return '';
  }
  text = text.replace(/(>#)/g, '> #');
  return sbyLinkify(text);
}

/**
 * Convert Unix timestamp to milliseconds
 * @param timestamp
 * @returns {string}
 */

function convertUnixToMs(timestamp) {
  if (!timestamp) {
    return '';
  }
  return new Date(parseInt(timestamp) * 1000);
}

/**
 * Toggles the visibility of accordion sections based on the trigger element.
 * 
 * @param {string} className
 * @param {string} target
 * @param {string} parent
 * @param {string} trigger 
 * 
 * @returns {void} 
 */
function toggleAccordion(className, target, parent, trigger) {
  jQuery(trigger).css('display', 'none');
  jQuery(target).unbind('click');
  jQuery(target).click(function () {
    jQuery(this).toggleClass(className + '-trigger');
    jQuery(this).closest(parent).find(trigger).toggle();
  });
}
/**
 * Toggles the visibility of "Read More" buttons
 * 
 * @returns {void}
 */
function toggleReadMore() {
  var target = jQuery('.sby-read-more-target');
  var triggerClassName = '.sby-read-more-trigger';
  target.each(function (e) {
    var currentTarget = jQuery(this)[0];
    var paragraphHeight = currentTarget.scrollHeight;
    var clientHeight = currentTarget.offsetHeight;
    var hasMoreThanFourLines = paragraphHeight > clientHeight && paragraphHeight > clientHeight + 1; // clientHeight + 1 to fix firefox clientHeight calculate issue.

    if (hasMoreThanFourLines) {
      var trigger = jQuery(this).parent().find(triggerClassName);
      trigger.unbind('click');
      trigger.click(function () {
        jQuery(this).toggleClass('sby-read-more-trigger-active');
        jQuery(this).parent().find('.sby-read-more-target').toggleClass('sby-read-more-target-active');
      });
    } else {
      jQuery(this).parent().find(triggerClassName).hide();
    }
  });
}

/**
 * Applies a color scheme class to the lightbox based on the flag provided.
 * 
 * @param {string} colorScheme 
 * @param {boolean} flag
 */
function LightboxColorScheme(colorScheme, flag) {
  var commentWrap = jQuery('.sby_lb-caption');
  var colorSchemeClassName = 'sby-lb-dark-scheme';
  if (false === flag) {
    commentWrap.removeClass(colorSchemeClassName);
    return false;
  }
  if ('dark' === colorScheme && true === flag) {
    commentWrap.addClass(colorSchemeClassName);
    return false;
  }
}

/**
 * Resets the body's overflow style and the lightbox color scheme when the lightbox is closed.
 *
 * @returns {void}
 */
function lightboxOnClose() {
  jQuery('body').css('overflow', 'auto');
  LightboxColorScheme('', false);
  jQuery('.sby_gdpr_notice').remove();
}

/**
 * Retrieves the layout type of the closest ancestor element with a specific layout class.
 *
 * @param {jQuery|HTMLElement} target
 * @returns {string|boolean}
 */
function getLayout(target) {
  var currentTarget = target.closest('.sb_youtube');
  if (currentTarget.hasClass('sby_layout_list')) {
    return 'list';
  }
  if (currentTarget.hasClass('sby_layout_grid')) {
    return 'grid';
  }
  if (currentTarget.hasClass('sby_layout_carousel')) {
    return 'carousel';
  }
  if (currentTarget.hasClass('sby_layout_gallery')) {
    return 'gallery';
  }
  return false;
}

/**
 * Opens and displays the comments section on the page.
 * 
 * @returns {void}
 */
function openComments() {
  if (!window.sbyOptions.isPro) {
    return false;
  }
  var openCommentTrigger = jQuery('.sby-comments-trigger');
  openCommentTrigger.unbind('click');
  openCommentTrigger.click(function () {
    var commentWrapClass = '.sby-comments-wrap';
    var commentSecionWrap = jQuery(this).closest('.sby-comment-container');
    var commentSection = commentSecionWrap.find(commentWrapClass);
    var currentLayout = getLayout(jQuery(this));
    if (commentSection.text().length <= 0) {
      var commentCount;
      var videoId;
      var target;
      if ('gallery' === currentLayout) {
        var targetParent = jQuery(this).closest('.sb_youtube');
        var currentTarget = targetParent.find('.sby_item.sby_current');
        if (targetParent && currentTarget) {
          videoId = checkValue(currentTarget.attr('data-video-id'));
          commentCount = checkValue(currentTarget.find('a').attr('data-comment-count'));
          target = targetParent.find(commentWrapClass);
        }
      }
      if ('list' === currentLayout) {
        var _currentTarget = jQuery(this).closest('.sby_item');
        if (_currentTarget) {
          videoId = checkValue(_currentTarget.attr('data-video-id'));
          commentCount = checkValue(_currentTarget.find('a').attr('data-comment-count'));
          target = _currentTarget.find(commentWrapClass);
        }

        // Reset all other comments opened 
        resetComments(jQuery(this).closest('.sb_youtube'));
      }
      var atts = checkValue(jQuery(this).closest('.sb_youtube').attr('data-shortcode-atts'));
      generateCommentSection(videoId, atts, target, commentCount);
      commentSection.addClass('sby-comments-active');
    } else {
      commentSection.toggle();
      commentSection.toggleClass('sby-comments-active');
    }
    var currentTextState = commentSecionWrap.find('.sby-comments-trigger p');
    if (currentTextState) {
      changeTextOnToggle(currentTextState, 'Show Comments', 'Hide Comments');
    }
  });
}

/**
 * Returns a valid value or an empty string based on the input.
 * @param {*} element 
 * @returns {string} 
 */
function checkValue(element) {
  return element ? element : '';
}

/**
 * Sends an AJAX request with the specified data and handles the response.
 * @param {Object} submitData
 * @param {Function} onSuccess 
 * 
 * @returns {void} 
 */
function sbyAjax(submitData, onSuccess) {
  jQuery.ajax({
    url: sbyOptions.adminAjaxUrl,
    type: 'post',
    data: submitData,
    success: onSuccess
  });
}

/**
 * Fetches and generates a comment section for a given video.
 * 
 * @param {string} videoId 
 * @param {Object} atts
 * @param {jQuery} target
 * 
 * @returns {void}
 */

function generateCommentSection(videoId, atts, target, commentCount) {
  submitData = {
    action: 'sby_get_comments',
    video_id: videoId,
    atts: atts
  };
  var onSuccess = function onSuccess(data) {
    var _commentJson$error;
    if (!data) {
      return false;
    }
    if (false === data.success) {
      target.html(errorCommentTemplate(data.data));
      return false;
    }
    var commentJson = JSON.parse(data);
    if (!commentJson) {
      return false;
    }
    if (commentJson !== null && commentJson !== void 0 && commentJson.success && false === commentJson.success) {
      target.html(errorCommentTemplate(commentJson.data));
      return false;
    }
    if (commentJson !== null && commentJson !== void 0 && commentJson.error && commentJson !== null && commentJson !== void 0 && (_commentJson$error = commentJson.error) !== null && _commentJson$error !== void 0 && _commentJson$error.message) {
      var errorMessage = commentJson.error.message;
      if (errorMessage.includes('disabled comments')) {
        errorMessage = 'Comments are turned off';
      }
      target.html(errorCommentTemplate(errorMessage));
      return false;
    }
    var noOfItems = commentJson !== null && commentJson !== void 0 && commentJson.items && commentJson !== null && commentJson !== void 0 && commentJson.items.length ? commentJson.items.length : '';
    var videoLink = videoId ? "https://www.youtube.com/watch?v=".concat(videoId) : '';
    if (!noOfItems) {
      target.html(noCommentsTemplate());
      toggleReadMore();
      return false;
    }
    currentCommentCount = commentCount ? "( ".concat(commentCount, " )") : '';
    var commentHtml = "<h4 class=\"sby-comments-sub-heading\">Comments ".concat(currentCommentCount, "</h4><ul class=\"sby-comments\">");
    jQuery.each(commentJson.items, function (index, comment) {
      var _comment$snippet, _comment$replies;
      var topLevelCommentPath = comment === null || comment === void 0 || (_comment$snippet = comment.snippet) === null || _comment$snippet === void 0 ? void 0 : _comment$snippet.topLevelComment;
      var topLevelCommentSnippet = comment === null || comment === void 0 ? void 0 : comment.snippet;

      // Generate the HTML for each comment
      commentHtml += "<li class=\"sby-comment\">".concat(commentSingleTemplate(getSingleApiData(topLevelCommentPath, 'authorProfileImageUrl'), getSingleApiData(topLevelCommentPath, 'authorDisplayName'), getSingleApiData(topLevelCommentPath, 'authorChannelUrl'), getSingleApiData(topLevelCommentPath, 'textDisplay'), getSingleApiData(topLevelCommentPath, 'likeCount'), getSingleApiData(topLevelCommentPath, 'publishedAt'), getSingleApiData(topLevelCommentSnippet, 'totalReplyCount')), "\n            <ul class=\"sby-reply-comments\">");
      if (comment !== null && comment !== void 0 && (_comment$replies = comment.replies) !== null && _comment$replies !== void 0 && _comment$replies.comments) {
        // Use $.each to loop through replies
        jQuery.each(comment.replies.comments, function (replyIndex, reply) {
          commentHtml += "<li class=\"sby-reply-comment\" >".concat(commentSingleTemplate(getSingleApiData(reply, 'authorProfileImageUrl'), getSingleApiData(reply, 'authorDisplayName'), getSingleApiData(reply, 'authorChannelUrl'), getSingleApiData(reply, 'textDisplay'), getSingleApiData(reply, 'likeCount'), getSingleApiData(reply, 'publishedAt')), "</li>");
        });
      }
      // Close the comment container
      commentHtml += "</ul></li>";
    });
    commentHtml += "</ul>";
    commentHtml += "<a href=\"".concat(videoLink, "\" target=\"_blank\" class=\"sby-view-all-button \">View all comments on YouTube</a>");
    target.html(commentHtml).fadeIn("fast");
    toggleReadMore();
    toggleAccordion('sby-active', '.sby-replies', '.sby-comment', '.sby-reply-comments');
  };
  toggleReadMore();
  sbyAjax(submitData, onSuccess);
}

/**
 * Toggles the text of an element based on its current content.
 *
 * This function updates the text of an element if the element's current text
 * matches the specified `currentText`. If it matches, the text is replaced with
 * the provided `replacementText`. If it does not match, the text remains as `currentText`.
 *
 * @param {Object} currentState
 * @param {string} currentText
 * @param {string} replacementText
 * 
 * @returns {void} 
 */

function changeTextOnToggle(currentState, currentText, replacementText) {
  if (currentState && currentText && replacementText) {
    var currentStateText = currentText === currentState.text() ? replacementText : currentText;
    currentState.text(currentStateText);
  }
}

/**
 * Resets the comments of a specified parent element.
 *
 * @param {jQuery} parent
 *
 * @returns {void} 
 */

function resetComments(parent) {
  if ('gallery' === getLayout(parent) || 'list' === getLayout(parent)) {
    var trigger = parent.find('.sby-comments-trigger');
    trigger.find('p').text('Show Comments');
    parent.find('.sby-comments-wrap').html('');
  }
}

/**
 * Formats a large number into a more readable string with a suffix.
 * The function converts large numbers into a string with a suffix to denote the scale of the number.
 *
 * @param {number} num
 * 
 * @returns {string}
 */

function formatLargeNumber(num) {
  if (num >= 1e9) return (num / 1e9).toFixed(1) + 'B';
  if (num >= 1e6) return (num / 1e6).toFixed(1) + 'M';
  if (num >= 1e3) return (num / 1e3).toFixed(1) + 'K';
  return num;
}

/**
 * Applies a set of colors to the channel header.
 * 
 * @param {Object} colorArray - An object containing color properties for the channel header.
 * @param {string} colorArray.channelName - The text color for the channel name element.
 * @param {string} colorArray.subscribeCount - The text color for the subscribe count element.
 * @param {string} colorArray.buttonBackground - The background color for the button element.
 * @param {string} colorArray.buttonText - The text color for the button element.
 * 
 * @returns {void}
 */
function setColorsToChannelHeader(colorArray) {
  var channelName = colorArray.channelName,
    subscribeCount = colorArray.subscribeCount,
    buttonBackground = colorArray.buttonBackground,
    buttonText = colorArray.buttonText;
  var parent = jQuery('.sby_lb-dataContainer .sby-lb-channel-header');
  if (!parent) {
    return false;
  }
  if (channelName) {
    parent.find('.sby-lb-channel-name-with-subs span:first-child').css('color', channelName);
  }
  if (subscribeCount) {
    parent.find('.sby-lb-channel-name-with-subs span:nth-child(2)').css('color', subscribeCount);
  }
  if (buttonBackground) {
    parent.find('.sby-lb-subscribe-btn').css('background', buttonBackground);
  }
  if (buttonText) {
    parent.find('.sby-lb-subscribe-btn').css('color', buttonText);
  }
}
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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